/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.common.ChangeListener;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.data.ApprovalAttribute;
import com.google.gerrit.server.events.ChangeAbandonedEvent;
import com.google.gerrit.server.events.ChangeEvent;
import com.google.gerrit.server.events.ChangeMergedEvent;
import com.google.gerrit.server.events.ChangeRestoredEvent;
import com.google.gerrit.server.events.CommentAddedEvent;
import com.google.gerrit.server.events.DraftPublishedEvent;
import com.google.gerrit.server.events.EventFactory;
import com.google.gerrit.server.events.MergeFailedEvent;
import com.google.gerrit.server.events.PatchSetCreatedEvent;
import com.google.gerrit.server.events.RefUpdatedEvent;
import com.google.gerrit.server.events.ReviewerAddedEvent;
import com.google.gerrit.server.events.TopicChangedEvent;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChangeHookRunner
implements ChangeHooks,
LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(ChangeHookRunner.class);
    private final Map<ChangeListener, ChangeListenerHolder> listeners = new ConcurrentHashMap<ChangeListener, ChangeListenerHolder>();
    private final DynamicSet<ChangeListener> unrestrictedListeners;
    private final File patchsetCreatedHook;
    private final File draftPublishedHook;
    private final File commentAddedHook;
    private final File changeMergedHook;
    private final File mergeFailedHook;
    private final File changeAbandonedHook;
    private final File changeRestoredHook;
    private final File refUpdatedHook;
    private final File reviewerAddedHook;
    private final File topicChangedHook;
    private final File claSignedHook;
    private final File refUpdateHook;
    private final String anonymousCowardName;
    private final GitRepositoryManager repoManager;
    private final WorkQueue.Executor hookQueue;
    private final ProjectCache projectCache;
    private final AccountCache accountCache;
    private final EventFactory eventFactory;
    private final SitePaths sitePaths;
    private final ExecutorService syncHookThreadPool;
    private final int syncHookTimeout;

    @Inject
    public ChangeHookRunner(WorkQueue queue, GitRepositoryManager repoManager, @GerritServerConfig Config config, @AnonymousCowardName String anonymousCowardName, SitePaths sitePath, ProjectCache projectCache, AccountCache accountCache, EventFactory eventFactory, SitePaths sitePaths, DynamicSet<ChangeListener> unrestrictedListeners) {
        this.anonymousCowardName = anonymousCowardName;
        this.repoManager = repoManager;
        this.hookQueue = queue.createQueue(1, "hook");
        this.projectCache = projectCache;
        this.accountCache = accountCache;
        this.eventFactory = eventFactory;
        this.sitePaths = sitePath;
        this.unrestrictedListeners = unrestrictedListeners;
        File hooksPath = sitePath.resolve(this.getValue(config, "hooks", "path", sitePath.hooks_dir.getAbsolutePath()));
        this.patchsetCreatedHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "patchsetCreatedHook", "patchset-created")).getPath());
        this.draftPublishedHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "draftPublishedHook", "draft-published")).getPath());
        this.commentAddedHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "commentAddedHook", "comment-added")).getPath());
        this.changeMergedHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "changeMergedHook", "change-merged")).getPath());
        this.mergeFailedHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "mergeFailed", "merge-failed")).getPath());
        this.changeAbandonedHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "changeAbandonedHook", "change-abandoned")).getPath());
        this.changeRestoredHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "changeRestoredHook", "change-restored")).getPath());
        this.refUpdatedHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "refUpdatedHook", "ref-updated")).getPath());
        this.reviewerAddedHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "reviewerAddedHook", "reviewer-added")).getPath());
        this.topicChangedHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "topicChangedHook", "topic-changed")).getPath());
        this.claSignedHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "claSignedHook", "cla-signed")).getPath());
        this.refUpdateHook = sitePath.resolve(new File(hooksPath, this.getValue(config, "hooks", "refUpdateHook", "ref-update")).getPath());
        this.syncHookTimeout = config.getInt("hooks", "syncHookTimeout", 30);
        this.syncHookThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("SyncHook-%d").build());
    }

    @Override
    public void addChangeListener(ChangeListener listener, IdentifiedUser user) {
        this.listeners.put(listener, new ChangeListenerHolder(listener, user));
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private String getValue(Config config, String section, String setting, String fallback) {
        String result = config.getString(section, null, setting);
        return result == null ? fallback : result;
    }

    private Repository openRepository(Project.NameKey name) {
        try {
            return this.repoManager.openRepository(name);
        }
        catch (IOException err) {
            log.warn("Cannot open repository " + name.get(), err);
            return null;
        }
    }

    private void addArg(List<String> args, String name, String value) {
        if (value != null) {
            args.add(name);
            args.add(value);
        }
    }

    @Override
    public HookResult doRefUpdateHook(Project project, String refname, Account uploader, ObjectId oldId, ObjectId newId) {
        HookResult hookResult;
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "--project", project.getName());
        this.addArg(args, "--refname", refname);
        this.addArg(args, "--uploader", this.getDisplayName(uploader));
        this.addArg(args, "--oldrev", oldId.getName());
        this.addArg(args, "--newrev", newId.getName());
        try {
            hookResult = this.runSyncHook(project.getNameKey(), this.refUpdateHook, args);
        }
        catch (TimeoutException e) {
            hookResult = new HookResult(-1, "Synchronous hook timed out");
        }
        return hookResult;
    }

    @Override
    public void doPatchsetCreatedHook(Change change, PatchSet patchSet, ReviewDb db) throws OrmException {
        PatchSetCreatedEvent event = new PatchSetCreatedEvent();
        AccountState uploader = this.accountCache.get(patchSet.getUploader());
        event.change = this.eventFactory.asChangeAttribute(change);
        event.patchSet = this.eventFactory.asPatchSetAttribute(patchSet);
        event.uploader = this.eventFactory.asAccountAttribute(uploader.getAccount());
        this.fireEvent(change, event, db);
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "--change", event.change.id);
        this.addArg(args, "--is-draft", patchSet.isDraft() ? "true" : "false");
        this.addArg(args, "--change-url", event.change.url);
        this.addArg(args, "--project", event.change.project);
        this.addArg(args, "--branch", event.change.branch);
        this.addArg(args, "--topic", event.change.topic);
        this.addArg(args, "--uploader", this.getDisplayName(uploader.getAccount()));
        this.addArg(args, "--commit", event.patchSet.revision);
        this.addArg(args, "--patchset", event.patchSet.number);
        this.runHook(change.getProject(), this.patchsetCreatedHook, args);
    }

    @Override
    public void doDraftPublishedHook(Change change, PatchSet patchSet, ReviewDb db) throws OrmException {
        DraftPublishedEvent event = new DraftPublishedEvent();
        AccountState uploader = this.accountCache.get(patchSet.getUploader());
        event.change = this.eventFactory.asChangeAttribute(change);
        event.patchSet = this.eventFactory.asPatchSetAttribute(patchSet);
        event.uploader = this.eventFactory.asAccountAttribute(uploader.getAccount());
        this.fireEvent(change, event, db);
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "--change", event.change.id);
        this.addArg(args, "--change-url", event.change.url);
        this.addArg(args, "--project", event.change.project);
        this.addArg(args, "--branch", event.change.branch);
        this.addArg(args, "--topic", event.change.topic);
        this.addArg(args, "--uploader", this.getDisplayName(uploader.getAccount()));
        this.addArg(args, "--commit", event.patchSet.revision);
        this.addArg(args, "--patchset", event.patchSet.number);
        this.runHook(change.getProject(), this.draftPublishedHook, args);
    }

    @Override
    public void doCommentAddedHook(Change change, Account account, PatchSet patchSet, String comment, Map<String, Short> approvals, ReviewDb db) throws OrmException {
        CommentAddedEvent event = new CommentAddedEvent();
        event.change = this.eventFactory.asChangeAttribute(change);
        event.author = this.eventFactory.asAccountAttribute(account);
        event.patchSet = this.eventFactory.asPatchSetAttribute(patchSet);
        event.comment = comment;
        LabelTypes labelTypes = this.projectCache.get(change.getProject()).getLabelTypes();
        if (approvals.size() > 0) {
            event.approvals = new ApprovalAttribute[approvals.size()];
            int i = 0;
            for (Map.Entry<String, Short> approval : approvals.entrySet()) {
                event.approvals[i++] = this.getApprovalAttribute(labelTypes, approval);
            }
        }
        this.fireEvent(change, event, db);
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "--change", event.change.id);
        this.addArg(args, "--is-draft", patchSet.isDraft() ? "true" : "false");
        this.addArg(args, "--change-url", event.change.url);
        this.addArg(args, "--project", event.change.project);
        this.addArg(args, "--branch", event.change.branch);
        this.addArg(args, "--topic", event.change.topic);
        this.addArg(args, "--author", this.getDisplayName(account));
        this.addArg(args, "--commit", event.patchSet.revision);
        this.addArg(args, "--comment", comment == null ? "" : comment);
        for (Map.Entry<String, Short> approval : approvals.entrySet()) {
            LabelType lt = labelTypes.byLabel(approval.getKey());
            if (lt == null) continue;
            this.addArg(args, "--" + lt.getName(), Short.toString(approval.getValue()));
        }
        this.runHook(change.getProject(), this.commentAddedHook, args);
    }

    @Override
    public void doChangeMergedHook(Change change, Account account, PatchSet patchSet, ReviewDb db) throws OrmException {
        ChangeMergedEvent event = new ChangeMergedEvent();
        event.change = this.eventFactory.asChangeAttribute(change);
        event.submitter = this.eventFactory.asAccountAttribute(account);
        event.patchSet = this.eventFactory.asPatchSetAttribute(patchSet);
        this.fireEvent(change, event, db);
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "--change", event.change.id);
        this.addArg(args, "--change-url", event.change.url);
        this.addArg(args, "--project", event.change.project);
        this.addArg(args, "--branch", event.change.branch);
        this.addArg(args, "--topic", event.change.topic);
        this.addArg(args, "--submitter", this.getDisplayName(account));
        this.addArg(args, "--commit", event.patchSet.revision);
        this.runHook(change.getProject(), this.changeMergedHook, args);
    }

    @Override
    public void doMergeFailedHook(Change change, Account account, PatchSet patchSet, String reason, ReviewDb db) throws OrmException {
        MergeFailedEvent event = new MergeFailedEvent();
        event.change = this.eventFactory.asChangeAttribute(change);
        event.submitter = this.eventFactory.asAccountAttribute(account);
        event.patchSet = this.eventFactory.asPatchSetAttribute(patchSet);
        event.reason = reason;
        this.fireEvent(change, event, db);
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "--change", event.change.id);
        this.addArg(args, "--change-url", event.change.url);
        this.addArg(args, "--project", event.change.project);
        this.addArg(args, "--branch", event.change.branch);
        this.addArg(args, "--topic", event.change.topic);
        this.addArg(args, "--submitter", this.getDisplayName(account));
        this.addArg(args, "--commit", event.patchSet.revision);
        this.addArg(args, "--reason", reason == null ? "" : reason);
        this.runHook(change.getProject(), this.mergeFailedHook, args);
    }

    @Override
    public void doChangeAbandonedHook(Change change, Account account, PatchSet patchSet, String reason, ReviewDb db) throws OrmException {
        ChangeAbandonedEvent event = new ChangeAbandonedEvent();
        event.change = this.eventFactory.asChangeAttribute(change);
        event.abandoner = this.eventFactory.asAccountAttribute(account);
        event.patchSet = this.eventFactory.asPatchSetAttribute(patchSet);
        event.reason = reason;
        this.fireEvent(change, event, db);
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "--change", event.change.id);
        this.addArg(args, "--change-url", event.change.url);
        this.addArg(args, "--project", event.change.project);
        this.addArg(args, "--branch", event.change.branch);
        this.addArg(args, "--topic", event.change.topic);
        this.addArg(args, "--abandoner", this.getDisplayName(account));
        this.addArg(args, "--commit", event.patchSet.revision);
        this.addArg(args, "--reason", reason == null ? "" : reason);
        this.runHook(change.getProject(), this.changeAbandonedHook, args);
    }

    @Override
    public void doChangeRestoredHook(Change change, Account account, PatchSet patchSet, String reason, ReviewDb db) throws OrmException {
        ChangeRestoredEvent event = new ChangeRestoredEvent();
        event.change = this.eventFactory.asChangeAttribute(change);
        event.restorer = this.eventFactory.asAccountAttribute(account);
        event.patchSet = this.eventFactory.asPatchSetAttribute(patchSet);
        event.reason = reason;
        this.fireEvent(change, event, db);
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "--change", event.change.id);
        this.addArg(args, "--change-url", event.change.url);
        this.addArg(args, "--project", event.change.project);
        this.addArg(args, "--branch", event.change.branch);
        this.addArg(args, "--topic", event.change.topic);
        this.addArg(args, "--restorer", this.getDisplayName(account));
        this.addArg(args, "--commit", event.patchSet.revision);
        this.addArg(args, "--reason", reason == null ? "" : reason);
        this.runHook(change.getProject(), this.changeRestoredHook, args);
    }

    @Override
    public void doRefUpdatedHook(Branch.NameKey refName, RefUpdate refUpdate, Account account) {
        this.doRefUpdatedHook(refName, refUpdate.getOldObjectId(), refUpdate.getNewObjectId(), account);
    }

    @Override
    public void doRefUpdatedHook(Branch.NameKey refName, ObjectId oldId, ObjectId newId, Account account) {
        RefUpdatedEvent event = new RefUpdatedEvent();
        if (account != null) {
            event.submitter = this.eventFactory.asAccountAttribute(account);
        }
        event.refUpdate = this.eventFactory.asRefUpdateAttribute(oldId, newId, refName);
        this.fireEvent(refName, event);
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "--oldrev", event.refUpdate.oldRev);
        this.addArg(args, "--newrev", event.refUpdate.newRev);
        this.addArg(args, "--refname", event.refUpdate.refName);
        this.addArg(args, "--project", event.refUpdate.project);
        if (account != null) {
            this.addArg(args, "--submitter", this.getDisplayName(account));
        }
        this.runHook(refName.getParentKey(), this.refUpdatedHook, args);
    }

    @Override
    public void doReviewerAddedHook(Change change, Account account, PatchSet patchSet, ReviewDb db) throws OrmException {
        ReviewerAddedEvent event = new ReviewerAddedEvent();
        event.change = this.eventFactory.asChangeAttribute(change);
        event.patchSet = this.eventFactory.asPatchSetAttribute(patchSet);
        event.reviewer = this.eventFactory.asAccountAttribute(account);
        this.fireEvent(change, event, db);
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "--change", event.change.id);
        this.addArg(args, "--change-url", event.change.url);
        this.addArg(args, "--project", event.change.project);
        this.addArg(args, "--branch", event.change.branch);
        this.addArg(args, "--reviewer", this.getDisplayName(account));
        this.runHook(change.getProject(), this.reviewerAddedHook, args);
    }

    @Override
    public void doTopicChangedHook(Change change, Account account, String oldTopic, ReviewDb db) throws OrmException {
        TopicChangedEvent event = new TopicChangedEvent();
        event.change = this.eventFactory.asChangeAttribute(change);
        event.changer = this.eventFactory.asAccountAttribute(account);
        event.oldTopic = oldTopic;
        this.fireEvent(change, event, db);
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "--change", event.change.id);
        this.addArg(args, "--project", event.change.project);
        this.addArg(args, "--branch", event.change.branch);
        this.addArg(args, "--changer", this.getDisplayName(account));
        this.addArg(args, "--old-topic", oldTopic);
        this.addArg(args, "--new-topic", event.change.topic);
        this.runHook(change.getProject(), this.topicChangedHook, args);
    }

    @Override
    public void doClaSignupHook(Account account, ContributorAgreement cla) {
        if (account != null) {
            ArrayList<String> args = new ArrayList<String>();
            this.addArg(args, "--submitter", this.getDisplayName(account));
            this.addArg(args, "--user-id", account.getId().toString());
            this.addArg(args, "--cla-name", cla.getName());
            this.runHook(this.claSignedHook, args);
        }
    }

    @Override
    public void postEvent(Change change, ChangeEvent event, ReviewDb db) throws OrmException {
        this.fireEvent(change, event, db);
    }

    @Override
    public void postEvent(Branch.NameKey branchName, ChangeEvent event) {
        this.fireEvent(branchName, event);
    }

    private void fireEventForUnrestrictedListeners(ChangeEvent event) {
        for (ChangeListener listener : this.unrestrictedListeners) {
            listener.onChangeEvent(event);
        }
    }

    private void fireEvent(Change change, ChangeEvent event, ReviewDb db) throws OrmException {
        for (ChangeListenerHolder holder : this.listeners.values()) {
            if (!this.isVisibleTo(change, holder.user, db)) continue;
            holder.listener.onChangeEvent(event);
        }
        this.fireEventForUnrestrictedListeners(event);
    }

    private void fireEvent(Branch.NameKey branchName, ChangeEvent event) {
        for (ChangeListenerHolder holder : this.listeners.values()) {
            if (!this.isVisibleTo(branchName, holder.user)) continue;
            holder.listener.onChangeEvent(event);
        }
        this.fireEventForUnrestrictedListeners(event);
    }

    private boolean isVisibleTo(Change change, IdentifiedUser user, ReviewDb db) throws OrmException {
        ProjectState pe = this.projectCache.get(change.getProject());
        if (pe == null) {
            return false;
        }
        ProjectControl pc = pe.controlFor(user);
        return pc.controlFor(change).isVisible(db);
    }

    private boolean isVisibleTo(Branch.NameKey branchName, IdentifiedUser user) {
        ProjectState pe = this.projectCache.get(branchName.getParentKey());
        if (pe == null) {
            return false;
        }
        ProjectControl pc = pe.controlFor(user);
        return pc.controlForRef(branchName).isVisible();
    }

    private ApprovalAttribute getApprovalAttribute(LabelTypes labelTypes, Map.Entry<String, Short> approval) {
        ApprovalAttribute a = new ApprovalAttribute();
        a.type = approval.getKey();
        LabelType lt = labelTypes.byLabel(approval.getKey());
        if (lt != null) {
            a.description = lt.getName();
        }
        a.value = Short.toString(approval.getValue());
        return a;
    }

    private String getDisplayName(Account account) {
        if (account != null) {
            String result;
            String string = result = account.getFullName() == null ? this.anonymousCowardName : account.getFullName();
            if (account.getPreferredEmail() != null) {
                result = result + " (" + account.getPreferredEmail() + ")";
            }
            return result;
        }
        return this.anonymousCowardName;
    }

    private synchronized void runHook(Project.NameKey project, File hook, List<String> args) {
        if (project != null && hook.exists()) {
            this.hookQueue.execute(new AsyncHookTask(project, hook, args));
        }
    }

    private synchronized void runHook(File hook, List<String> args) {
        if (hook.exists()) {
            this.hookQueue.execute(new AsyncHookTask(null, hook, args));
        }
    }

    private HookResult runSyncHook(Project.NameKey project, File hook, List<String> args) throws TimeoutException {
        String message;
        if (!hook.exists()) {
            return null;
        }
        SyncHookTask syncHook = new SyncHookTask(project, hook, args);
        FutureTask<HookResult> task = new FutureTask<HookResult>(syncHook);
        this.syncHookThreadPool.execute(task);
        try {
            return task.get(this.syncHookTimeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            message = "Synchronous hook timed out " + hook.getAbsolutePath();
            log.error(message);
        }
        catch (Exception e) {
            message = "Error running hook " + hook.getAbsolutePath();
            log.error(message, e);
        }
        task.cancel(true);
        syncHook.cancel();
        return new HookResult(syncHook.getOutput(), message);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        boolean isTerminated;
        this.syncHookThreadPool.shutdown();
        do {
            try {
                isTerminated = this.syncHookThreadPool.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                isTerminated = false;
            }
        } while (!isTerminated);
    }

    private final class AsyncHookTask
    extends HookTask
    implements Runnable {
        private AsyncHookTask(Project.NameKey project, File hook, List<String> args) {
            super(project, hook, args);
        }

        @Override
        public void run() {
            super.runHook();
        }
    }

    private final class SyncHookTask
    extends HookTask
    implements Callable<HookResult> {
        private SyncHookTask(Project.NameKey project, File hook, List<String> args) {
            super(project, hook, args);
        }

        @Override
        public HookResult call() throws Exception {
            return super.runHook();
        }
    }

    private class HookTask {
        private final Project.NameKey project;
        private final File hook;
        private final List<String> args;
        private StringWriter output;
        private Process ps;

        protected HookTask(Project.NameKey project, File hook, List<String> args) {
            this.project = project;
            this.hook = hook;
            this.args = args;
        }

        public String getOutput() {
            return this.output != null ? this.output.toString() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HookResult runHook() {
            HookResult result = null;
            try (Repository repo = null;){
                ArrayList<String> argv = new ArrayList<String>(1 + this.args.size());
                argv.add(this.hook.getAbsolutePath());
                argv.addAll(this.args);
                ProcessBuilder pb = new ProcessBuilder(argv);
                pb.redirectErrorStream(true);
                if (this.project != null) {
                    repo = ChangeHookRunner.this.openRepository(this.project);
                }
                Map<String, String> env = pb.environment();
                env.put("GERRIT_SITE", ((ChangeHookRunner)ChangeHookRunner.this).sitePaths.site_path.getAbsolutePath());
                if (repo != null) {
                    pb.directory(repo.getDirectory());
                    env.put("GIT_DIR", repo.getDirectory().getAbsolutePath());
                }
                this.ps = pb.start();
                this.ps.getOutputStream().close();
                InputStream is = this.ps.getInputStream();
                String output = null;
                try {
                    output = this.readOutput(is);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    this.ps.waitFor();
                    result = new HookResult(this.ps.exitValue(), output);
                }
            }
            if (result != null) {
                int exitValue = result.getExitValue();
                if (exitValue == 0) {
                    log.debug("hook[" + this.getName() + "] exitValue:" + exitValue);
                } else {
                    log.info("hook[" + this.getName() + "] exitValue:" + exitValue);
                }
                BufferedReader br = new BufferedReader(new StringReader(result.getOutput()));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        log.info("hook[" + this.getName() + "] output: " + line);
                    }
                }
                catch (IOException iox) {
                    log.error("Error writing hook output", iox);
                }
            }
            return result;
        }

        private String readOutput(InputStream is) throws IOException {
            int n;
            this.output = new StringWriter();
            InputStreamReader input = new InputStreamReader(is);
            char[] buffer = new char[4096];
            while ((n = input.read(buffer)) != -1) {
                this.output.write(buffer, 0, n);
            }
            return this.output.toString();
        }

        protected String getName() {
            return this.hook.getName();
        }

        public String toString() {
            return "hook " + this.hook.getName();
        }

        public void cancel() {
            this.ps.destroy();
        }
    }

    public static class HookResult {
        private int exitValue = -1;
        private String output;
        private String executionError;

        private HookResult(int exitValue, String output) {
            this.exitValue = exitValue;
            this.output = output;
        }

        private HookResult(String output, String executionError) {
            this.output = output;
            this.executionError = executionError;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public void setExitValue(int exitValue) {
            this.exitValue = exitValue;
        }

        public String getOutput() {
            return this.output;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.output != null && this.output.length() != 0) {
                sb.append(this.output);
                if (this.executionError != null) {
                    sb.append(" - ");
                }
            }
            if (this.executionError != null) {
                sb.append(this.executionError);
            }
            return sb.toString();
        }
    }

    private static class ChangeListenerHolder {
        final ChangeListener listener;
        final IdentifiedUser user;

        ChangeListenerHolder(ChangeListener l, IdentifiedUser u) {
            this.listener = l;
            this.user = u;
        }
    }

    public static class Module
    extends LifecycleModule {
        @Override
        protected void configure() {
            this.bind(ChangeHookRunner.class);
            this.bind(ChangeHooks.class).to(ChangeHookRunner.class);
            this.listener().to(ChangeHookRunner.class);
        }
    }
}

