/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gwtjsonrpc.server.SignedToken;
import com.google.gwtjsonrpc.server.XsrfException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jgit.lib.Config;

@Singleton
class ProjectDigestFilter
implements Filter {
    public static final String REALM_NAME = "Gerrit Code Review";
    private static final String AUTHORIZATION = "Authorization";
    private final Provider<String> urlProvider;
    private final Provider<WebSession> session;
    private final AccountCache accountCache;
    private final Config config;
    private final SignedToken tokens;
    private ServletContext context;
    private static final char[] LHEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Inject
    ProjectDigestFilter(@CanonicalWebUrl @Nullable Provider<String> urlProvider, Provider<WebSession> session, AccountCache accountCache, @GerritServerConfig Config config) throws XsrfException {
        this.urlProvider = urlProvider;
        this.session = session;
        this.accountCache = accountCache;
        this.config = config;
        this.tokens = new SignedToken((int)TimeUnit.SECONDS.convert(1L, TimeUnit.HOURS));
    }

    @Override
    public void init(FilterConfig config) {
        this.context = config.getServletContext();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        Response rsp = new Response(req, (HttpServletResponse)response);
        if (this.verify(req, rsp)) {
            chain.doFilter(req, rsp);
        }
    }

    private boolean verify(HttpServletRequest req, Response rsp) throws IOException {
        AccountState who;
        String hdr = req.getHeader(AUTHORIZATION);
        if (hdr == null || !hdr.startsWith("Digest ")) {
            return true;
        }
        Map<String, String> p = this.parseAuthorization(hdr);
        String user = p.get("username");
        String realm = p.get("realm");
        String nonce = p.get("nonce");
        String uri = p.get("uri");
        String response = p.get("response");
        String qop = p.get("qop");
        String nc = p.get("nc");
        String cnonce = p.get("cnonce");
        String method = req.getMethod();
        if (user == null || realm == null || nonce == null || uri == null || response == null || !"auth".equals(qop) || !REALM_NAME.equals(realm)) {
            this.context.log("Invalid header: Authorization: " + hdr);
            rsp.sendError(403);
            return false;
        }
        String username = user;
        if (this.config.getBoolean("auth", "userNameToLowerCase", false)) {
            username = username.toLowerCase(Locale.US);
        }
        if ((who = this.accountCache.getByUsername(username)) == null || !who.getAccount().isActive()) {
            rsp.sendError(401);
            return false;
        }
        String passwd = who.getPassword(username);
        if (passwd == null) {
            rsp.sendError(401);
            return false;
        }
        String A1 = user + ":" + realm + ":" + passwd;
        String A2 = method + ":" + uri;
        String expect = ProjectDigestFilter.KD(ProjectDigestFilter.H(A1), nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ProjectDigestFilter.H(A2));
        if (expect.equals(response)) {
            try {
                if (this.tokens.checkToken(nonce, "") != null) {
                    WebSession ws = this.session.get();
                    ws.setUserAccountId(who.getAccount().getId());
                    ws.setAccessPathOk(AccessPath.GIT, true);
                    ws.setAccessPathOk(AccessPath.REST_API, true);
                    return true;
                }
                rsp.stale = true;
                rsp.sendError(401);
                return false;
            }
            catch (XsrfException e) {
                this.context.log("Error validating nonce for digest authentication", e);
                rsp.sendError(500);
                return false;
            }
        }
        rsp.sendError(401);
        return false;
    }

    private static String H(String data) {
        try {
            MessageDigest md = ProjectDigestFilter.newMD5();
            md.update(data.getBytes("UTF-8"));
            return ProjectDigestFilter.LHEX(md.digest());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not available", e);
        }
    }

    private static String KD(String secret, String data) {
        try {
            MessageDigest md = ProjectDigestFilter.newMD5();
            md.update(secret.getBytes("UTF-8"));
            md.update((byte)58);
            md.update(data.getBytes("UTF-8"));
            return ProjectDigestFilter.LHEX(md.digest());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not available", e);
        }
    }

    private static MessageDigest newMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No MD5 available", e);
        }
    }

    private static String LHEX(byte[] bin) {
        StringBuilder r = new StringBuilder(bin.length * 2);
        for (byte b : bin) {
            r.append(LHEX[b >>> 4 & 0xF]);
            r.append(LHEX[b & 0xF]);
        }
        return r.toString();
    }

    private Map<String, String> parseAuthorization(String auth) {
        HashMap<String, String> p = new HashMap<String, String>();
        int next = "Digest ".length();
        while (next < auth.length()) {
            String value;
            if (next < auth.length() && auth.charAt(next) == ',') {
                ++next;
            }
            while (next < auth.length() && Character.isWhitespace(auth.charAt(next))) {
                ++next;
            }
            int eq = auth.indexOf(61, next);
            if (eq < 0 || eq + 1 == auth.length()) {
                return Collections.emptyMap();
            }
            String name = auth.substring(next, eq);
            if (auth.charAt(eq + 1) == '\"') {
                int dq = auth.indexOf(34, eq + 2);
                if (dq < 0) {
                    return Collections.emptyMap();
                }
                value = auth.substring(eq + 2, dq);
                next = dq + 1;
            } else {
                int space = auth.indexOf(32, eq + 1);
                int comma = auth.indexOf(44, eq + 1);
                if (space < 0) {
                    space = auth.length();
                }
                if (comma < 0) {
                    comma = auth.length();
                }
                int e = Math.min(space, comma);
                value = auth.substring(eq + 1, e);
                next = e + 1;
            }
            p.put(name, value);
        }
        return p;
    }

    private String newNonce() {
        try {
            return this.tokens.newToken("");
        }
        catch (XsrfException e) {
            throw new RuntimeException("Cannot generate new nonce", e);
        }
    }

    class Response
    extends HttpServletResponseWrapper {
        private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
        private final HttpServletRequest req;
        Boolean stale;

        Response(HttpServletRequest req, HttpServletResponse rsp) {
            super(rsp);
            this.req = req;
        }

        private void status(int sc) {
            if (sc == 401) {
                StringBuilder v = new StringBuilder();
                v.append("Digest");
                v.append(" realm=\"").append(ProjectDigestFilter.REALM_NAME).append("\"");
                String url = (String)ProjectDigestFilter.this.urlProvider.get();
                if (url == null && (url = this.req.getContextPath()) != null && !url.isEmpty() && !url.endsWith("/")) {
                    url = url + "/";
                }
                if (url != null && !url.isEmpty()) {
                    v.append(", domain=\"").append(url).append("\"");
                }
                v.append(", qop=\"auth\"");
                if (this.stale != null) {
                    v.append(", stale=").append(this.stale);
                }
                v.append(", nonce=\"").append(ProjectDigestFilter.this.newNonce()).append("\"");
                this.setHeader(WWW_AUTHENTICATE, v.toString());
            } else if (this.containsHeader(WWW_AUTHENTICATE)) {
                this.setHeader(WWW_AUTHENTICATE, null);
            }
        }

        @Override
        public void sendError(int sc, String msg) throws IOException {
            this.status(sc);
            super.sendError(sc, msg);
        }

        @Override
        public void sendError(int sc) throws IOException {
            this.status(sc);
            super.sendError(sc);
        }

        @Override
        @Deprecated
        public void setStatus(int sc, String sm) {
            this.status(sc);
            super.setStatus(sc, sm);
        }

        @Override
        public void setStatus(int sc) {
            this.status(sc);
            super.setStatus(sc);
        }
    }
}

