/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.cache.Cache;
import com.google.gerrit.httpd.CacheBasedWebSession;
import com.google.gerrit.httpd.CookieBase64;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.ioutil.BasicSerialization;
import com.google.gerrit.server.util.TimeUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class WebSessionManager {
    private static final Logger log = LoggerFactory.getLogger(WebSessionManager.class);
    static final String CACHE_NAME = "web_sessions";
    private final long sessionMaxAgeMillis;
    private final SecureRandom prng = new SecureRandom();
    private final Cache<String, Val> self;

    @Inject
    WebSessionManager(@GerritServerConfig Config cfg, @Named(value="web_sessions") Cache<String, Val> cache) {
        this.self = cache;
        this.sessionMaxAgeMillis = TimeUnit.SECONDS.toMillis(ConfigUtil.getTimeUnit(cfg, "cache", CACHE_NAME, "maxAge", TimeUnit.SECONDS.convert(CacheBasedWebSession.MAX_AGE_MINUTES, TimeUnit.MINUTES), TimeUnit.SECONDS));
        if (this.sessionMaxAgeMillis < TimeUnit.MINUTES.toMillis(5L)) {
            log.warn(String.format("cache.%s.maxAge is set to %d milliseconds; it should be at least 5 minutes.", CACHE_NAME, this.sessionMaxAgeMillis));
        }
    }

    Key createKey(Account.Id who) {
        return new Key(this.newUniqueToken(who));
    }

    private String newUniqueToken(Account.Id who) {
        try {
            int nonceLen = 20;
            byte[] rnd = new byte[20];
            this.prng.nextBytes(rnd);
            ByteArrayOutputStream buf = new ByteArrayOutputStream(23);
            BasicSerialization.writeVarInt32(buf, 2);
            BasicSerialization.writeVarInt32(buf, who.get());
            BasicSerialization.writeBytes(buf, rnd);
            return CookieBase64.encode(buf.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot produce new account cookie", e);
        }
    }

    Val createVal(Key key, Val val) {
        Account.Id who = val.getAccountId();
        boolean remember = val.isPersistentCookie();
        AccountExternalId.Key lastLogin = val.getExternalId();
        return this.createVal(key, who, remember, lastLogin, val.sessionId, val.auth);
    }

    Val createVal(Key key, Account.Id who, boolean remember, AccountExternalId.Key lastLogin, String sid, String auth) {
        long halfAgeRefresh = this.sessionMaxAgeMillis >>> 1;
        long minRefresh = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
        long refresh = Math.min(halfAgeRefresh, minRefresh);
        long now = TimeUtil.nowMs();
        long refreshCookieAt = now + refresh;
        long expiresAt = now + this.sessionMaxAgeMillis;
        if (sid == null) {
            sid = this.newUniqueToken(who);
        }
        if (auth == null) {
            auth = this.newUniqueToken(who);
        }
        Val val = new Val(who, refreshCookieAt, remember, lastLogin, expiresAt, sid, auth);
        this.self.put(key.token, val);
        return val;
    }

    int getCookieAge(Val val) {
        if (val.isPersistentCookie()) {
            return (int)TimeUnit.MILLISECONDS.toSeconds(this.sessionMaxAgeMillis);
        }
        return -1;
    }

    Val get(Key key) {
        Val val = this.self.getIfPresent(key.token);
        if (val != null && val.expiresAt <= TimeUtil.nowMs()) {
            this.self.invalidate(key.token);
            return null;
        }
        return val;
    }

    void destroy(Key key) {
        this.self.invalidate(key.token);
    }

    static final class Val
    implements Serializable {
        static final long serialVersionUID = 2L;
        private transient Account.Id accountId;
        private transient long refreshCookieAt;
        private transient boolean persistentCookie;
        private transient AccountExternalId.Key externalId;
        private transient long expiresAt;
        private transient String sessionId;
        private transient String auth;

        Val(Account.Id accountId, long refreshCookieAt, boolean persistentCookie, AccountExternalId.Key externalId, long expiresAt, String sessionId, String auth) {
            this.accountId = accountId;
            this.refreshCookieAt = refreshCookieAt;
            this.persistentCookie = persistentCookie;
            this.externalId = externalId;
            this.expiresAt = expiresAt;
            this.sessionId = sessionId;
            this.auth = auth;
        }

        Account.Id getAccountId() {
            return this.accountId;
        }

        AccountExternalId.Key getExternalId() {
            return this.externalId;
        }

        String getSessionId() {
            return this.sessionId;
        }

        String getAuth() {
            return this.auth;
        }

        boolean needsCookieRefresh() {
            return this.refreshCookieAt <= TimeUtil.nowMs();
        }

        boolean isPersistentCookie() {
            return this.persistentCookie;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            BasicSerialization.writeVarInt32(out, 1);
            BasicSerialization.writeVarInt32(out, this.accountId.get());
            BasicSerialization.writeVarInt32(out, 2);
            BasicSerialization.writeFixInt64(out, this.refreshCookieAt);
            BasicSerialization.writeVarInt32(out, 3);
            BasicSerialization.writeVarInt32(out, this.persistentCookie ? 1 : 0);
            if (this.externalId != null) {
                BasicSerialization.writeVarInt32(out, 4);
                BasicSerialization.writeString(out, this.externalId.get());
            }
            if (this.sessionId != null) {
                BasicSerialization.writeVarInt32(out, 5);
                BasicSerialization.writeString(out, this.sessionId);
            }
            BasicSerialization.writeVarInt32(out, 6);
            BasicSerialization.writeFixInt64(out, this.expiresAt);
            if (this.auth != null) {
                BasicSerialization.writeVarInt32(out, 7);
                BasicSerialization.writeString(out, this.auth);
            }
            BasicSerialization.writeVarInt32(out, 0);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            block10: while (true) {
                int tag = BasicSerialization.readVarInt32(in);
                switch (tag) {
                    case 0: {
                        break block10;
                    }
                    case 1: {
                        this.accountId = new Account.Id(BasicSerialization.readVarInt32(in));
                        continue block10;
                    }
                    case 2: {
                        this.refreshCookieAt = BasicSerialization.readFixInt64(in);
                        continue block10;
                    }
                    case 3: {
                        this.persistentCookie = BasicSerialization.readVarInt32(in) != 0;
                        continue block10;
                    }
                    case 4: {
                        this.externalId = new AccountExternalId.Key(BasicSerialization.readString(in));
                        continue block10;
                    }
                    case 5: {
                        this.sessionId = BasicSerialization.readString(in);
                        continue block10;
                    }
                    case 6: {
                        this.expiresAt = BasicSerialization.readFixInt64(in);
                        continue block10;
                    }
                    case 7: {
                        this.auth = BasicSerialization.readString(in);
                        continue block10;
                    }
                    default: {
                        throw new IOException("Unknown tag found in object: " + tag);
                    }
                }
                break;
            }
            if (this.expiresAt == 0L) {
                this.expiresAt = this.refreshCookieAt + TimeUnit.HOURS.toMillis(2L);
            }
        }
    }

    static final class Key {
        private transient String token;

        Key(String t) {
            this.token = t;
        }

        String getToken() {
            return this.token;
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Key && this.token.equals(((Key)obj).token);
        }
    }
}

