/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.patch;

import com.google.gerrit.common.data.PatchDetailService;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.common.errors.NoSuchEntityException;
import com.google.gerrit.httpd.rpc.BaseServiceImplementation;
import com.google.gerrit.httpd.rpc.Handler;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.patch.PatchScriptFactory;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.inject.Inject;
import com.google.inject.Provider;

class PatchDetailServiceImpl
extends BaseServiceImplementation
implements PatchDetailService {
    private final PatchScriptFactory.Factory patchScriptFactoryFactory;
    private final ChangeControl.Factory changeControlFactory;

    @Inject
    PatchDetailServiceImpl(Provider<ReviewDb> schema, Provider<CurrentUser> currentUser, PatchScriptFactory.Factory patchScriptFactoryFactory, ChangeControl.Factory changeControlFactory) {
        super(schema, currentUser);
        this.patchScriptFactoryFactory = patchScriptFactoryFactory;
        this.changeControlFactory = changeControlFactory;
    }

    @Override
    public void patchScript(final Patch.Key patchKey, final PatchSet.Id psa, final PatchSet.Id psb, final AccountDiffPreference dp, AsyncCallback<PatchScript> callback) {
        if (psb == null) {
            callback.onFailure(new NoSuchEntityException());
            return;
        }
        new Handler<PatchScript>(){

            @Override
            public PatchScript call() throws Exception {
                Change.Id changeId = patchKey.getParentKey().getParentKey();
                ChangeControl control = PatchDetailServiceImpl.this.changeControlFactory.validateFor(changeId);
                return PatchDetailServiceImpl.this.patchScriptFactoryFactory.create(control, patchKey.getFileName(), psa, psb, dp).call();
            }
        }.to(callback);
    }
}

