/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.rules;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.rules.PredicateProvider;
import java.util.Collection;

public class PredicateClassLoader
extends ClassLoader {
    private final Multimap<String, ClassLoader> packageClassLoaderMap = LinkedHashMultimap.create();

    public PredicateClassLoader(DynamicSet<PredicateProvider> predicateProviders, ClassLoader parent) {
        super(parent);
        for (PredicateProvider predicateProvider : predicateProviders) {
            for (String pkg : predicateProvider.getPackages()) {
                this.packageClassLoaderMap.put(pkg, predicateProvider.getClass().getClassLoader());
            }
        }
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        Collection<ClassLoader> classLoaders = this.packageClassLoaderMap.get(PredicateClassLoader.getPackageName(className));
        for (ClassLoader cl : classLoaders) {
            try {
                return Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    private static String getPackageName(String className) {
        int pos = className.lastIndexOf(46);
        if (pos < 0) {
            return "";
        }
        return className.substring(0, pos);
    }
}

