/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.ReviewerState;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class ApprovalsUtil {
    private static Ordering<PatchSetApproval> SORT_APPROVALS = Ordering.natural().onResultOf(new Function<PatchSetApproval, Timestamp>(){

        @Override
        public Timestamp apply(PatchSetApproval a) {
            return a.getGranted();
        }
    });
    private final NotesMigration migration;

    public static List<PatchSetApproval> sortApprovals(Iterable<PatchSetApproval> approvals) {
        return SORT_APPROVALS.sortedCopy(approvals);
    }

    private static Iterable<PatchSetApproval> filterApprovals(Iterable<PatchSetApproval> psas, final Account.Id accountId) {
        return Iterables.filter(psas, new Predicate<PatchSetApproval>(){

            @Override
            public boolean apply(PatchSetApproval input) {
                return Objects.equal(input.getAccountId(), accountId);
            }
        });
    }

    @Inject
    @VisibleForTesting
    public ApprovalsUtil(NotesMigration migration) {
        this.migration = migration;
    }

    public ImmutableSetMultimap<ReviewerState, Account.Id> getReviewers(ReviewDb db, ChangeNotes notes) throws OrmException {
        if (!this.migration.readPatchSetApprovals()) {
            return ApprovalsUtil.getReviewers(db.patchSetApprovals().byChange(notes.getChangeId()));
        }
        return notes.load().getReviewers();
    }

    public ImmutableSetMultimap<ReviewerState, Account.Id> getReviewers(ChangeNotes notes, Iterable<PatchSetApproval> allApprovals) throws OrmException {
        if (!this.migration.readPatchSetApprovals()) {
            return ApprovalsUtil.getReviewers(allApprovals);
        }
        return notes.load().getReviewers();
    }

    private static ImmutableSetMultimap<ReviewerState, Account.Id> getReviewers(Iterable<PatchSetApproval> allApprovals) {
        PatchSetApproval first = null;
        LinkedHashMultimap<ReviewerState, Account.Id> reviewers = LinkedHashMultimap.create();
        for (PatchSetApproval psa : allApprovals) {
            if (first == null) {
                first = psa;
            } else {
                Preconditions.checkArgument(first.getKey().getParentKey().getParentKey().equals(psa.getKey().getParentKey().getParentKey()), "multiple change IDs: %s, %s", first.getKey(), psa.getKey());
            }
            Account.Id id = psa.getAccountId();
            if (psa.getValue() != 0) {
                reviewers.put(ReviewerState.REVIEWER, id);
                reviewers.remove((Object)ReviewerState.CC, id);
                continue;
            }
            if (reviewers.containsEntry((Object)ReviewerState.REVIEWER, id)) continue;
            reviewers.put(ReviewerState.CC, id);
        }
        return ImmutableSetMultimap.copyOf(reviewers);
    }

    public List<PatchSetApproval> addReviewers(ReviewDb db, ChangeUpdate update, LabelTypes labelTypes, Change change, PatchSet ps, PatchSetInfo info, Iterable<Account.Id> wantReviewers, Collection<Account.Id> existingReviewers) throws OrmException {
        return this.addReviewers(db, update, labelTypes, change, ps.getId(), ps.isDraft(), info.getAuthor().getAccount(), info.getCommitter().getAccount(), wantReviewers, existingReviewers);
    }

    public List<PatchSetApproval> addReviewers(ReviewDb db, ChangeNotes notes, ChangeUpdate update, LabelTypes labelTypes, Change change, Iterable<Account.Id> wantReviewers) throws OrmException {
        PatchSet.Id psId = change.currentPatchSetId();
        return this.addReviewers(db, update, labelTypes, change, psId, false, null, null, wantReviewers, this.getReviewers(db, notes).values());
    }

    private List<PatchSetApproval> addReviewers(ReviewDb db, ChangeUpdate update, LabelTypes labelTypes, Change change, PatchSet.Id psId, boolean isDraft, Account.Id authorId, Account.Id committerId, Iterable<Account.Id> wantReviewers, Collection<Account.Id> existingReviewers) throws OrmException {
        List<LabelType> allTypes = labelTypes.getLabelTypes();
        if (allTypes.isEmpty()) {
            return ImmutableList.of();
        }
        LinkedHashSet<Account.Id> need = Sets.newLinkedHashSet(wantReviewers);
        if (authorId != null && !isDraft) {
            need.add(authorId);
        }
        if (committerId != null && !isDraft) {
            need.add(committerId);
        }
        need.remove(change.getOwner());
        need.removeAll(existingReviewers);
        if (need.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<PatchSetApproval> cells = Lists.newArrayListWithCapacity(need.size());
        PatchSetApproval.LabelId labelId = Iterables.getLast(allTypes).getLabelId();
        for (Account.Id account : need) {
            cells.add(new PatchSetApproval(new PatchSetApproval.Key(psId, account, labelId), 0, TimeUtil.nowTs()));
            update.putReviewer(account, ReviewerState.REVIEWER);
        }
        db.patchSetApprovals().insert(cells);
        return Collections.unmodifiableList(cells);
    }

    public ListMultimap<PatchSet.Id, PatchSetApproval> byChange(ReviewDb db, ChangeNotes notes) throws OrmException {
        if (!this.migration.readPatchSetApprovals()) {
            ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
            for (PatchSetApproval psa : db.patchSetApprovals().byChange(notes.getChangeId())) {
                result.put(psa.getPatchSetId(), psa);
            }
            return result.build();
        }
        return notes.load().getApprovals();
    }

    public List<PatchSetApproval> byPatchSet(ReviewDb db, ChangeNotes notes, PatchSet.Id psId) throws OrmException {
        if (!this.migration.readPatchSetApprovals()) {
            return ApprovalsUtil.sortApprovals(db.patchSetApprovals().byPatchSet(psId));
        }
        return notes.load().getApprovals().get((Object)psId);
    }

    public List<PatchSetApproval> byPatchSetUser(ReviewDb db, ChangeNotes notes, PatchSet.Id psId, Account.Id accountId) throws OrmException {
        if (!this.migration.readPatchSetApprovals()) {
            return ApprovalsUtil.sortApprovals(db.patchSetApprovals().byPatchSetUser(psId, accountId));
        }
        return ImmutableList.copyOf(ApprovalsUtil.filterApprovals(this.byPatchSet(db, notes, psId), accountId));
    }

    public PatchSetApproval getSubmitter(ReviewDb db, ChangeNotes notes, PatchSet.Id c) {
        if (c == null) {
            return null;
        }
        try {
            return ApprovalsUtil.getSubmitter(c, this.byPatchSet(db, notes, c));
        }
        catch (OrmException e) {
            return null;
        }
    }

    public static PatchSetApproval getSubmitter(PatchSet.Id c, Iterable<PatchSetApproval> approvals) {
        if (c == null) {
            return null;
        }
        PatchSetApproval submitter = null;
        for (PatchSetApproval a : approvals) {
            if (!a.getPatchSetId().equals(c) || a.getValue() <= 0 || !a.isSubmit() || submitter != null && a.getGranted().compareTo(submitter.getGranted()) <= 0) continue;
            submitter = a;
        }
        return submitter;
    }
}

