/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.GlobalCapability;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.gerrit.server.account.GetCapabilities;
import com.google.inject.Inject;
import com.google.inject.Provider;

class Capabilities
implements ChildCollection<AccountResource, AccountResource.Capability> {
    private final Provider<CurrentUser> self;
    private final DynamicMap<RestView<AccountResource.Capability>> views;
    private final Provider<GetCapabilities> get;

    @Inject
    Capabilities(Provider<CurrentUser> self, DynamicMap<RestView<AccountResource.Capability>> views, Provider<GetCapabilities> get) {
        this.self = self;
        this.views = views;
        this.get = get;
    }

    public GetCapabilities list() throws ResourceNotFoundException {
        return this.get.get();
    }

    @Override
    public AccountResource.Capability parse(AccountResource parent, IdString id) throws ResourceNotFoundException, AuthException {
        if (this.self.get() != parent.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("restricted to administrator");
        }
        String name = id.get();
        CapabilityControl cap = parent.getUser().getCapabilities();
        if (cap.canPerform(name) || cap.canAdministrateServer() && GlobalCapability.isCapability(name)) {
            return new AccountResource.Capability(parent.getUser(), name);
        }
        throw new ResourceNotFoundException(id);
    }

    @Override
    public DynamicMap<RestView<AccountResource.Capability>> views() {
        return this.views;
    }
}

