/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.cache;

import com.google.common.base.Strings;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.server.cache.CacheRemovalListener;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class ForwardingRemovalListener<K, V>
implements RemovalListener<K, V> {
    private final DynamicSet<CacheRemovalListener> listeners;
    private final String cacheName;
    private String pluginName = "gerrit";

    @Inject
    ForwardingRemovalListener(DynamicSet<CacheRemovalListener> listeners, @Assisted String cacheName) {
        this.listeners = listeners;
        this.cacheName = cacheName;
    }

    @Inject(optional=true)
    void setPluginName(String name) {
        if (!Strings.isNullOrEmpty(name)) {
            this.pluginName = name;
        }
    }

    @Override
    public void onRemoval(RemovalNotification<K, V> notification) {
        for (CacheRemovalListener l : this.listeners) {
            l.onRemoval(this.pluginName, this.cacheName, notification);
        }
    }

    public static interface Factory {
        public ForwardingRemovalListener create(String var1);
    }
}

