/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.change.ChangeKind;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeKindCache {
    private static final Logger log = LoggerFactory.getLogger(ChangeKindCache.class);
    private static final String ID_CACHE = "change_kind";
    private final LoadingCache<Key, ChangeKind> cache;
    private final boolean useRecursiveMerge;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(ChangeKindCache.ID_CACHE, Key.class, ChangeKind.class).maximumWeight(0L).loader(Loader.class);
            }
        };
    }

    @Inject
    ChangeKindCache(@GerritServerConfig Config serverConfig, @Named(value="change_kind") LoadingCache<Key, ChangeKind> cache) {
        this.cache = cache;
        this.useRecursiveMerge = MergeUtil.useRecursiveMerge(serverConfig);
    }

    public ChangeKind getChangeKind(ProjectState project, Repository repo, ObjectId prior, ObjectId next) {
        Preconditions.checkNotNull(next, "next");
        String strategyName = MergeUtil.mergeStrategyName(project.isUseContentMerge(), this.useRecursiveMerge);
        try {
            return this.cache.get(new Key(prior, next, strategyName, repo));
        }
        catch (ExecutionException e) {
            log.warn("Cannot check trivial rebase of new patch set " + next.name() + " in " + project.getProject().getName(), e);
            return ChangeKind.REWORK;
        }
    }

    @Singleton
    private static class Loader
    extends CacheLoader<Key, ChangeKind> {
        private Loader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChangeKind load(Key key) throws IOException {
            RevWalk walk = new RevWalk(key.repo);
            try {
                RevCommit prior = walk.parseCommit(key.prior);
                walk.parseBody(prior);
                RevCommit next = walk.parseCommit(key.next);
                walk.parseBody(next);
                if (!next.getFullMessage().equals(prior.getFullMessage())) {
                    if (next.getTree() == prior.getTree() && Loader.isSameParents(prior, next)) {
                        ChangeKind changeKind = ChangeKind.NO_CODE_CHANGE;
                        return changeKind;
                    }
                    ChangeKind changeKind = ChangeKind.REWORK;
                    return changeKind;
                }
                if (prior.getParentCount() != 1 || next.getParentCount() != 1) {
                    ChangeKind changeKind = ChangeKind.REWORK;
                    return changeKind;
                }
                if (next.getTree() == prior.getTree() && Loader.isSameParents(prior, next)) {
                    ChangeKind changeKind = ChangeKind.TRIVIAL_REBASE;
                    return changeKind;
                }
                ThreeWayMerger merger = MergeUtil.newThreeWayMerger(key.repo, MergeUtil.createDryRunInserter(key.repo), key.strategyName);
                merger.setBase(prior.getParent(0));
                if (merger.merge(next.getParent(0), prior) && merger.getResultTreeId().equals(next.getTree())) {
                    ChangeKind changeKind = ChangeKind.TRIVIAL_REBASE;
                    return changeKind;
                }
                ChangeKind changeKind = ChangeKind.REWORK;
                return changeKind;
            }
            finally {
                key.repo = null;
                walk.close();
            }
        }

        private static boolean isSameParents(RevCommit prior, RevCommit next) {
            if (prior.getParentCount() != next.getParentCount()) {
                return false;
            }
            if (prior.getParentCount() == 0) {
                return true;
            }
            return prior.getParent(0).equals(next.getParent(0));
        }
    }

    public static class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ObjectId prior;
        private final ObjectId next;
        private final String strategyName;
        private transient Repository repo;

        private Key(ObjectId prior, ObjectId next, String strategyName, Repository repo) {
            this.prior = prior.copy();
            this.next = next.copy();
            this.strategyName = strategyName;
            this.repo = repo;
        }

        public ObjectId getPrior() {
            return this.prior;
        }

        public ObjectId getNext() {
            return this.next;
        }

        public String getStrategyName() {
            return this.strategyName;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                return Objects.equal(this.prior, k.prior) && Objects.equal(this.next, k.next) && Objects.equal(this.strategyName, k.strategyName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.prior, this.next, this.strategyName);
        }
    }
}

