/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.PatchSetInserter;
import com.google.gerrit.server.events.CommitReceivedEvent;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeException;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.git.validators.CommitValidationException;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.ssh.NoSshInfo;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.ChangeIdUtil;

public class CherryPickChange {
    private static final FooterKey CHANGE_ID = new FooterKey("Change-Id");
    private final ReviewDb db;
    private final GitRepositoryManager gitManager;
    private final PersonIdent myIdent;
    private final IdentifiedUser currentUser;
    private final CommitValidators.Factory commitValidatorsFactory;
    private final ChangeInserter.Factory changeInserterFactory;
    private final PatchSetInserter.Factory patchSetInserterFactory;
    final MergeUtil.Factory mergeUtilFactory;

    @Inject
    CherryPickChange(ReviewDb db, @GerritPersonIdent PersonIdent myIdent, GitRepositoryManager gitManager, IdentifiedUser currentUser, CommitValidators.Factory commitValidatorsFactory, ChangeInserter.Factory changeInserterFactory, PatchSetInserter.Factory patchSetInserterFactory, MergeUtil.Factory mergeUtilFactory) {
        this.db = db;
        this.gitManager = gitManager;
        this.myIdent = myIdent;
        this.currentUser = currentUser;
        this.commitValidatorsFactory = commitValidatorsFactory;
        this.changeInserterFactory = changeInserterFactory;
        this.patchSetInserterFactory = patchSetInserterFactory;
        this.mergeUtilFactory = mergeUtilFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change.Id cherryPick(PatchSet.Id patchSetId, String message, String destinationBranch, RefControl refControl) throws NoSuchChangeException, EmailException, OrmException, MissingObjectException, IncorrectObjectTypeException, IOException, InvalidChangeOperationException, MergeException {
        Repository git;
        Change.Id changeId = patchSetId.getParentKey();
        PatchSet patch = this.db.patchSets().get(patchSetId);
        if (patch == null) {
            throw new NoSuchChangeException(changeId);
        }
        if (destinationBranch == null || destinationBranch.length() == 0) {
            throw new InvalidChangeOperationException("Cherry Pick: Destination branch cannot be null or empty");
        }
        Project.NameKey project = this.db.changes().get(changeId).getProject();
        try {
            git = this.gitManager.openRepository(project);
        }
        catch (RepositoryNotFoundException e) {
            throw new NoSuchChangeException(changeId, (Throwable)e);
        }
        try {
            Change.Key changeKey;
            RevCommit cherryPickCommit;
            Ref destRef;
            RevWalk revWalk;
            block21: {
                revWalk = new RevWalk(git);
                try {
                    destRef = git.getRef(destinationBranch);
                    if (destRef == null) {
                        throw new InvalidChangeOperationException("Branch " + destinationBranch + " does not exist.");
                    }
                    RevCommit mergeTip = revWalk.parseCommit(destRef.getObjectId());
                    RevCommit commitToCherryPick = revWalk.parseCommit(ObjectId.fromString(patch.getRevision().get()));
                    PersonIdent committerIdent = this.currentUser.newCommitterIdent(this.myIdent.getWhen(), this.myIdent.getTimeZone());
                    ObjectId computedChangeId = ChangeIdUtil.computeChangeId(commitToCherryPick.getTree(), mergeTip, commitToCherryPick.getAuthorIdent(), this.myIdent, message);
                    String commitMessage = ChangeIdUtil.insertId(message, computedChangeId).trim() + '\n';
                    try (ObjectInserter oi = git.newObjectInserter();){
                        ProjectState projectState = refControl.getProjectControl().getProjectState();
                        cherryPickCommit = this.mergeUtilFactory.create(projectState).createCherryPickFromCommit(git, oi, mergeTip, commitToCherryPick, committerIdent, commitMessage, revWalk);
                    }
                    if (cherryPickCommit == null) {
                        throw new MergeException("Cherry pick failed");
                    }
                    List<String> idList = cherryPickCommit.getFooterLines(CHANGE_ID);
                    if (!idList.isEmpty()) {
                        String idStr = idList.get(idList.size() - 1).trim();
                        changeKey = new Change.Key(idStr);
                    } else {
                        changeKey = new Change.Key("I" + computedChangeId.name());
                    }
                    List<Change> destChanges = this.db.changes().byBranchKey(new Branch.NameKey(this.db.changes().get(changeId).getProject(), destRef.getName()), changeKey).toList();
                    if (destChanges.size() > 1) {
                        throw new InvalidChangeOperationException("Several changes with key " + changeKey + " reside on the same branch. " + "Cannot create a new patch set.");
                    }
                    if (destChanges.size() != 1) break block21;
                    Change.Id id = this.insertPatchSet(git, revWalk, destChanges.get(0), patchSetId, cherryPickCommit, refControl, this.currentUser);
                    revWalk.close();
                    return id;
                }
                catch (Throwable throwable) {
                    revWalk.close();
                    throw throwable;
                }
            }
            Change.Id id = this.createNewChange(git, revWalk, changeKey, project, patchSetId, destRef, cherryPickCommit, refControl);
            revWalk.close();
            return id;
        }
        finally {
            git.close();
        }
    }

    private Change.Id insertPatchSet(Repository git, RevWalk revWalk, Change change, PatchSet.Id patchSetId, RevCommit cherryPickCommit, RefControl refControl, IdentifiedUser uploader) throws InvalidChangeOperationException, IOException, OrmException, NoSuchChangeException {
        ChangeControl changeControl = refControl.getProjectControl().controlFor(change);
        PatchSetInserter inserter = this.patchSetInserterFactory.create(git, revWalk, changeControl, cherryPickCommit);
        PatchSet.Id newPatchSetId = inserter.getPatchSetId();
        PatchSet current = this.db.patchSets().get(change.currentPatchSetId());
        inserter.setMessage("Uploaded patch set " + newPatchSetId.get() + ".").setDraft(current.isDraft()).setUploader(uploader.getAccountId()).setCopyLabels(true).insert();
        return change.getId();
    }

    private Change.Id createNewChange(Repository git, RevWalk revWalk, Change.Key changeKey, Project.NameKey project, PatchSet.Id patchSetId, Ref destRef, RevCommit cherryPickCommit, RefControl refControl) throws OrmException, InvalidChangeOperationException, IOException {
        Change change = new Change(changeKey, new Change.Id(this.db.nextChangeId()), this.currentUser.getAccountId(), new Branch.NameKey(project, destRef.getName()), TimeUtil.nowTs());
        ChangeInserter ins = this.changeInserterFactory.create(refControl, change, cherryPickCommit);
        PatchSet newPatchSet = ins.getPatchSet();
        CommitValidators commitValidators = this.commitValidatorsFactory.create(refControl, new NoSshInfo(), git);
        CommitReceivedEvent commitReceivedEvent = new CommitReceivedEvent(new ReceiveCommand(ObjectId.zeroId(), cherryPickCommit.getId(), newPatchSet.getRefName()), refControl.getProjectControl().getProject(), refControl.getRefName(), cherryPickCommit, this.currentUser);
        try {
            commitValidators.validateForGerritCommits(commitReceivedEvent);
        }
        catch (CommitValidationException e) {
            throw new InvalidChangeOperationException(e.getMessage());
        }
        RefUpdate ru = git.updateRef(newPatchSet.getRefName());
        ru.setExpectedOldObjectId(ObjectId.zeroId());
        ru.setNewObjectId(cherryPickCommit);
        ru.disableRefLog();
        if (ru.update(revWalk) != RefUpdate.Result.NEW) {
            throw new IOException(String.format("Failed to create ref %s in %s: %s", new Object[]{newPatchSet.getRefName(), change.getDest().getParentKey().get(), ru.getResult()}));
        }
        ins.setMessage(this.buildChangeMessage(patchSetId, change, cherryPickCommit)).insert();
        return change.getId();
    }

    private ChangeMessage buildChangeMessage(PatchSet.Id patchSetId, Change dest, RevCommit cherryPickCommit) throws OrmException {
        ChangeMessage cmsg = new ChangeMessage(new ChangeMessage.Key(patchSetId.getParentKey(), ChangeUtil.messageUUID(this.db)), this.currentUser.getAccountId(), TimeUtil.nowTs(), patchSetId);
        String destBranchName = dest.getDest().get();
        StringBuilder msgBuf = new StringBuilder("Patch Set ").append(patchSetId.get()).append(": Cherry Picked").append("\n\n").append("This patchset was cherry picked to branch ").append(destBranchName.substring(destBranchName.indexOf("refs/heads/") + "refs/heads/".length())).append(" as commit ").append(cherryPickCommit.getId().getName());
        cmsg.setMessage(msgBuf.toString());
        return cmsg;
    }
}

