/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import org.eclipse.jgit.lib.Config;

public class DeleteDraftChange
implements RestModifyView<ChangeResource, Input>,
UiAction<ChangeResource> {
    protected final Provider<ReviewDb> dbProvider;
    private final ChangeUtil changeUtil;
    private final boolean allowDrafts;

    @Inject
    public DeleteDraftChange(Provider<ReviewDb> dbProvider, PatchSetInfoFactory patchSetInfoFactory, ChangeUtil changeUtil, @GerritServerConfig Config cfg) {
        this.dbProvider = dbProvider;
        this.changeUtil = changeUtil;
        this.allowDrafts = cfg.getBoolean("change", "allowDrafts", true);
    }

    public Response<?> apply(ChangeResource rsrc, Input input) throws ResourceConflictException, AuthException, ResourceNotFoundException, OrmException, IOException {
        if (rsrc.getChange().getStatus() != Change.Status.DRAFT) {
            throw new ResourceConflictException("Change is not a draft");
        }
        if (!rsrc.getControl().canDeleteDraft(this.dbProvider.get())) {
            throw new AuthException("Not permitted to delete this draft change");
        }
        if (!this.allowDrafts) {
            throw new ResourceConflictException("Draft workflow is disabled.");
        }
        try {
            this.changeUtil.deleteDraftChange(rsrc.getChange().getId());
        }
        catch (NoSuchChangeException e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
        return Response.none();
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        try {
            return new UiAction.Description().setTitle(String.format("Delete draft change %d", rsrc.getChange().getChangeId())).setVisible(this.allowDrafts && rsrc.getChange().getStatus() == Change.Status.DRAFT && rsrc.getControl().canDeleteDraft(this.dbProvider.get()));
        }
        catch (OrmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class Input {
    }
}

