/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.PersonIdent;

class EditMessage
implements RestModifyView<RevisionResource, Input>,
UiAction<RevisionResource> {
    private final ChangeUtil changeUtil;
    private final PersonIdent myIdent;
    private final ChangeJson json;

    @Inject
    EditMessage(ChangeUtil changeUtil, @GerritPersonIdent PersonIdent myIdent, ChangeJson json) {
        this.changeUtil = changeUtil;
        this.myIdent = myIdent;
        this.json = json;
    }

    public ChangeJson.ChangeInfo apply(RevisionResource rsrc, Input input) throws BadRequestException, ResourceConflictException, ResourceNotFoundException, EmailException, OrmException, IOException {
        if (Strings.isNullOrEmpty(input.message)) {
            throw new BadRequestException("message must be non-empty");
        }
        if (!rsrc.getPatchSet().getId().equals(rsrc.getChange().currentPatchSetId())) {
            throw new ResourceConflictException(String.format("revision %s is not current revision", rsrc.getPatchSet().getRevision().get()));
        }
        try {
            return this.json.format(this.changeUtil.editCommitMessage(rsrc.getControl(), rsrc.getPatchSet().getId(), input.message, this.myIdent));
        }
        catch (InvalidChangeOperationException e) {
            throw new BadRequestException(e.getMessage());
        }
        catch (NoSuchChangeException e) {
            throw new ResourceNotFoundException();
        }
        catch (PatchSetInfoNotAvailableException | IncorrectObjectTypeException | MissingObjectException e) {
            throw new ResourceConflictException(e.getMessage());
        }
    }

    @Override
    public UiAction.Description getDescription(RevisionResource resource) {
        PatchSet.Id current = resource.getChange().currentPatchSetId();
        return new UiAction.Description().setLabel("Edit commit message").setVisible(resource.getChange().getStatus().isOpen() && resource.getPatchSet().getId().equals(current) && resource.getControl().canAddPatchSet());
    }

    static class Input {
        @DefaultInput
        String message;

        Input() {
        }
    }
}

