/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.common.GitPerson;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetAncestor;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRelated
implements RestReadView<RevisionResource> {
    private static final Logger log = LoggerFactory.getLogger(GetRelated.class);
    private final GitRepositoryManager gitMgr;
    private final Provider<ReviewDb> dbProvider;

    @Inject
    GetRelated(GitRepositoryManager gitMgr, Provider<ReviewDb> db) {
        this.gitMgr = gitMgr;
        this.dbProvider = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelatedInfo apply(RevisionResource rsrc) throws RepositoryNotFoundException, IOException, OrmException {
        try (Repository git = this.gitMgr.openRepository(rsrc.getChange().getProject());){
            Ref ref = git.getRef(rsrc.getChange().getDest().get());
            RevWalk rw = new RevWalk(git);
            try {
                RelatedInfo info = new RelatedInfo();
                info.changes = this.walk(rsrc, rw, ref);
                RelatedInfo relatedInfo = info;
                rw.close();
                return relatedInfo;
            }
            catch (Throwable throwable) {
                rw.close();
                throw throwable;
            }
        }
    }

    private List<ChangeAndCommit> walk(RevisionResource rsrc, RevWalk rw, Ref ref) throws OrmException, IOException {
        RevCommit c;
        Map<Change.Id, Change> changes = this.allOpenChanges(rsrc);
        Map<PatchSet.Id, PatchSet> patchSets = this.allPatchSets(changes.keySet());
        HashMap<String, PatchSet> commits = Maps.newHashMap();
        for (PatchSet p : patchSets.values()) {
            commits.put(p.getRevision().get(), p);
        }
        RevCommit rev = rw.parseCommit(ObjectId.fromString(rsrc.getPatchSet().getRevision().get()));
        rw.sort(RevSort.TOPO);
        rw.markStart(rev);
        if (ref != null && ref.getObjectId() != null) {
            try {
                rw.markUninteresting(rw.parseCommit(ref.getObjectId()));
            }
            catch (IncorrectObjectTypeException p) {
                // empty catch block
            }
        }
        HashSet<Change.Id> added = Sets.newHashSet();
        ArrayList<ChangeAndCommit> parents = Lists.newArrayList();
        while ((c = rw.next()) != null) {
            PatchSet p = (PatchSet)commits.get(c.name());
            Change g = null;
            if (p != null) {
                g = changes.get(p.getId().getParentKey());
                added.add(p.getId().getParentKey());
            }
            parents.add(new ChangeAndCommit(g, p, c));
        }
        List<ChangeAndCommit> list = this.children(rsrc, rw, changes, patchSets, added);
        list.addAll(parents);
        if (list.size() == 1) {
            ChangeAndCommit r = list.get(0);
            if (r._changeNumber != null && r._revisionNumber != null && r._changeNumber.intValue() == rsrc.getChange().getChangeId() && r._revisionNumber.intValue() == rsrc.getPatchSet().getPatchSetId()) {
                return Collections.emptyList();
            }
        }
        return list;
    }

    private Map<Change.Id, Change> allOpenChanges(RevisionResource rsrc) throws OrmException {
        ReviewDb db = this.dbProvider.get();
        return db.changes().toMap(db.changes().byBranchOpenAll(rsrc.getChange().getDest()));
    }

    private Map<PatchSet.Id, PatchSet> allPatchSets(Collection<Change.Id> ids) throws OrmException {
        int n = ids.size();
        ReviewDb db = this.dbProvider.get();
        ArrayList<ResultSet<PatchSet>> t = Lists.newArrayListWithCapacity(n);
        for (Change.Id id : ids) {
            t.add(db.patchSets().byChange(id));
        }
        HashMap<PatchSet.Id, PatchSet> r = Maps.newHashMapWithExpectedSize(n * 2);
        for (ResultSet resultSet : t) {
            for (PatchSet p : resultSet) {
                r.put(p.getId(), p);
            }
        }
        return r;
    }

    private List<ChangeAndCommit> children(RevisionResource rsrc, RevWalk rw, Map<Change.Id, Change> changes, Map<PatchSet.Id, PatchSet> patchSets, Set<Change.Id> added) throws OrmException, IOException {
        Multimap<String, PatchSet.Id> children = this.allChildren(changes.keySet());
        RevFlag seenCommit = rw.newFlag("seenCommit");
        LinkedList<String> q = Lists.newLinkedList();
        this.seedQueue(rsrc, rw, seenCommit, patchSets, q);
        ProjectControl projectCtl = rsrc.getControl().getProjectControl();
        HashSet seenChange = Sets.newHashSet();
        ArrayList<ChangeAndCommit> graph = Lists.newArrayList();
        while (!q.isEmpty()) {
            String id = q.remove();
            HashMap<Change.Id, PatchSet.Id> matches = Maps.newHashMap();
            for (PatchSet.Id id2 : children.get(id)) {
                PatchSet.Id e = (PatchSet.Id)matches.get(id2.getParentKey());
                if (e != null && e.get() >= id2.get() || !this.isVisible(projectCtl, changes, patchSets, id2)) continue;
                matches.put(id2.getParentKey(), id2);
            }
            for (Map.Entry entry : matches.entrySet()) {
                RevCommit c;
                Change change = changes.get(entry.getKey());
                PatchSet ps = patchSets.get(entry.getValue());
                if (change == null || ps == null || !seenChange.add(entry.getKey()) || (c = rw.parseCommit(ObjectId.fromString(ps.getRevision().get()))).has(seenCommit)) continue;
                c.add(seenCommit);
                q.addFirst(ps.getRevision().get());
                if (!added.add(ps.getId().getParentKey())) continue;
                rw.parseBody(c);
                graph.add(new ChangeAndCommit(change, ps, c));
            }
        }
        Collections.reverse(graph);
        return graph;
    }

    private boolean isVisible(ProjectControl projectCtl, Map<Change.Id, Change> changes, Map<PatchSet.Id, PatchSet> patchSets, PatchSet.Id psId) throws OrmException {
        Change c = changes.get(psId.getParentKey());
        PatchSet ps = patchSets.get(psId);
        if (c != null && ps != null) {
            ChangeControl ctl = projectCtl.controlFor(c);
            return ctl.isVisible(this.dbProvider.get()) && ctl.isPatchVisible(ps, this.dbProvider.get());
        }
        return false;
    }

    private void seedQueue(RevisionResource rsrc, RevWalk rw, RevFlag seenCommit, Map<PatchSet.Id, PatchSet> patchSets, LinkedList<String> q) throws IOException {
        RevCommit tip = rw.parseCommit(ObjectId.fromString(rsrc.getPatchSet().getRevision().get()));
        tip.add(seenCommit);
        q.add(tip.name());
        Change.Id cId = rsrc.getChange().getId();
        for (PatchSet p : patchSets.values()) {
            if (!cId.equals(p.getId().getParentKey())) continue;
            try {
                RevCommit c = rw.parseCommit(ObjectId.fromString(p.getRevision().get()));
                if (c.has(seenCommit)) continue;
                c.add(seenCommit);
                q.add(c.name());
            }
            catch (IOException e) {
                log.warn(String.format("Cannot read patch set %d of %d", p.getPatchSetId(), cId.get()), e);
            }
        }
    }

    private Multimap<String, PatchSet.Id> allChildren(Collection<Change.Id> ids) throws OrmException {
        ReviewDb db = this.dbProvider.get();
        ArrayList<ResultSet<PatchSetAncestor>> t = Lists.newArrayListWithCapacity(ids.size());
        for (Change.Id id : ids) {
            t.add(db.patchSetAncestors().byChange(id));
        }
        ArrayListMultimap<String, PatchSet.Id> r = ArrayListMultimap.create();
        for (ResultSet resultSet : t) {
            for (PatchSetAncestor a : resultSet) {
                r.put(a.getAncestorRevision().get(), a.getPatchSet());
            }
        }
        return r;
    }

    private static GitPerson toGitPerson(PersonIdent id) {
        GitPerson p = new GitPerson();
        p.name = id.getName();
        p.email = id.getEmailAddress();
        p.date = new Timestamp(id.getWhen().getTime());
        p.tz = id.getTimeZoneOffset();
        return p;
    }

    public static class ChangeAndCommit {
        public String changeId;
        public CommitInfo commit;
        public Integer _changeNumber;
        public Integer _revisionNumber;
        public Integer _currentRevisionNumber;

        ChangeAndCommit(@Nullable Change change, @Nullable PatchSet ps, RevCommit c) {
            if (change != null) {
                this.changeId = change.getKey().get();
                this._changeNumber = change.getChangeId();
                this._revisionNumber = ps != null ? Integer.valueOf(ps.getPatchSetId()) : null;
                PatchSet.Id curr = change.currentPatchSetId();
                this._currentRevisionNumber = curr != null ? Integer.valueOf(curr.get()) : null;
            }
            this.commit = new CommitInfo();
            this.commit.commit = c.name();
            this.commit.parents = Lists.newArrayListWithCapacity(c.getParentCount());
            for (int i = 0; i < c.getParentCount(); ++i) {
                CommitInfo p = new CommitInfo();
                p.commit = c.getParent(i).name();
                this.commit.parents.add(p);
            }
            this.commit.author = GetRelated.toGitPerson(c.getAuthorIdent());
            this.commit.subject = c.getShortMessage();
        }
    }

    public static class RelatedInfo {
        public List<ChangeAndCommit> changes;
    }
}

