/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.data.IncludedInDetail;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.IncludedInResolver;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

class IncludedIn
implements RestReadView<ChangeResource> {
    private final ReviewDb db;
    private final GitRepositoryManager repoManager;

    @Inject
    IncludedIn(ReviewDb db, GitRepositoryManager repoManager) {
        this.db = db;
        this.repoManager = repoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncludedInInfo apply(ChangeResource rsrc) throws BadRequestException, ResourceConflictException, OrmException, IOException {
        ChangeControl ctl = rsrc.getControl();
        PatchSet ps = this.db.patchSets().get(ctl.getChange().currentPatchSetId());
        try (Repository r = this.repoManager.openRepository(ctl.getProject().getNameKey());){
            RevWalk rw = new RevWalk(r);
            try {
                RevCommit rev;
                rw.setRetainBody(false);
                try {
                    rev = rw.parseCommit(ObjectId.fromString(ps.getRevision().get()));
                }
                catch (IncorrectObjectTypeException err) {
                    throw new BadRequestException(err.getMessage());
                }
                catch (MissingObjectException err) {
                    throw new ResourceConflictException(err.getMessage());
                }
                IncludedInInfo includedInInfo = new IncludedInInfo(IncludedInResolver.resolve(r, rw, rev));
                rw.close();
                return includedInInfo;
            }
            catch (Throwable throwable) {
                rw.close();
                throw throwable;
            }
        }
    }

    static class IncludedInInfo {
        String kind = "gerritcodereview#includedininfo";
        Collection<String> branches;
        Collection<String> tags;

        IncludedInInfo(IncludedInDetail in) {
            this.branches = in.getBranches();
            this.tags = in.getTags();
        }
    }
}

