/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.events;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetAncestor;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.client.UserIdentity;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.data.AccountAttribute;
import com.google.gerrit.server.data.ApprovalAttribute;
import com.google.gerrit.server.data.ChangeAttribute;
import com.google.gerrit.server.data.DependencyAttribute;
import com.google.gerrit.server.data.MessageAttribute;
import com.google.gerrit.server.data.PatchAttribute;
import com.google.gerrit.server.data.PatchSetAttribute;
import com.google.gerrit.server.data.PatchSetCommentAttribute;
import com.google.gerrit.server.data.RefUpdateAttribute;
import com.google.gerrit.server.data.SubmitLabelAttribute;
import com.google.gerrit.server.data.SubmitRecordAttribute;
import com.google.gerrit.server.data.TrackingIdAttribute;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventFactory {
    private static final Logger log = LoggerFactory.getLogger(EventFactory.class);
    private final AccountCache accountCache;
    private final Provider<String> urlProvider;
    private final PatchListCache patchListCache;
    private final SchemaFactory<ReviewDb> schema;
    private final PatchSetInfoFactory psInfoFactory;
    private final PersonIdent myIdent;
    private final Provider<ReviewDb> db;
    private final ChangeData.Factory changeDataFactory;
    private final ApprovalsUtil approvalsUtil;

    @Inject
    EventFactory(AccountCache accountCache, @CanonicalWebUrl @Nullable Provider<String> urlProvider, PatchSetInfoFactory psif, PatchListCache patchListCache, SchemaFactory<ReviewDb> schema, @GerritPersonIdent PersonIdent myIdent, Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, ApprovalsUtil approvalsUtil) {
        this.accountCache = accountCache;
        this.urlProvider = urlProvider;
        this.patchListCache = patchListCache;
        this.schema = schema;
        this.psInfoFactory = psif;
        this.myIdent = myIdent;
        this.db = db;
        this.changeDataFactory = changeDataFactory;
        this.approvalsUtil = approvalsUtil;
    }

    public ChangeAttribute asChangeAttribute(Change change) {
        ChangeAttribute a = new ChangeAttribute();
        a.project = change.getProject().get();
        a.branch = change.getDest().getShortName();
        a.topic = change.getTopic();
        a.id = change.getKey().get();
        a.number = change.getId().toString();
        a.subject = change.getSubject();
        try {
            a.commitMessage = this.changeDataFactory.create(this.db.get(), change).commitMessage();
        }
        catch (Exception e) {
            log.error("Error while getting full commit message for change " + a.number);
        }
        a.url = this.getChangeUrl(change);
        a.owner = this.asAccountAttribute(change.getOwner());
        a.status = change.getStatus();
        return a;
    }

    public RefUpdateAttribute asRefUpdateAttribute(ObjectId oldId, ObjectId newId, Branch.NameKey refName) {
        RefUpdateAttribute ru = new RefUpdateAttribute();
        ru.newRev = newId != null ? newId.getName() : ObjectId.zeroId().getName();
        ru.oldRev = oldId != null ? oldId.getName() : ObjectId.zeroId().getName();
        ru.project = refName.getParentKey().get();
        ru.refName = refName.getShortName();
        return ru;
    }

    public void extend(ChangeAttribute a, Change change) {
        a.createdOn = change.getCreatedOn().getTime() / 1000L;
        a.lastUpdated = change.getLastUpdatedOn().getTime() / 1000L;
        a.sortKey = change.getSortKey();
        a.open = change.getStatus().isOpen();
    }

    public void addAllReviewers(ChangeAttribute a, ChangeNotes notes) throws OrmException {
        Collection reviewers = this.approvalsUtil.getReviewers(this.db.get(), notes).values();
        if (!reviewers.isEmpty()) {
            a.allReviewers = Lists.newArrayListWithCapacity(reviewers.size());
            for (Account.Id id : reviewers) {
                a.allReviewers.add(this.asAccountAttribute(id));
            }
        }
    }

    public void addSubmitRecords(ChangeAttribute ca, List<SubmitRecord> submitRecords) {
        ca.submitRecords = new ArrayList<SubmitRecordAttribute>();
        for (SubmitRecord submitRecord : submitRecords) {
            SubmitRecordAttribute sa = new SubmitRecordAttribute();
            sa.status = submitRecord.status.name();
            if (submitRecord.status != SubmitRecord.Status.RULE_ERROR) {
                this.addSubmitRecordLabels(submitRecord, sa);
            }
            ca.submitRecords.add(sa);
        }
        if (ca.submitRecords.isEmpty()) {
            ca.submitRecords = null;
        }
    }

    private void addSubmitRecordLabels(SubmitRecord submitRecord, SubmitRecordAttribute sa) {
        if (submitRecord.labels != null && !submitRecord.labels.isEmpty()) {
            sa.labels = new ArrayList<SubmitLabelAttribute>();
            for (SubmitRecord.Label lbl : submitRecord.labels) {
                SubmitLabelAttribute la = new SubmitLabelAttribute();
                la.label = lbl.label;
                la.status = lbl.status.name();
                if (lbl.appliedBy != null) {
                    Account a = this.accountCache.get(lbl.appliedBy).getAccount();
                    la.by = this.asAccountAttribute(a);
                }
                sa.labels.add(la);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependencies(ChangeAttribute ca, Change change) {
        ca.dependsOn = new ArrayList<DependencyAttribute>();
        ca.neededBy = new ArrayList<DependencyAttribute>();
        try (ReviewDb db = this.schema.open();){
            PatchSet.Id psId = change.currentPatchSetId();
            for (PatchSetAncestor a : db.patchSetAncestors().ancestorsOf(psId)) {
                for (PatchSet p : db.patchSets().byRevision(a.getAncestorRevision())) {
                    Change c = db.changes().get(p.getId().getParentKey());
                    ca.dependsOn.add(this.newDependsOn(c, p));
                }
            }
            PatchSet ps = db.patchSets().get(psId);
            if (ps == null) {
                log.error("Error while generating the list of descendants for PatchSet " + psId + ": Cannot find PatchSet entry in" + " database.");
            } else {
                RevId revId = ps.getRevision();
                for (PatchSetAncestor a : db.patchSetAncestors().descendantsOf(revId)) {
                    PatchSet p = db.patchSets().get(a.getPatchSet());
                    if (p == null) {
                        log.error("Error while generating the list of descendants for revision " + revId.get() + ": Cannot find PatchSet entry in" + " database for " + a.getPatchSet());
                        continue;
                    }
                    Change c = db.changes().get(p.getId().getParentKey());
                    ca.neededBy.add(this.newNeededBy(c, p));
                }
            }
        }
        catch (OrmException ormException) {
            // empty catch block
        }
        if (ca.dependsOn.isEmpty()) {
            ca.dependsOn = null;
        }
        if (ca.neededBy.isEmpty()) {
            ca.neededBy = null;
        }
    }

    private DependencyAttribute newDependsOn(Change c, PatchSet ps) {
        DependencyAttribute d = this.newDependencyAttribute(c, ps);
        d.isCurrentPatchSet = ps.getId().equals(c.currentPatchSetId());
        return d;
    }

    private DependencyAttribute newNeededBy(Change c, PatchSet ps) {
        return this.newDependencyAttribute(c, ps);
    }

    private DependencyAttribute newDependencyAttribute(Change c, PatchSet ps) {
        DependencyAttribute d = new DependencyAttribute();
        d.number = c.getId().toString();
        d.id = c.getKey().toString();
        d.revision = ps.getRevision().get();
        d.ref = ps.getRefName();
        return d;
    }

    public void addTrackingIds(ChangeAttribute a, Multimap<String, String> set) {
        if (!set.isEmpty()) {
            a.trackingIds = new ArrayList<TrackingIdAttribute>(set.size());
            for (Map.Entry<String, Collection<String>> e : set.asMap().entrySet()) {
                for (String id : e.getValue()) {
                    TrackingIdAttribute t = new TrackingIdAttribute();
                    t.system = e.getKey();
                    t.id = id;
                    a.trackingIds.add(t);
                }
            }
        }
    }

    public void addCommitMessage(ChangeAttribute a, String commitMessage) {
        a.commitMessage = commitMessage;
    }

    public void addPatchSets(ChangeAttribute a, Collection<PatchSet> ps, LabelTypes labelTypes) {
        this.addPatchSets(a, ps, null, false, null, labelTypes);
    }

    public void addPatchSets(ChangeAttribute ca, Collection<PatchSet> ps, Map<PatchSet.Id, Collection<PatchSetApproval>> approvals, LabelTypes labelTypes) {
        this.addPatchSets(ca, ps, approvals, false, null, labelTypes);
    }

    public void addPatchSets(ChangeAttribute ca, Collection<PatchSet> ps, Map<PatchSet.Id, Collection<PatchSetApproval>> approvals, boolean includeFiles, Change change, LabelTypes labelTypes) {
        if (!ps.isEmpty()) {
            ca.patchSets = new ArrayList<PatchSetAttribute>(ps.size());
            for (PatchSet p : ps) {
                PatchSetAttribute psa = this.asPatchSetAttribute(p);
                if (approvals != null) {
                    this.addApprovals(psa, p.getId(), approvals, labelTypes);
                }
                ca.patchSets.add(psa);
                if (!includeFiles || change == null) continue;
                this.addPatchSetFileNames(psa, change, p);
            }
        }
    }

    public void addPatchSetComments(PatchSetAttribute patchSetAttribute, Collection<PatchLineComment> patchLineComments) {
        for (PatchLineComment comment : patchLineComments) {
            if (comment.getKey().getParentKey().getParentKey().get() != Integer.parseInt(patchSetAttribute.number)) continue;
            if (patchSetAttribute.comments == null) {
                patchSetAttribute.comments = new ArrayList<PatchSetCommentAttribute>();
            }
            patchSetAttribute.comments.add(this.asPatchSetLineAttribute(comment));
        }
    }

    public void addPatchSetFileNames(PatchSetAttribute patchSetAttribute, Change change, PatchSet patchSet) {
        try {
            PatchList patchList = this.patchListCache.get(change, patchSet);
            for (PatchListEntry patch : patchList.getPatches()) {
                if (patchSetAttribute.files == null) {
                    patchSetAttribute.files = new ArrayList<PatchAttribute>();
                }
                PatchAttribute p = new PatchAttribute();
                p.file = patch.getNewName();
                p.fileOld = patch.getOldName();
                p.type = patch.getChangeType();
                p.deletions -= patch.getDeletions();
                p.insertions = patch.getInsertions();
                patchSetAttribute.files.add(p);
            }
        }
        catch (PatchListNotAvailableException patchListNotAvailableException) {
            // empty catch block
        }
    }

    public void addComments(ChangeAttribute ca, Collection<ChangeMessage> messages) {
        if (!messages.isEmpty()) {
            ca.comments = new ArrayList<MessageAttribute>();
            for (ChangeMessage message : messages) {
                ca.comments.add(this.asMessageAttribute(message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchSetAttribute asPatchSetAttribute(PatchSet patchSet) {
        PatchSetAttribute p = new PatchSetAttribute();
        p.revision = patchSet.getRevision().get();
        p.number = Integer.toString(patchSet.getPatchSetId());
        p.ref = patchSet.getRefName();
        p.uploader = this.asAccountAttribute(patchSet.getUploader());
        p.createdOn = patchSet.getCreatedOn().getTime() / 1000L;
        p.isDraft = patchSet.isDraft();
        PatchSet.Id pId = patchSet.getId();
        try (ReviewDb db = this.schema.open();){
            p.parents = new ArrayList<String>();
            for (PatchSetAncestor a : db.patchSetAncestors().ancestorsOf(patchSet.getId())) {
                p.parents.add(a.getAncestorRevision().get());
            }
            UserIdentity author = this.psInfoFactory.get(db, pId).getAuthor();
            if (author.getAccount() == null) {
                p.author = new AccountAttribute();
                p.author.email = author.getEmail();
                p.author.name = author.getName();
                p.author.username = "";
            } else {
                p.author = this.asAccountAttribute(author.getAccount());
            }
            Change change = db.changes().get(pId.getParentKey());
            List<Patch> list = this.patchListCache.get(change, patchSet).toPatchList(pId);
            for (Patch pe : list) {
                if ("/COMMIT_MSG".equals(pe.getFileName())) continue;
                p.sizeDeletions -= pe.getDeletions();
                p.sizeInsertions += pe.getInsertions();
            }
        }
        catch (OrmException e) {
            log.error("Cannot load patch set data for " + patchSet.getId(), e);
        }
        catch (PatchSetInfoNotAvailableException e) {
            log.error(String.format("Cannot get authorEmail for %s.", pId), e);
        }
        catch (PatchListNotAvailableException e) {
            log.error(String.format("Cannot get size information for %s.", pId), e);
        }
        return p;
    }

    public void addApprovals(PatchSetAttribute p, PatchSet.Id id, Map<PatchSet.Id, Collection<PatchSetApproval>> all, LabelTypes labelTypes) {
        Collection<PatchSetApproval> list = all.get(id);
        if (list != null) {
            this.addApprovals(p, list, labelTypes);
        }
    }

    public void addApprovals(PatchSetAttribute p, Collection<PatchSetApproval> list, LabelTypes labelTypes) {
        if (!list.isEmpty()) {
            p.approvals = new ArrayList<ApprovalAttribute>(list.size());
            for (PatchSetApproval a : list) {
                if (a.getValue() == 0) continue;
                p.approvals.add(this.asApprovalAttribute(a, labelTypes));
            }
            if (p.approvals.isEmpty()) {
                p.approvals = null;
            }
        }
    }

    public AccountAttribute asAccountAttribute(Account.Id id) {
        if (id == null) {
            return null;
        }
        return this.asAccountAttribute(this.accountCache.get(id).getAccount());
    }

    public AccountAttribute asAccountAttribute(Account account) {
        AccountAttribute who = new AccountAttribute();
        who.name = account.getFullName();
        who.email = account.getPreferredEmail();
        who.username = account.getUserName();
        return who;
    }

    public AccountAttribute asAccountAttribute(PersonIdent ident) {
        AccountAttribute who = new AccountAttribute();
        who.name = ident.getName();
        who.email = ident.getEmailAddress();
        return who;
    }

    public ApprovalAttribute asApprovalAttribute(PatchSetApproval approval, LabelTypes labelTypes) {
        ApprovalAttribute a = new ApprovalAttribute();
        a.type = approval.getLabelId().get();
        a.value = Short.toString(approval.getValue());
        a.by = this.asAccountAttribute(approval.getAccountId());
        a.grantedOn = approval.getGranted().getTime() / 1000L;
        LabelType lt = labelTypes.byLabel(approval.getLabelId());
        if (lt != null) {
            a.description = lt.getName();
        }
        return a;
    }

    public MessageAttribute asMessageAttribute(ChangeMessage message) {
        MessageAttribute a = new MessageAttribute();
        a.timestamp = message.getWrittenOn().getTime() / 1000L;
        a.reviewer = message.getAuthor() != null ? this.asAccountAttribute(message.getAuthor()) : this.asAccountAttribute(this.myIdent);
        a.message = message.getMessage();
        return a;
    }

    public PatchSetCommentAttribute asPatchSetLineAttribute(PatchLineComment c) {
        PatchSetCommentAttribute a = new PatchSetCommentAttribute();
        a.reviewer = this.asAccountAttribute(c.getAuthor());
        a.file = c.getKey().getParentKey().get();
        a.line = c.getLine();
        a.message = c.getMessage();
        return a;
    }

    private String getChangeUrl(Change change) {
        if (change != null && this.urlProvider.get() != null) {
            StringBuilder r = new StringBuilder();
            r.append(this.urlProvider.get());
            r.append(change.getChangeId());
            return r.toString();
        }
        return null;
    }
}

