/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.common.errors.PermissionDeniedException;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.BanCommitResult;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeException;
import com.google.gerrit.server.git.NotesBranchUtil;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class BanCommit {
    private final Provider<IdentifiedUser> currentUser;
    private final GitRepositoryManager repoManager;
    private final PersonIdent gerritIdent;
    private NotesBranchUtil.Factory notesBranchUtilFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NoteMap loadRejectCommitsMap(Repository repo) throws IOException {
        Ref ref = repo.getRef("refs/meta/reject-commits");
        if (ref == null) {
            return NoteMap.newEmptyMap();
        }
        RevWalk rw = new RevWalk(repo);
        try {
            RevCommit map = rw.parseCommit(ref.getObjectId());
            NoteMap noteMap = NoteMap.read(rw.getObjectReader(), map);
            rw.close();
            return noteMap;
        }
        catch (Throwable throwable) {
            try {
                rw.close();
                throw throwable;
            }
            catch (IOException badMap) {
                throw new IOException("Cannot load refs/meta/reject-commits", badMap);
            }
        }
    }

    @Inject
    BanCommit(Provider<IdentifiedUser> currentUser, GitRepositoryManager repoManager, @GerritPersonIdent PersonIdent gerritIdent, NotesBranchUtil.Factory notesBranchUtilFactory) {
        this.currentUser = currentUser;
        this.repoManager = repoManager;
        this.gerritIdent = gerritIdent;
        this.notesBranchUtilFactory = notesBranchUtilFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BanCommitResult ban(ProjectControl projectControl, List<ObjectId> commitsToBan, String reason) throws PermissionDeniedException, IOException, InterruptedException, MergeException, ConcurrentRefUpdateException {
        if (!projectControl.isOwner()) {
            throw new PermissionDeniedException("No project owner: not permitted to ban commits");
        }
        BanCommitResult result = new BanCommitResult();
        NoteMap banCommitNotes = NoteMap.newEmptyMap();
        Project.NameKey project = projectControl.getProject().getNameKey();
        try (Repository repo = this.repoManager.openRepository(project);){
            RevWalk revWalk = new RevWalk(repo);
            ObjectInserter inserter = repo.newObjectInserter();
            try {
                for (ObjectId commitToBan : commitsToBan) {
                    try {
                        revWalk.parseCommit(commitToBan);
                    }
                    catch (MissingObjectException missingObjectException) {
                    }
                    catch (IncorrectObjectTypeException e) {
                        result.notACommit(commitToBan, e.getMessage());
                        continue;
                    }
                    banCommitNotes.set(commitToBan, this.createNoteContent(reason, inserter));
                }
                inserter.flush();
                NotesBranchUtil notesBranchUtil = this.notesBranchUtilFactory.create(project, repo, inserter);
                NoteMap newlyCreated = notesBranchUtil.commitNewNotes(banCommitNotes, "refs/meta/reject-commits", this.createPersonIdent(), BanCommit.buildCommitMessage(commitsToBan, reason));
                for (Note n : banCommitNotes) {
                    if (newlyCreated.contains(n)) {
                        result.commitBanned(n);
                        continue;
                    }
                    result.commitAlreadyBanned(n);
                }
                BanCommitResult banCommitResult = result;
                revWalk.close();
                inserter.close();
                return banCommitResult;
            }
            catch (Throwable throwable) {
                revWalk.close();
                inserter.close();
                throw throwable;
            }
        }
    }

    private ObjectId createNoteContent(String reason, ObjectInserter inserter) throws UnsupportedEncodingException, IOException {
        String noteContent;
        String string = noteContent = reason != null ? reason : "";
        if (noteContent.length() > 0 && !noteContent.endsWith("\n")) {
            noteContent = noteContent + "\n";
        }
        return inserter.insert(3, noteContent.getBytes("UTF-8"));
    }

    private PersonIdent createPersonIdent() {
        Date now = new Date();
        TimeZone tz = this.gerritIdent.getTimeZone();
        return this.currentUser.get().newCommitterIdent(now, tz);
    }

    private static String buildCommitMessage(List<ObjectId> bannedCommits, String reason) {
        StringBuilder commitMsg = new StringBuilder();
        commitMsg.append("Banning ");
        commitMsg.append(bannedCommits.size());
        commitMsg.append(" ");
        commitMsg.append(bannedCommits.size() == 1 ? "commit" : "commits");
        commitMsg.append("\n\n");
        if (reason != null) {
            commitMsg.append("Reason: ");
            commitMsg.append(reason);
            commitMsg.append("\n\n");
        }
        commitMsg.append("The following commits are banned:\n");
        StringBuilder commitList = new StringBuilder();
        for (ObjectId c : bannedCommits) {
            if (commitList.length() > 0) {
                commitList.append(",\n");
            }
            commitList.append(c.getName());
        }
        commitMsg.append((CharSequence)commitList);
        return commitMsg.toString();
    }

    public static interface Factory {
        public BanCommit create();
    }
}

