/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Shorts;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.data.GlobalCapability;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountProjectWatch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.git.AccountsSection;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.NotifyConfig;
import com.google.gerrit.server.git.ValidationError;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.project.CommentLinkInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.StringUtils;

public class ProjectConfig
extends VersionedMetaData {
    public static final String COMMENTLINK = "commentlink";
    private static final String KEY_MATCH = "match";
    private static final String KEY_HTML = "html";
    private static final String KEY_LINK = "link";
    private static final String KEY_ENABLED = "enabled";
    public static final String PROJECT_CONFIG = "project.config";
    private static final String GROUP_LIST = "groups";
    private static final String PROJECT = "project";
    private static final String KEY_DESCRIPTION = "description";
    private static final String ACCESS = "access";
    private static final String KEY_INHERIT_FROM = "inheritFrom";
    private static final String KEY_GROUP_PERMISSIONS = "exclusiveGroupPermissions";
    private static final String ACCOUNTS = "accounts";
    private static final String KEY_SAME_GROUP_VISIBILITY = "sameGroupVisibility";
    private static final String CONTRIBUTOR_AGREEMENT = "contributor-agreement";
    private static final String KEY_ACCEPTED = "accepted";
    private static final String KEY_REQUIRE_CONTACT_INFORMATION = "requireContactInformation";
    private static final String KEY_AUTO_VERIFY = "autoVerify";
    private static final String KEY_AGREEMENT_URL = "agreementUrl";
    private static final String NOTIFY = "notify";
    private static final String KEY_EMAIL = "email";
    private static final String KEY_FILTER = "filter";
    private static final String KEY_TYPE = "type";
    private static final String KEY_HEADER = "header";
    private static final String CAPABILITY = "capability";
    private static final String RECEIVE = "receive";
    private static final String KEY_REQUIRE_SIGNED_OFF_BY = "requireSignedOffBy";
    private static final String KEY_REQUIRE_CHANGE_ID = "requireChangeId";
    private static final String KEY_MAX_OBJECT_SIZE_LIMIT = "maxObjectSizeLimit";
    private static final String KEY_REQUIRE_CONTRIBUTOR_AGREEMENT = "requireContributorAgreement";
    private static final String KEY_CHECK_RECEIVED_OBJECTS = "checkReceivedObjects";
    private static final String SUBMIT = "submit";
    private static final String KEY_ACTION = "action";
    private static final String KEY_MERGE_CONTENT = "mergeContent";
    private static final String KEY_STATE = "state";
    private static final String DASHBOARD = "dashboard";
    private static final String KEY_DEFAULT = "default";
    private static final String KEY_LOCAL_DEFAULT = "local-default";
    private static final String LABEL = "label";
    private static final String KEY_ABBREVIATION = "abbreviation";
    private static final String KEY_FUNCTION = "function";
    private static final String KEY_COPY_MIN_SCORE = "copyMinScore";
    private static final String KEY_COPY_MAX_SCORE = "copyMaxScore";
    private static final String KEY_COPY_ALL_SCORES_ON_TRIVIAL_REBASE = "copyAllScoresOnTrivialRebase";
    private static final String KEY_COPY_ALL_SCORES_IF_NO_CHANGE = "copyAllScoresIfNoCodeChange";
    private static final String KEY_VALUE = "value";
    private static final String KEY_CAN_OVERRIDE = "canOverride";
    private static final String KEY_Branch = "branch";
    private static final Set<String> LABEL_FUNCTIONS = ImmutableSet.of("MaxWithBlock", "AnyWithBlock", "MaxNoBlock", "NoBlock", "NoOp");
    private static final String PLUGIN = "plugin";
    private static final Project.SubmitType defaultSubmitAction = Project.SubmitType.MERGE_IF_NECESSARY;
    private static final Project.State defaultStateValue = Project.State.ACTIVE;
    private Project.NameKey projectName;
    private Project project;
    private AccountsSection accountsSection;
    private Map<AccountGroup.UUID, GroupReference> groupsByUUID;
    private Map<String, AccessSection> accessSections;
    private Map<String, ContributorAgreement> contributorAgreements;
    private Map<String, NotifyConfig> notifySections;
    private Map<String, LabelType> labelSections;
    private List<CommentLinkInfo> commentLinkSections;
    private List<ValidationError> validationErrors;
    private ObjectId rulesId;
    private long maxObjectSizeLimit;
    private Map<String, Config> pluginConfigs;
    private boolean checkReceivedObjects;

    public static ProjectConfig read(MetaDataUpdate update) throws IOException, ConfigInvalidException {
        ProjectConfig r = new ProjectConfig(update.getProjectName());
        r.load(update);
        return r;
    }

    public static ProjectConfig read(MetaDataUpdate update, ObjectId id) throws IOException, ConfigInvalidException {
        ProjectConfig r = new ProjectConfig(update.getProjectName());
        r.load(update, id);
        return r;
    }

    public static CommentLinkInfo buildCommentLink(Config cfg, String name, boolean allowRaw) throws IllegalArgumentException {
        String match = cfg.getString(COMMENTLINK, name, KEY_MATCH);
        if (match != null) {
            Pattern.compile(match);
        }
        String link = cfg.getString(COMMENTLINK, name, KEY_LINK);
        String html = cfg.getString(COMMENTLINK, name, KEY_HTML);
        boolean hasHtml = !Strings.isNullOrEmpty(html);
        String rawEnabled = cfg.getString(COMMENTLINK, name, KEY_ENABLED);
        Boolean enabled = rawEnabled != null ? Boolean.valueOf(cfg.getBoolean(COMMENTLINK, name, KEY_ENABLED, true)) : null;
        Preconditions.checkArgument(allowRaw || !hasHtml, "Raw html replacement not allowed");
        if (Strings.isNullOrEmpty(match) && Strings.isNullOrEmpty(link) && !hasHtml && enabled != null) {
            if (enabled.booleanValue()) {
                return new CommentLinkInfo.Enabled(name);
            }
            return new CommentLinkInfo.Disabled(name);
        }
        return new CommentLinkInfo(name, match, link, html, enabled);
    }

    public ProjectConfig(Project.NameKey projectName) {
        this.projectName = projectName;
    }

    public Project getProject() {
        return this.project;
    }

    public AccountsSection getAccountsSection() {
        return this.accountsSection;
    }

    public AccessSection getAccessSection(String name) {
        return this.getAccessSection(name, false);
    }

    public AccessSection getAccessSection(String name, boolean create) {
        AccessSection as = this.accessSections.get(name);
        if (as == null && create) {
            as = new AccessSection(name);
            this.accessSections.put(name, as);
        }
        return as;
    }

    public Collection<AccessSection> getAccessSections() {
        return ProjectConfig.sort(this.accessSections.values());
    }

    public void remove(AccessSection section) {
        if (section != null) {
            this.accessSections.remove(section.getName());
        }
    }

    public void replace(AccessSection section) {
        for (Permission permission : section.getPermissions()) {
            for (PermissionRule rule : permission.getRules()) {
                rule.setGroup(this.resolve(rule.getGroup()));
            }
        }
        this.accessSections.put(section.getName(), section);
    }

    public ContributorAgreement getContributorAgreement(String name) {
        return this.getContributorAgreement(name, false);
    }

    public ContributorAgreement getContributorAgreement(String name, boolean create) {
        ContributorAgreement ca = this.contributorAgreements.get(name);
        if (ca == null && create) {
            ca = new ContributorAgreement(name);
            this.contributorAgreements.put(name, ca);
        }
        return ca;
    }

    public Collection<ContributorAgreement> getContributorAgreements() {
        return ProjectConfig.sort(this.contributorAgreements.values());
    }

    public void remove(ContributorAgreement section) {
        if (section != null) {
            this.accessSections.remove(section.getName());
        }
    }

    public void replace(ContributorAgreement section) {
        section.setAutoVerify(this.resolve(section.getAutoVerify()));
        for (PermissionRule rule : section.getAccepted()) {
            rule.setGroup(this.resolve(rule.getGroup()));
        }
        this.contributorAgreements.put(section.getName(), section);
    }

    public Collection<NotifyConfig> getNotifyConfigs() {
        return this.notifySections.values();
    }

    public Map<String, LabelType> getLabelSections() {
        return this.labelSections;
    }

    public Collection<CommentLinkInfo> getCommentLinkSections() {
        return this.commentLinkSections;
    }

    public GroupReference resolve(AccountGroup group) {
        return this.resolve(GroupReference.forGroup(group));
    }

    public GroupReference resolve(GroupReference group) {
        if (group != null) {
            GroupReference ref = this.groupsByUUID.get(group.getUUID());
            if (ref != null) {
                return ref;
            }
            this.groupsByUUID.put(group.getUUID(), group);
        }
        return group;
    }

    public GroupReference getGroup(AccountGroup.UUID uuid) {
        return this.groupsByUUID.get(uuid);
    }

    public Set<AccountGroup.UUID> getAllGroupUUIDs() {
        return Collections.unmodifiableSet(this.groupsByUUID.keySet());
    }

    public ObjectId getRulesId() {
        return this.rulesId;
    }

    public long getMaxObjectSizeLimit() {
        return this.maxObjectSizeLimit;
    }

    public boolean getCheckReceivedObjects() {
        return this.checkReceivedObjects;
    }

    public boolean updateGroupNames(GroupBackend groupBackend) {
        boolean dirty = false;
        for (GroupReference ref : this.groupsByUUID.values()) {
            GroupDescription.Basic g = groupBackend.get(ref.getUUID());
            if (g == null || g.getName().equals(ref.getName())) continue;
            dirty = true;
            ref.setName(g.getName());
        }
        return dirty;
    }

    public List<ValidationError> getValidationErrors() {
        if (this.validationErrors != null) {
            return Collections.unmodifiableList(this.validationErrors);
        }
        return Collections.emptyList();
    }

    @Override
    protected String getRefName() {
        return "refs/meta/config";
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        Map<String, GroupReference> groupsByName = this.readGroupList();
        this.rulesId = this.getObjectId("rules.pl");
        Config rc = this.readConfig(PROJECT_CONFIG);
        Project p = this.project = new Project(this.projectName);
        p.setDescription(rc.getString(PROJECT, null, KEY_DESCRIPTION));
        if (p.getDescription() == null) {
            p.setDescription("");
        }
        p.setParentName(rc.getString(ACCESS, null, KEY_INHERIT_FROM));
        p.setUseContributorAgreements(this.getEnum(rc, RECEIVE, null, KEY_REQUIRE_CONTRIBUTOR_AGREEMENT, Project.InheritableBoolean.INHERIT));
        p.setUseSignedOffBy(this.getEnum(rc, RECEIVE, null, KEY_REQUIRE_SIGNED_OFF_BY, Project.InheritableBoolean.INHERIT));
        p.setRequireChangeID(this.getEnum(rc, RECEIVE, null, KEY_REQUIRE_CHANGE_ID, Project.InheritableBoolean.INHERIT));
        p.setMaxObjectSizeLimit(rc.getString(RECEIVE, null, KEY_MAX_OBJECT_SIZE_LIMIT));
        p.setSubmitType(this.getEnum(rc, SUBMIT, null, KEY_ACTION, defaultSubmitAction));
        p.setUseContentMerge(this.getEnum(rc, SUBMIT, null, KEY_MERGE_CONTENT, Project.InheritableBoolean.INHERIT));
        p.setState(this.getEnum(rc, PROJECT, null, KEY_STATE, defaultStateValue));
        p.setDefaultDashboard(rc.getString(DASHBOARD, null, KEY_DEFAULT));
        p.setLocalDefaultDashboard(rc.getString(DASHBOARD, null, KEY_LOCAL_DEFAULT));
        this.loadAccountsSection(rc, groupsByName);
        this.loadContributorAgreements(rc, groupsByName);
        this.loadAccessSections(rc, groupsByName);
        this.loadNotifySections(rc, groupsByName);
        this.loadLabelSections(rc);
        this.loadCommentLinkSections(rc);
        this.loadPluginSections(rc);
        this.loadReceiveSection(rc);
    }

    private void loadAccountsSection(Config rc, Map<String, GroupReference> groupsByName) {
        this.accountsSection = new AccountsSection();
        this.accountsSection.setSameGroupVisibility(this.loadPermissionRules(rc, ACCOUNTS, null, KEY_SAME_GROUP_VISIBILITY, groupsByName, false));
    }

    private void loadContributorAgreements(Config rc, Map<String, GroupReference> groupsByName) {
        this.contributorAgreements = new HashMap<String, ContributorAgreement>();
        for (String name : rc.getSubsections(CONTRIBUTOR_AGREEMENT)) {
            ContributorAgreement ca = this.getContributorAgreement(name, true);
            ca.setDescription(rc.getString(CONTRIBUTOR_AGREEMENT, name, KEY_DESCRIPTION));
            ca.setRequireContactInformation(rc.getBoolean(CONTRIBUTOR_AGREEMENT, name, KEY_REQUIRE_CONTACT_INFORMATION, false));
            ca.setAgreementUrl(rc.getString(CONTRIBUTOR_AGREEMENT, name, KEY_AGREEMENT_URL));
            ca.setAccepted(this.loadPermissionRules(rc, CONTRIBUTOR_AGREEMENT, name, KEY_ACCEPTED, groupsByName, false));
            List<PermissionRule> rules = this.loadPermissionRules(rc, CONTRIBUTOR_AGREEMENT, name, KEY_AUTO_VERIFY, groupsByName, false);
            if (rules.isEmpty()) {
                ca.setAutoVerify(null);
                continue;
            }
            if (rules.size() > 1) {
                this.error(new ValidationError(PROJECT_CONFIG, "Invalid rule in contributor-agreement." + name + "." + KEY_AUTO_VERIFY + ": at most one group may be set"));
                continue;
            }
            if (rules.get(0).getAction() != PermissionRule.Action.ALLOW) {
                this.error(new ValidationError(PROJECT_CONFIG, "Invalid rule in contributor-agreement." + name + "." + KEY_AUTO_VERIFY + ": the group must be allowed"));
                continue;
            }
            ca.setAutoVerify(rules.get(0).getGroup());
        }
    }

    private void loadNotifySections(Config rc, Map<String, GroupReference> groupsByName) {
        this.notifySections = Maps.newHashMap();
        for (String sectionName : rc.getSubsections(NOTIFY)) {
            NotifyConfig n = new NotifyConfig();
            n.setName(sectionName);
            n.setFilter(rc.getString(NOTIFY, sectionName, KEY_FILTER));
            EnumSet<AccountProjectWatch.NotifyType> types = EnumSet.noneOf(AccountProjectWatch.NotifyType.class);
            types.addAll(ConfigUtil.getEnumList(rc, NOTIFY, sectionName, KEY_TYPE, AccountProjectWatch.NotifyType.ALL));
            n.setTypes(types);
            n.setHeader(ConfigUtil.getEnum(rc, NOTIFY, sectionName, KEY_HEADER, NotifyConfig.Header.BCC));
            for (String dst : rc.getStringList(NOTIFY, sectionName, KEY_EMAIL)) {
                if (dst.startsWith("group ")) {
                    String groupName = dst.substring(6).trim();
                    GroupReference ref = groupsByName.get(groupName);
                    if (ref == null) {
                        ref = new GroupReference(null, groupName);
                        groupsByName.put(ref.getName(), ref);
                    }
                    if (ref.getUUID() != null) {
                        n.addEmail(ref);
                        continue;
                    }
                    this.error(new ValidationError(PROJECT_CONFIG, "group \"" + ref.getName() + "\" not in " + GROUP_LIST));
                    continue;
                }
                if (dst.startsWith("user ")) {
                    this.error(new ValidationError(PROJECT_CONFIG, dst + " not supported"));
                    continue;
                }
                try {
                    n.addEmail(Address.parse(dst));
                }
                catch (IllegalArgumentException err) {
                    this.error(new ValidationError(PROJECT_CONFIG, "notify section \"" + sectionName + "\" has invalid email \"" + dst + "\""));
                }
            }
            this.notifySections.put(sectionName, n);
        }
    }

    private void loadAccessSections(Config rc, Map<String, GroupReference> groupsByName) {
        this.accessSections = new HashMap<String, AccessSection>();
        for (String refName : rc.getSubsections(ACCESS)) {
            if (!RefConfigSection.isValid(refName)) continue;
            AccessSection as = this.getAccessSection(refName, true);
            for (String varName : rc.getStringList(ACCESS, refName, KEY_GROUP_PERMISSIONS)) {
                for (String n : varName.split("[, \t]{1,}")) {
                    if (!Permission.isPermission(n)) continue;
                    as.getPermission(n, true).setExclusiveGroup(true);
                }
            }
            for (String varName : rc.getNames(ACCESS, refName)) {
                if (!Permission.isPermission(varName)) continue;
                Permission perm = as.getPermission(varName, true);
                this.loadPermissionRules(rc, ACCESS, refName, varName, groupsByName, perm, Permission.hasRange(varName));
            }
        }
        AccessSection capability = null;
        for (String varName : rc.getNames(CAPABILITY)) {
            if (capability == null) {
                capability = new AccessSection("GLOBAL_CAPABILITIES");
                this.accessSections.put("GLOBAL_CAPABILITIES", capability);
            }
            Permission perm = capability.getPermission(varName, true);
            this.loadPermissionRules(rc, CAPABILITY, null, varName, groupsByName, perm, GlobalCapability.hasRange(varName));
        }
    }

    private List<PermissionRule> loadPermissionRules(Config rc, String section, String subsection, String varName, Map<String, GroupReference> groupsByName, boolean useRange) {
        Permission perm = new Permission(varName);
        this.loadPermissionRules(rc, section, subsection, varName, groupsByName, perm, useRange);
        return perm.getRules();
    }

    private void loadPermissionRules(Config rc, String section, String subsection, String varName, Map<String, GroupReference> groupsByName, Permission perm, boolean useRange) {
        for (String ruleString : rc.getStringList(section, subsection, varName)) {
            PermissionRule rule;
            try {
                rule = PermissionRule.fromString(ruleString, useRange);
            }
            catch (IllegalArgumentException notRule) {
                this.error(new ValidationError(PROJECT_CONFIG, "Invalid rule in " + section + (subsection != null ? "." + subsection : "") + "." + varName + ": " + notRule.getMessage()));
                continue;
            }
            GroupReference ref = groupsByName.get(rule.getGroup().getName());
            if (ref == null) {
                ref = rule.getGroup();
                groupsByName.put(ref.getName(), ref);
                this.error(new ValidationError(PROJECT_CONFIG, "group \"" + ref.getName() + "\" not in " + GROUP_LIST));
            }
            rule.setGroup(ref);
            perm.add(rule);
        }
    }

    private static LabelValue parseLabelValue(String src) {
        ImmutableList<String> parts = ImmutableList.copyOf(Splitter.on(CharMatcher.WHITESPACE).omitEmptyStrings().limit(2).split(src));
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("empty value");
        }
        String valueText = parts.size() > 1 ? (String)parts.get(1) : "";
        return new LabelValue(Shorts.checkedCast(PermissionRule.parseInt((String)parts.get(0))), valueText);
    }

    private void loadLabelSections(Config rc) throws IOException {
        HashMap<String, String> lowerNames = Maps.newHashMapWithExpectedSize(2);
        this.labelSections = Maps.newLinkedHashMap();
        for (String name : rc.getSubsections(LABEL)) {
            String functionName;
            LabelType label;
            String lower = name.toLowerCase();
            if (lowerNames.containsKey(lower)) {
                this.error(new ValidationError(PROJECT_CONFIG, String.format("Label \"%s\" conflicts with \"%s\"", name, lowerNames.get(lower))));
            }
            lowerNames.put(lower, name);
            ArrayList<LabelValue> values = Lists.newArrayList();
            for (String value : rc.getStringList(LABEL, name, KEY_VALUE)) {
                try {
                    values.add(ProjectConfig.parseLabelValue(value));
                }
                catch (IllegalArgumentException notValue) {
                    this.error(new ValidationError(PROJECT_CONFIG, String.format("Invalid %s \"%s\" for label \"%s\": %s", KEY_VALUE, value, name, notValue.getMessage())));
                }
            }
            try {
                label = new LabelType(name, values);
            }
            catch (IllegalArgumentException badName) {
                this.error(new ValidationError(PROJECT_CONFIG, String.format("Invalid label \"%s\"", name)));
                continue;
            }
            String abbr = rc.getString(LABEL, name, KEY_ABBREVIATION);
            if (abbr != null) {
                label.setAbbreviation(abbr);
            }
            if (LABEL_FUNCTIONS.contains(functionName = Objects.firstNonNull(rc.getString(LABEL, name, KEY_FUNCTION), "MaxWithBlock"))) {
                label.setFunctionName(functionName);
            } else {
                this.error(new ValidationError(PROJECT_CONFIG, String.format("Invalid %s for label \"%s\". Valid names are: %s", KEY_FUNCTION, name, Joiner.on(", ").join(LABEL_FUNCTIONS))));
                label.setFunctionName(null);
            }
            label.setCopyMinScore(rc.getBoolean(LABEL, name, KEY_COPY_MIN_SCORE, false));
            label.setCopyMaxScore(rc.getBoolean(LABEL, name, KEY_COPY_MAX_SCORE, false));
            label.setCopyAllScoresOnTrivialRebase(rc.getBoolean(LABEL, name, KEY_COPY_ALL_SCORES_ON_TRIVIAL_REBASE, false));
            label.setCopyAllScoresIfNoCodeChange(rc.getBoolean(LABEL, name, KEY_COPY_ALL_SCORES_IF_NO_CHANGE, false));
            label.setCanOverride(rc.getBoolean(LABEL, name, KEY_CAN_OVERRIDE, true));
            label.setRefPatterns(this.getStringListOrNull(rc, LABEL, name, KEY_Branch));
            this.labelSections.put(name, label);
        }
    }

    private List<String> getStringListOrNull(Config rc, String section, String subSection, String name) {
        String[] ac = rc.getStringList(section, subSection, name);
        return ac.length == 0 ? null : Arrays.asList(ac);
    }

    private void loadCommentLinkSections(Config rc) {
        Set<String> subsections = rc.getSubsections(COMMENTLINK);
        this.commentLinkSections = Lists.newArrayListWithCapacity(subsections.size());
        for (String name : subsections) {
            try {
                this.commentLinkSections.add(ProjectConfig.buildCommentLink(rc, name, false));
            }
            catch (PatternSyntaxException e) {
                this.error(new ValidationError(PROJECT_CONFIG, String.format("Invalid pattern \"%s\" in commentlink.%s.match: %s", rc.getString(COMMENTLINK, name, KEY_MATCH), name, e.getMessage())));
            }
            catch (IllegalArgumentException e) {
                this.error(new ValidationError(PROJECT_CONFIG, String.format("Error in pattern \"%s\" in commentlink.%s.match: %s", rc.getString(COMMENTLINK, name, KEY_MATCH), name, e.getMessage())));
            }
        }
        this.commentLinkSections = ImmutableList.copyOf(this.commentLinkSections);
    }

    private void loadReceiveSection(Config rc) {
        this.checkReceivedObjects = rc.getBoolean(RECEIVE, KEY_CHECK_RECEIVED_OBJECTS, true);
        this.maxObjectSizeLimit = rc.getLong(RECEIVE, null, KEY_MAX_OBJECT_SIZE_LIMIT, 0L);
    }

    private void loadPluginSections(Config rc) {
        this.pluginConfigs = Maps.newHashMap();
        for (String plugin : rc.getSubsections(PLUGIN)) {
            Config pluginConfig = new Config();
            this.pluginConfigs.put(plugin, pluginConfig);
            for (String name : rc.getNames(PLUGIN, plugin)) {
                pluginConfig.setStringList(PLUGIN, plugin, name, Arrays.asList(rc.getStringList(PLUGIN, plugin, name)));
            }
        }
    }

    public PluginConfig getPluginConfig(String pluginName) {
        Config pluginConfig = this.pluginConfigs.get(pluginName);
        if (pluginConfig == null) {
            pluginConfig = new Config();
            this.pluginConfigs.put(pluginName, pluginConfig);
        }
        return new PluginConfig(pluginName, pluginConfig, this);
    }

    private Map<String, GroupReference> readGroupList() throws IOException {
        String s;
        this.groupsByUUID = new HashMap<AccountGroup.UUID, GroupReference>();
        HashMap<String, GroupReference> groupsByName = new HashMap<String, GroupReference>();
        BufferedReader br = new BufferedReader(new StringReader(this.readUTF8(GROUP_LIST)));
        int lineNumber = 1;
        while ((s = br.readLine()) != null) {
            if (!s.isEmpty() && !s.startsWith("#")) {
                int tab = s.indexOf(9);
                if (tab < 0) {
                    this.error(new ValidationError(GROUP_LIST, lineNumber, "missing tab delimiter"));
                } else {
                    AccountGroup.UUID uuid = new AccountGroup.UUID(s.substring(0, tab).trim());
                    String name = s.substring(tab + 1).trim();
                    GroupReference ref = new GroupReference(uuid, name);
                    this.groupsByUUID.put(uuid, ref);
                    groupsByName.put(name, ref);
                }
            }
            ++lineNumber;
        }
        return groupsByName;
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
        if (commit.getMessage() == null || "".equals(commit.getMessage())) {
            commit.setMessage("Updated project configuration\n");
        }
        Config rc = this.readConfig(PROJECT_CONFIG);
        Project p = this.project;
        if (p.getDescription() != null && !p.getDescription().isEmpty()) {
            rc.setString(PROJECT, null, KEY_DESCRIPTION, p.getDescription());
        } else {
            rc.unset(PROJECT, null, KEY_DESCRIPTION);
        }
        ProjectConfig.set(rc, ACCESS, null, KEY_INHERIT_FROM, p.getParentName());
        ProjectConfig.set(rc, RECEIVE, null, KEY_REQUIRE_CONTRIBUTOR_AGREEMENT, p.getUseContributorAgreements(), Project.InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, RECEIVE, null, KEY_REQUIRE_SIGNED_OFF_BY, p.getUseSignedOffBy(), Project.InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, RECEIVE, null, KEY_REQUIRE_CHANGE_ID, p.getRequireChangeID(), Project.InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, RECEIVE, null, KEY_MAX_OBJECT_SIZE_LIMIT, ProjectConfig.validMaxObjectSizeLimit(p.getMaxObjectSizeLimit()));
        ProjectConfig.set(rc, SUBMIT, null, KEY_ACTION, p.getSubmitType(), defaultSubmitAction);
        ProjectConfig.set(rc, SUBMIT, null, KEY_MERGE_CONTENT, p.getUseContentMerge(), Project.InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, PROJECT, null, KEY_STATE, p.getState(), defaultStateValue);
        ProjectConfig.set(rc, DASHBOARD, null, KEY_DEFAULT, p.getDefaultDashboard());
        ProjectConfig.set(rc, DASHBOARD, null, KEY_LOCAL_DEFAULT, p.getLocalDefaultDashboard());
        HashSet<AccountGroup.UUID> keepGroups = new HashSet<AccountGroup.UUID>();
        this.saveAccountsSection(rc, keepGroups);
        this.saveContributorAgreements(rc, keepGroups);
        this.saveAccessSections(rc, keepGroups);
        this.saveNotifySections(rc, keepGroups);
        this.groupsByUUID.keySet().retainAll(keepGroups);
        this.saveLabelSections(rc);
        this.savePluginSections(rc);
        this.saveConfig(PROJECT_CONFIG, rc);
        this.saveGroupList();
        return true;
    }

    public static final String validMaxObjectSizeLimit(String value) throws ConfigInvalidException {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        Config cfg = new Config();
        cfg.fromText("[s]\nn=" + value);
        try {
            long s = cfg.getLong("s", "n", 0L);
            if (s < 0L) {
                throw new ConfigInvalidException(String.format("Negative value '%s' not allowed as %s", value, KEY_MAX_OBJECT_SIZE_LIMIT));
            }
            if (s == 0L) {
                return null;
            }
            return value;
        }
        catch (IllegalArgumentException e) {
            throw new ConfigInvalidException(String.format("Value '%s' not parseable as a Long", value), e);
        }
    }

    private void saveAccountsSection(Config rc, Set<AccountGroup.UUID> keepGroups) {
        if (this.accountsSection != null) {
            rc.setStringList(ACCOUNTS, null, KEY_SAME_GROUP_VISIBILITY, this.ruleToStringList(this.accountsSection.getSameGroupVisibility(), keepGroups));
        }
    }

    private void saveContributorAgreements(Config rc, Set<AccountGroup.UUID> keepGroups) {
        for (ContributorAgreement ca : ProjectConfig.sort(this.contributorAgreements.values())) {
            ProjectConfig.set(rc, CONTRIBUTOR_AGREEMENT, ca.getName(), KEY_DESCRIPTION, ca.getDescription());
            ProjectConfig.set(rc, CONTRIBUTOR_AGREEMENT, ca.getName(), KEY_REQUIRE_CONTACT_INFORMATION, ca.isRequireContactInformation());
            ProjectConfig.set(rc, CONTRIBUTOR_AGREEMENT, ca.getName(), KEY_AGREEMENT_URL, ca.getAgreementUrl());
            if (ca.getAutoVerify() != null) {
                if (ca.getAutoVerify().getUUID() != null) {
                    keepGroups.add(ca.getAutoVerify().getUUID());
                }
                String autoVerify = new PermissionRule(ca.getAutoVerify()).asString(false);
                ProjectConfig.set(rc, CONTRIBUTOR_AGREEMENT, ca.getName(), KEY_AUTO_VERIFY, autoVerify);
            } else {
                rc.unset(CONTRIBUTOR_AGREEMENT, ca.getName(), KEY_AUTO_VERIFY);
            }
            rc.setStringList(CONTRIBUTOR_AGREEMENT, ca.getName(), KEY_ACCEPTED, this.ruleToStringList(ca.getAccepted(), keepGroups));
        }
    }

    private void saveNotifySections(Config rc, Set<AccountGroup.UUID> keepGroups) {
        for (NotifyConfig nc : ProjectConfig.sort(this.notifySections.values())) {
            ArrayList<String> email = Lists.newArrayList();
            for (GroupReference gr : nc.getGroups()) {
                if (gr.getUUID() != null) {
                    keepGroups.add(gr.getUUID());
                }
                email.add(new PermissionRule(gr).asString(false));
            }
            Collections.sort(email);
            ArrayList<String> addrs = Lists.newArrayList();
            for (Address addr : nc.getAddresses()) {
                addrs.add(addr.toString());
            }
            Collections.sort(addrs);
            email.addAll(addrs);
            ProjectConfig.set(rc, NOTIFY, nc.getName(), KEY_HEADER, nc.getHeader(), NotifyConfig.Header.BCC);
            if (email.isEmpty()) {
                rc.unset(NOTIFY, nc.getName(), KEY_EMAIL);
            } else {
                rc.setStringList(NOTIFY, nc.getName(), KEY_EMAIL, email);
            }
            if (nc.getNotify().equals(EnumSet.of(AccountProjectWatch.NotifyType.ALL))) {
                rc.unset(NOTIFY, nc.getName(), KEY_TYPE);
            } else {
                ArrayList<String> types = Lists.newArrayListWithCapacity(4);
                for (AccountProjectWatch.NotifyType t : AccountProjectWatch.NotifyType.values()) {
                    if (!nc.isNotify(t)) continue;
                    types.add(StringUtils.toLowerCase(t.name()));
                }
                rc.setStringList(NOTIFY, nc.getName(), KEY_TYPE, types);
            }
            ProjectConfig.set(rc, NOTIFY, nc.getName(), KEY_FILTER, nc.getFilter());
        }
    }

    private List<String> ruleToStringList(List<PermissionRule> list, Set<AccountGroup.UUID> keepGroups) {
        ArrayList<String> rules = new ArrayList<String>();
        for (PermissionRule rule : ProjectConfig.sort(list)) {
            if (rule.getGroup().getUUID() != null) {
                keepGroups.add(rule.getGroup().getUUID());
            }
            rules.add(rule.asString(false));
        }
        return rules;
    }

    private void saveAccessSections(Config rc, Set<AccountGroup.UUID> keepGroups) {
        AccessSection capability = this.accessSections.get("GLOBAL_CAPABILITIES");
        if (capability != null) {
            HashSet<String> have = new HashSet<String>();
            for (Permission permission : ProjectConfig.sort(capability.getPermissions())) {
                have.add(permission.getName().toLowerCase());
                boolean needRange = GlobalCapability.hasRange(permission.getName());
                ArrayList<String> rules = new ArrayList<String>();
                for (PermissionRule rule : ProjectConfig.sort(permission.getRules())) {
                    GroupReference group = rule.getGroup();
                    if (group.getUUID() != null) {
                        keepGroups.add(group.getUUID());
                    }
                    rules.add(rule.asString(needRange));
                }
                rc.setStringList(CAPABILITY, null, permission.getName(), rules);
            }
            for (String varName : rc.getNames(CAPABILITY)) {
                if (have.contains(varName.toLowerCase())) continue;
                rc.unset(CAPABILITY, null, varName);
            }
        } else {
            rc.unsetSection(CAPABILITY, null);
        }
        for (AccessSection as : ProjectConfig.sort(this.accessSections.values())) {
            String refName = as.getName();
            if ("GLOBAL_CAPABILITIES".equals(refName)) continue;
            StringBuilder doNotInherit = new StringBuilder();
            for (Permission perm : ProjectConfig.sort(as.getPermissions())) {
                if (!perm.getExclusiveGroup().booleanValue()) continue;
                if (0 < doNotInherit.length()) {
                    doNotInherit.append(' ');
                }
                doNotInherit.append(perm.getName());
            }
            if (0 < doNotInherit.length()) {
                rc.setString(ACCESS, refName, KEY_GROUP_PERMISSIONS, doNotInherit.toString());
            } else {
                rc.unset(ACCESS, refName, KEY_GROUP_PERMISSIONS);
            }
            HashSet<String> have = new HashSet<String>();
            for (Permission permission : ProjectConfig.sort(as.getPermissions())) {
                have.add(permission.getName().toLowerCase());
                boolean needRange = Permission.hasRange(permission.getName());
                ArrayList<String> rules = new ArrayList<String>();
                for (PermissionRule rule : ProjectConfig.sort(permission.getRules())) {
                    GroupReference group = rule.getGroup();
                    if (group.getUUID() != null) {
                        keepGroups.add(group.getUUID());
                    }
                    rules.add(rule.asString(needRange));
                }
                rc.setStringList(ACCESS, refName, permission.getName(), rules);
            }
            for (String varName : rc.getNames(ACCESS, refName)) {
                if (!Permission.isPermission(varName) || have.contains(varName.toLowerCase())) continue;
                rc.unset(ACCESS, refName, varName);
            }
        }
        for (String name : rc.getSubsections(ACCESS)) {
            if (!RefConfigSection.isValid(name) || this.accessSections.containsKey(name)) continue;
            rc.unsetSection(ACCESS, name);
        }
    }

    private void saveLabelSections(Config rc) {
        ArrayList<String> existing = Lists.newArrayList(rc.getSubsections(LABEL));
        if (!Lists.newArrayList(this.labelSections.keySet()).equals(existing)) {
            for (String name : existing) {
                rc.unsetSection(LABEL, name);
            }
        }
        HashSet<String> toUnset = Sets.newHashSet(existing);
        for (Map.Entry<String, LabelType> e : this.labelSections.entrySet()) {
            String name = e.getKey();
            LabelType label = e.getValue();
            toUnset.remove(name);
            rc.setString(LABEL, name, KEY_FUNCTION, label.getFunctionName());
            if (!LabelType.defaultAbbreviation(name).equals(label.getAbbreviation())) {
                rc.setString(LABEL, name, KEY_ABBREVIATION, label.getAbbreviation());
            } else {
                rc.unset(LABEL, name, KEY_ABBREVIATION);
            }
            if (label.isCopyMinScore()) {
                rc.setBoolean(LABEL, name, KEY_COPY_MIN_SCORE, true);
            } else {
                rc.unset(LABEL, name, KEY_COPY_MIN_SCORE);
            }
            if (label.isCopyMaxScore()) {
                rc.setBoolean(LABEL, name, KEY_COPY_MAX_SCORE, true);
            } else {
                rc.unset(LABEL, name, KEY_COPY_MAX_SCORE);
            }
            if (label.isCopyAllScoresOnTrivialRebase()) {
                rc.setBoolean(LABEL, name, KEY_COPY_ALL_SCORES_ON_TRIVIAL_REBASE, true);
            } else {
                rc.unset(LABEL, name, KEY_COPY_ALL_SCORES_ON_TRIVIAL_REBASE);
            }
            if (label.isCopyAllScoresIfNoCodeChange()) {
                rc.setBoolean(LABEL, name, KEY_COPY_ALL_SCORES_IF_NO_CHANGE, true);
            } else {
                rc.unset(LABEL, name, KEY_COPY_ALL_SCORES_IF_NO_CHANGE);
            }
            if (!label.canOverride()) {
                rc.setBoolean(LABEL, name, KEY_CAN_OVERRIDE, false);
            } else {
                rc.unset(LABEL, name, KEY_CAN_OVERRIDE);
            }
            ArrayList<String> values = Lists.newArrayListWithCapacity(label.getValues().size());
            for (LabelValue value : label.getValues()) {
                values.add(value.format());
            }
            rc.setStringList(LABEL, name, KEY_VALUE, values);
        }
        for (String name : toUnset) {
            rc.unsetSection(LABEL, name);
        }
    }

    private void savePluginSections(Config rc) {
        ArrayList<String> existing = Lists.newArrayList(rc.getSubsections(PLUGIN));
        for (String string : existing) {
            rc.unsetSection(PLUGIN, string);
        }
        for (Map.Entry entry : this.pluginConfigs.entrySet()) {
            String plugin = (String)entry.getKey();
            Config pluginConfig = (Config)entry.getValue();
            for (String name : pluginConfig.getNames(PLUGIN, plugin)) {
                rc.setStringList(PLUGIN, plugin, name, Arrays.asList(pluginConfig.getStringList(PLUGIN, plugin, name)));
            }
        }
    }

    private void saveGroupList() throws IOException {
        if (this.groupsByUUID.isEmpty()) {
            this.saveFile(GROUP_LIST, null);
            return;
        }
        int uuidLen = 40;
        StringBuilder buf = new StringBuilder();
        buf.append(ProjectConfig.pad(40, "# UUID"));
        buf.append('\t');
        buf.append("Group Name");
        buf.append('\n');
        buf.append('#');
        buf.append('\n');
        for (GroupReference g : ProjectConfig.sort(this.groupsByUUID.values())) {
            if (g.getUUID() == null || g.getName() == null) continue;
            buf.append(ProjectConfig.pad(40, g.getUUID().get()));
            buf.append('\t');
            buf.append(g.getName());
            buf.append('\n');
        }
        this.saveUTF8(GROUP_LIST, buf.toString());
    }

    private <E extends Enum<?>> E getEnum(Config rc, String section, String subsection, String name, E defaultValue) {
        try {
            return rc.getEnum(section, subsection, name, defaultValue);
        }
        catch (IllegalArgumentException err) {
            this.error(new ValidationError(PROJECT_CONFIG, err.getMessage()));
            return defaultValue;
        }
    }

    private void error(ValidationError error) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>(4);
        }
        this.validationErrors.add(error);
    }

    private static String pad(int len, String src) {
        if (len <= src.length()) {
            return src;
        }
        StringBuilder r = new StringBuilder(len);
        r.append(src);
        while (r.length() < len) {
            r.append(' ');
        }
        return r.toString();
    }

    private static <T extends Comparable<? super T>> List<T> sort(Collection<T> m) {
        ArrayList<T> r = new ArrayList<T>(m);
        Collections.sort(r);
        return r;
    }
}

