/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.Iterables;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.gerrit.server.project.ProjectState;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;

public class ProjectLevelConfig
extends VersionedMetaData {
    private final String fileName;
    private final ProjectState project;
    private Config cfg;

    public ProjectLevelConfig(String fileName, ProjectState project) {
        this.fileName = fileName;
        this.project = project;
    }

    @Override
    protected String getRefName() {
        return "refs/meta/config";
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        this.cfg = this.readConfig(this.fileName);
    }

    public Config get() {
        if (this.cfg == null) {
            this.cfg = new Config();
        }
        return this.cfg;
    }

    public Config getWithInheritance() {
        Config cfgWithInheritance = new Config();
        try {
            cfgWithInheritance.fromText(this.get().toText());
        }
        catch (ConfigInvalidException configInvalidException) {
            // empty catch block
        }
        ProjectState parent = Iterables.getFirst(this.project.parents(), null);
        if (parent != null) {
            Config parentCfg = parent.getConfig(this.fileName).getWithInheritance();
            for (String section : parentCfg.getSections()) {
                Set<String> allNames = this.get().getNames(section);
                for (String name : parentCfg.getNames(section)) {
                    if (allNames.contains(name)) continue;
                    cfgWithInheritance.setStringList(section, null, name, Arrays.asList(parentCfg.getStringList(section, null, name)));
                }
                for (String subsection : parentCfg.getSubsections(section)) {
                    allNames = this.get().getNames(section, subsection);
                    for (String name : parentCfg.getNames(section, subsection)) {
                        if (allNames.contains(name)) continue;
                        cfgWithInheritance.setStringList(section, subsection, name, Arrays.asList(parentCfg.getStringList(section, subsection, name)));
                    }
                }
            }
        }
        return cfgWithInheritance;
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
        if (commit.getMessage() == null || "".equals(commit.getMessage())) {
            commit.setMessage("Updated configuration\n");
        }
        this.saveConfig(this.fileName, this.cfg);
        return true;
    }
}

