/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gerrit.common.ChangeHookRunner;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.client.SubmoduleSubscription;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalCopier;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.MergeabilityChecker;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.events.CommitReceivedEvent;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.BanCommit;
import com.google.gerrit.server.git.ChangeCache;
import com.google.gerrit.server.git.ChangeUpdateExecutor;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.InsertException;
import com.google.gerrit.server.git.MergeQueue;
import com.google.gerrit.server.git.MultiProgressMonitor;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.ReceiveCommitsAdvertiseRefsHook;
import com.google.gerrit.server.git.ReceiveConfig;
import com.google.gerrit.server.git.SubmoduleException;
import com.google.gerrit.server.git.SubmoduleOp;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.ValidationError;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.git.validators.CommitValidationException;
import com.google.gerrit.server.git.validators.CommitValidationMessage;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.mail.CreateChangeSender;
import com.google.gerrit.server.mail.MailUtil;
import com.google.gerrit.server.mail.MergedSender;
import com.google.gerrit.server.mail.ReplacePatchSetSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gerrit.server.util.MagicBranch;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gerrit.util.cli.CmdLineParser;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.AdvertiseRefsHookChain;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveCommits {
    private static final Logger log = LoggerFactory.getLogger(ReceiveCommits.class);
    public static final Pattern NEW_PATCHSET = Pattern.compile("^refs/changes/(?:[0-9][0-9]/)?([1-9][0-9]*)(?:/new)?$");
    private static final FooterKey CHANGE_ID = new FooterKey("Change-Id");
    private static final String COMMAND_REJECTION_MESSAGE_FOOTER = "Please read the documentation and contact an administrator\nif you feel the configuration is incorrect";
    private static final Function<Exception, InsertException> INSERT_EXCEPTION = new Function<Exception, InsertException>(){

        @Override
        public InsertException apply(Exception input) {
            if (input instanceof OrmException) {
                return new InsertException("ORM error", input);
            }
            if (input instanceof IOException) {
                return new InsertException("IO error", input);
            }
            return new InsertException("Error inserting change/patchset", input);
        }
    };
    private Set<Account.Id> reviewersFromCommandLine = Sets.newLinkedHashSet();
    private Set<Account.Id> ccFromCommandLine = Sets.newLinkedHashSet();
    private final IdentifiedUser currentUser;
    private final ReviewDb db;
    private final ChangeData.Factory changeDataFactory;
    private final ChangeUpdate.Factory updateFactory;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final AccountResolver accountResolver;
    private final CmdLineParser.Factory optionParserFactory;
    private final CreateChangeSender.Factory createChangeSenderFactory;
    private final MergedSender.Factory mergedSenderFactory;
    private final ReplacePatchSetSender.Factory replacePatchSetFactory;
    private final GitReferenceUpdated gitRefUpdated;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final ChangeHooks hooks;
    private final ApprovalsUtil approvalsUtil;
    private final ApprovalCopier approvalCopier;
    private final GitRepositoryManager repoManager;
    private final ProjectCache projectCache;
    private final String canonicalWebUrl;
    private final CommitValidators.Factory commitValidatorsFactory;
    private final TagCache tagCache;
    private final AccountCache accountCache;
    private final ChangesCollection changes;
    private final ChangeInserter.Factory changeInserterFactory;
    private final WorkQueue workQueue;
    private final ListeningExecutorService changeUpdateExector;
    private final RequestScopePropagator requestScopePropagator;
    private final ChangeIndexer indexer;
    private final MergeabilityChecker mergeabilityChecker;
    private final SshInfo sshInfo;
    private final AllProjectsName allProjectsName;
    private final ReceiveConfig receiveConfig;
    private final ProjectControl projectControl;
    private final Project project;
    private final LabelTypes labelTypes;
    private final Repository repo;
    private final ReceivePack rp;
    private final NoteMap rejectCommits;
    private MagicBranchInput magicBranch;
    private List<CreateRequest> newChanges = Collections.emptyList();
    private final Map<Change.Id, ReplaceRequest> replaceByChange = new HashMap<Change.Id, ReplaceRequest>();
    private final Map<RevCommit, ReplaceRequest> replaceByCommit = new HashMap<RevCommit, ReplaceRequest>();
    private final Set<RevCommit> validCommits = new HashSet<RevCommit>();
    private ListMultimap<Change.Id, Ref> refsByChange;
    private SetMultimap<ObjectId, Ref> refsById;
    private Map<String, Ref> allRefs;
    private final SubmoduleOp.Factory subOpFactory;
    private final Provider<Submit> submitProvider;
    private final MergeQueue mergeQueue;
    private final DynamicMap<ProjectConfigEntry> pluginConfigEntries;
    private final List<CommitValidationMessage> messages = new ArrayList<CommitValidationMessage>();
    private ListMultimap<Error, String> errors = LinkedListMultimap.create();
    private MultiProgressMonitor.Task newProgress;
    private MultiProgressMonitor.Task replaceProgress;
    private MultiProgressMonitor.Task closeProgress;
    private MultiProgressMonitor.Task commandProgress;
    private MessageSender messageSender;
    private BatchRefUpdate batch;

    @Inject
    ReceiveCommits(ReviewDb db, SchemaFactory<ReviewDb> schemaFactory, ChangeData.Factory changeDataFactory, ChangeUpdate.Factory updateFactory, AccountResolver accountResolver, CmdLineParser.Factory optionParserFactory, CreateChangeSender.Factory createChangeSenderFactory, MergedSender.Factory mergedSenderFactory, ReplacePatchSetSender.Factory replacePatchSetFactory, GitReferenceUpdated gitRefUpdated, PatchSetInfoFactory patchSetInfoFactory, ChangeHooks hooks, ApprovalsUtil approvalsUtil, ApprovalCopier approvalCopier, ProjectCache projectCache, GitRepositoryManager repoManager, TagCache tagCache, AccountCache accountCache, ChangeCache changeCache, ChangesCollection changes, ChangeInserter.Factory changeInserterFactory, CommitValidators.Factory commitValidatorsFactory, @CanonicalWebUrl String canonicalWebUrl, @GerritPersonIdent PersonIdent gerritIdent, WorkQueue workQueue, @ChangeUpdateExecutor ListeningExecutorService changeUpdateExector, RequestScopePropagator requestScopePropagator, ChangeIndexer indexer, MergeabilityChecker mergeabilityChecker, SshInfo sshInfo, AllProjectsName allProjectsName, ReceiveConfig config, @Assisted ProjectControl projectControl, @Assisted Repository repo, SubmoduleOp.Factory subOpFactory, Provider<Submit> submitProvider, MergeQueue mergeQueue, DynamicMap<ProjectConfigEntry> pluginConfigEntries) throws IOException {
        this.currentUser = (IdentifiedUser)projectControl.getCurrentUser();
        this.db = db;
        this.changeDataFactory = changeDataFactory;
        this.updateFactory = updateFactory;
        this.schemaFactory = schemaFactory;
        this.accountResolver = accountResolver;
        this.optionParserFactory = optionParserFactory;
        this.createChangeSenderFactory = createChangeSenderFactory;
        this.mergedSenderFactory = mergedSenderFactory;
        this.replacePatchSetFactory = replacePatchSetFactory;
        this.gitRefUpdated = gitRefUpdated;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.hooks = hooks;
        this.approvalsUtil = approvalsUtil;
        this.approvalCopier = approvalCopier;
        this.projectCache = projectCache;
        this.repoManager = repoManager;
        this.canonicalWebUrl = canonicalWebUrl;
        this.tagCache = tagCache;
        this.accountCache = accountCache;
        this.changes = changes;
        this.changeInserterFactory = changeInserterFactory;
        this.commitValidatorsFactory = commitValidatorsFactory;
        this.workQueue = workQueue;
        this.changeUpdateExector = changeUpdateExector;
        this.requestScopePropagator = requestScopePropagator;
        this.indexer = indexer;
        this.mergeabilityChecker = mergeabilityChecker;
        this.sshInfo = sshInfo;
        this.allProjectsName = allProjectsName;
        this.receiveConfig = config;
        this.projectControl = projectControl;
        this.labelTypes = projectControl.getLabelTypes();
        this.project = projectControl.getProject();
        this.repo = repo;
        this.rp = new ReceivePack(repo);
        this.rejectCommits = BanCommit.loadRejectCommitsMap(repo);
        this.subOpFactory = subOpFactory;
        this.submitProvider = submitProvider;
        this.mergeQueue = mergeQueue;
        this.pluginConfigEntries = pluginConfigEntries;
        this.messageSender = new ReceivePackMessageSender();
        ProjectState ps = projectControl.getProjectState();
        this.rp.setAllowCreates(true);
        this.rp.setAllowDeletes(true);
        this.rp.setAllowNonFastForwards(true);
        this.rp.setCheckReceivedObjects(ps.getConfig().getCheckReceivedObjects());
        this.rp.setRefFilter(new RefFilter(){

            @Override
            public Map<String, Ref> filter(Map<String, Ref> refs) {
                HashMap<String, Ref> filteredRefs = Maps.newHashMapWithExpectedSize(refs.size());
                for (Map.Entry<String, Ref> e : refs.entrySet()) {
                    String name = e.getKey();
                    if (name.startsWith("refs/changes/") || name.startsWith("refs/cache-automerge/")) continue;
                    filteredRefs.put(name, e.getValue());
                }
                return filteredRefs;
            }
        });
        if (!projectControl.allRefsAreVisible()) {
            this.rp.setCheckReferencedObjectsAreReachable(config.checkReferencedObjectsAreReachable);
            this.rp.setAdvertiseRefsHook(new VisibleRefFilter(tagCache, changeCache, repo, projectControl, db, false));
        }
        ArrayList<AdvertiseRefsHook> advHooks = new ArrayList<AdvertiseRefsHook>(3);
        advHooks.add(new AdvertiseRefsHook(){

            @Override
            public void advertiseRefs(BaseReceivePack rp) throws ServiceMayNotContinueException {
                ReceiveCommits.this.allRefs = rp.getAdvertisedRefs();
                if (ReceiveCommits.this.allRefs == null) {
                    try {
                        ReceiveCommits.this.allRefs = rp.getRepository().getRefDatabase().getRefs("");
                    }
                    catch (ServiceMayNotContinueException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        ServiceMayNotContinueException ex = new ServiceMayNotContinueException();
                        ex.initCause(e);
                        throw ex;
                    }
                }
                rp.setAdvertisedRefs(ReceiveCommits.this.allRefs, rp.getAdvertisedObjects());
            }

            @Override
            public void advertiseRefs(UploadPack uploadPack) {
            }
        });
        advHooks.add(this.rp.getAdvertiseRefsHook());
        advHooks.add(new ReceiveCommitsAdvertiseRefsHook(db, projectControl.getProject().getNameKey()));
        this.rp.setAdvertiseRefsHook(AdvertiseRefsHookChain.newChain(advHooks));
    }

    public void addReviewers(Collection<Account.Id> who) {
        this.reviewersFromCommandLine.addAll(who);
    }

    public void addExtraCC(Collection<Account.Id> who) {
        this.ccFromCommandLine.addAll(who);
    }

    public void setMessageSender(MessageSender ms) {
        this.messageSender = ms != null ? ms : new ReceivePackMessageSender();
    }

    MessageSender getMessageSender() {
        if (this.messageSender == null) {
            this.setMessageSender(null);
        }
        return this.messageSender;
    }

    Project getProject() {
        return this.project;
    }

    public ReceivePack getReceivePack() {
        return this.rp;
    }

    public Capable canUpload() {
        Capable result = this.projectControl.canPushToAtLeastOneRef();
        if (result != Capable.OK) {
            return result;
        }
        if (this.receiveConfig.checkMagicRefs) {
            result = MagicBranch.checkMagicBranchRefs(this.repo, this.project);
        }
        return result;
    }

    private void addMessage(String message) {
        this.messages.add(new CommitValidationMessage(message, false));
    }

    void addError(String error) {
        this.messages.add(new CommitValidationMessage(error, true));
    }

    void sendMessages() {
        for (CommitValidationMessage m : this.messages) {
            if (m.isError()) {
                this.messageSender.sendError(m.getMessage());
                continue;
            }
            this.messageSender.sendMessage(m.getMessage());
        }
    }

    void processCommands(Collection<ReceiveCommand> commands, MultiProgressMonitor progress) {
        Iterable<ReplaceRequest> updated;
        this.newProgress = progress.beginSubTask("new", 0);
        this.replaceProgress = progress.beginSubTask("updated", 0);
        this.closeProgress = progress.beginSubTask("closed", 0);
        this.commandProgress = progress.beginSubTask("refs", 0);
        this.batch = this.repo.getRefDatabase().newBatchUpdate();
        this.batch.setRefLogIdent(this.rp.getRefLogIdent());
        this.batch.setRefLogMessage("push", true);
        this.parseCommands(commands);
        if (this.magicBranch != null && this.magicBranch.cmd.getResult() == ReceiveCommand.Result.NOT_ATTEMPTED) {
            this.newChanges = this.selectNewChanges();
        }
        this.preparePatchSetsForReplace();
        if (!this.batch.getCommands().isEmpty()) {
            try {
                this.batch.execute(this.rp.getRevWalk(), this.commandProgress);
            }
            catch (IOException err) {
                int cnt = 0;
                for (ReceiveCommand cmd : this.batch.getCommands()) {
                    if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "internal server error");
                    ++cnt;
                }
                log.error(String.format("Failed to store %d refs in %s", cnt, this.project.getName()), err);
            }
        }
        this.insertChangesAndPatchSets();
        this.newProgress.end();
        this.replaceProgress.end();
        if (!this.errors.isEmpty()) {
            for (Error error : this.errors.keySet()) {
                this.rp.sendMessage(this.buildError(error, this.errors.get(error)));
            }
            this.rp.sendMessage(String.format("User: %s", ReceiveCommits.displayName(this.currentUser)));
            this.rp.sendMessage(COMMAND_REJECTION_MESSAGE_FOOTER);
        }
        for (ReceiveCommand c : commands) {
            if (c.getResult() != ReceiveCommand.Result.OK) continue;
            switch (c.getType()) {
                case CREATE: {
                    if (!ReceiveCommits.isHead(c) && !ReceiveCommits.isConfig(c)) break;
                    this.autoCloseChanges(c);
                    break;
                }
                case UPDATE: {
                    this.tagCache.updateFastForward(this.project.getNameKey(), c.getRefName(), c.getOldId(), c.getNewId());
                    if (!ReceiveCommits.isHead(c) && !ReceiveCommits.isConfig(c)) break;
                    this.autoCloseChanges(c);
                    break;
                }
                case UPDATE_NONFASTFORWARD: {
                    if (!ReceiveCommits.isHead(c) && !ReceiveCommits.isConfig(c)) break;
                    this.autoCloseChanges(c);
                    break;
                }
                case DELETE: {
                    ResultSet<SubmoduleSubscription> submoduleSubscriptions = null;
                    Branch.NameKey projRef = new Branch.NameKey(this.project.getNameKey(), c.getRefName());
                    try {
                        submoduleSubscriptions = this.db.submoduleSubscriptions().bySuperProject(projRef);
                        this.db.submoduleSubscriptions().delete(submoduleSubscriptions);
                        break;
                    }
                    catch (OrmException e) {
                        log.error("Cannot delete submodule subscription(s) of branch " + projRef + ": " + submoduleSubscriptions, e);
                    }
                }
            }
            if (ReceiveCommits.isConfig(c)) {
                this.projectCache.evict(this.project);
                ProjectState ps = this.projectCache.get(this.project.getNameKey());
                this.repoManager.setProjectDescription(this.project.getNameKey(), ps.getProject().getDescription());
            }
            if (MagicBranch.isMagicBranch(c.getRefName())) continue;
            this.gitRefUpdated.fire(this.project.getNameKey(), c.getRefName(), c.getOldId(), c.getNewId());
            this.hooks.doRefUpdatedHook(new Branch.NameKey(this.project.getNameKey(), c.getRefName()), c.getOldId(), c.getNewId(), this.currentUser.getAccount());
        }
        this.closeProgress.end();
        this.commandProgress.end();
        progress.end();
        Iterable<CreateRequest> created = Iterables.filter(this.newChanges, new Predicate<CreateRequest>(){

            @Override
            public boolean apply(CreateRequest input) {
                return input.created;
            }
        });
        if (!Iterables.isEmpty(created)) {
            this.addMessage("");
            this.addMessage("New Changes:");
            for (CreateRequest c : created) {
                this.addMessage(ReceiveCommits.formatChangeUrl(this.canonicalWebUrl, c.change));
            }
            this.addMessage("");
        }
        if (!Iterables.isEmpty(updated = Iterables.filter(this.replaceByChange.values(), new Predicate<ReplaceRequest>(){

            @Override
            public boolean apply(ReplaceRequest input) {
                return !input.skip && input.inputCommand.getResult() == ReceiveCommand.Result.OK;
            }
        }))) {
            this.addMessage("");
            this.addMessage("Updated Changes:");
            for (ReplaceRequest u : updated) {
                this.addMessage(ReceiveCommits.formatChangeUrl(this.canonicalWebUrl, u.change));
            }
            this.addMessage("");
        }
    }

    private static String formatChangeUrl(String url, Change change) {
        StringBuilder m = new StringBuilder().append("  ").append(url).append(change.getChangeId());
        if (change.getStatus() == Change.Status.DRAFT) {
            m.append(" [DRAFT]");
        }
        return m.toString();
    }

    private void insertChangesAndPatchSets() {
        int replaceCount = 0;
        int okToInsert = 0;
        for (Map.Entry<Change.Id, ReplaceRequest> e : this.replaceByChange.entrySet()) {
            ReplaceRequest replace = e.getValue();
            if (this.magicBranch != null && replace.inputCommand == this.magicBranch.cmd) {
                ++replaceCount;
                if (replace.cmd == null || replace.cmd.getResult() != ReceiveCommand.Result.OK) continue;
                ++okToInsert;
                continue;
            }
            if (replace.cmd != null && replace.cmd.getResult() == ReceiveCommand.Result.OK) {
                try {
                    if (replace.insertPatchSet().checkedGet() == null) continue;
                    replace.inputCommand.setResult(ReceiveCommand.Result.OK);
                }
                catch (IOException iOException) {
                    this.reject(replace.inputCommand, "internal server error");
                    log.error(String.format("Cannot add patch set to %d of %s", e.getKey().get(), this.project.getName()), iOException);
                }
                catch (InsertException insertException) {
                    this.reject(replace.inputCommand, "internal server error");
                    log.error(String.format("Cannot add patch set to %d of %s", e.getKey().get(), this.project.getName()), insertException);
                }
                continue;
            }
            if (replace.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            this.reject(replace.inputCommand, "internal server error");
        }
        if (this.magicBranch == null || this.magicBranch.cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
            return;
        }
        ArrayList<String> lastCreateChangeErrors = Lists.newArrayList();
        for (CreateRequest create : this.newChanges) {
            if (create.cmd.getResult() == ReceiveCommand.Result.OK) {
                ++okToInsert;
                continue;
            }
            String string = String.format("%s %s", new Object[]{create.cmd.getResult(), Strings.nullToEmpty(create.cmd.getMessage())}).trim();
            lastCreateChangeErrors.add(string);
            log.error(String.format("Command %s on %s:%s not completed: %s", new Object[]{create.cmd.getType(), this.project.getName(), create.cmd.getRefName(), string}));
        }
        if (okToInsert != replaceCount + this.newChanges.size()) {
            this.reject(this.magicBranch.cmd, "Unable to create changes: " + Joiner.on(' ').join(lastCreateChangeErrors));
            log.error(String.format("Only %d of %d new change refs created in %s; aborting", okToInsert, replaceCount + this.newChanges.size(), this.project.getName()));
            return;
        }
        try {
            ArrayList<CheckedFuture<Object, InsertException>> futures = Lists.newArrayList();
            for (ReplaceRequest replaceRequest : this.replaceByChange.values()) {
                if (this.magicBranch == null || replaceRequest.inputCommand != this.magicBranch.cmd) continue;
                futures.add(replaceRequest.insertPatchSet());
            }
            for (CreateRequest createRequest : this.newChanges) {
                futures.add(createRequest.insertChange());
            }
            for (CheckedFuture checkedFuture : futures) {
                checkedFuture.checkedGet();
            }
            this.magicBranch.cmd.setResult(ReceiveCommand.Result.OK);
        }
        catch (InsertException err) {
            log.error("Can't insert change/patchset for " + this.project.getName(), err);
            this.reject(this.magicBranch.cmd, "internal server error");
        }
        catch (IOException err) {
            log.error("Can't read commits for " + this.project.getName(), err);
            this.reject(this.magicBranch.cmd, "internal server error");
        }
    }

    private String buildError(Error error, List<String> branches) {
        StringBuilder sb = new StringBuilder();
        if (branches.size() == 1) {
            sb.append("Branch ").append(branches.get(0)).append(":\n");
            sb.append(error.get());
            return sb.toString();
        }
        sb.append("Branches");
        String delim = " ";
        for (String branch : branches) {
            sb.append(delim).append(branch);
            delim = ", ";
        }
        return sb.append(":\n").append(error.get()).toString();
    }

    private static String displayName(IdentifiedUser user) {
        String displayName = user.getUserName();
        if (displayName == null) {
            displayName = user.getAccount().getPreferredEmail();
        }
        return displayName;
    }

    private void parseCommands(Collection<ReceiveCommand> commands) {
        block12: for (ReceiveCommand cmd : commands) {
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            if (!Repository.isValidRefName(cmd.getRefName()) || cmd.getRefName().contains("//")) {
                this.reject(cmd, "not valid ref");
                continue;
            }
            ChangeHookRunner.HookResult result = this.hooks.doRefUpdateHook(this.project, cmd.getRefName(), this.currentUser.getAccount(), cmd.getOldId(), cmd.getNewId());
            if (result != null) {
                String message = result.toString().trim();
                if (result.getExitValue() != 0) {
                    this.reject(cmd, message);
                    continue;
                }
                this.rp.sendMessage(message);
            }
            if (MagicBranch.isMagicBranch(cmd.getRefName())) {
                this.parseMagicBranch(cmd);
                continue;
            }
            Matcher m = NEW_PATCHSET.matcher(cmd.getRefName());
            if (m.matches()) {
                Change.Id changeId = Change.Id.parse(m.group(1));
                this.parseReplaceCommand(cmd, changeId);
                continue;
            }
            switch (cmd.getType()) {
                case CREATE: {
                    this.parseCreate(cmd);
                    break;
                }
                case UPDATE: {
                    this.parseUpdate(cmd);
                    break;
                }
                case DELETE: {
                    this.parseDelete(cmd);
                    break;
                }
                case UPDATE_NONFASTFORWARD: {
                    this.parseRewind(cmd);
                    break;
                }
                default: {
                    this.reject(cmd);
                    continue block12;
                }
            }
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED || !ReceiveCommits.isConfig(cmd)) continue;
            if (!this.projectControl.isOwner()) {
                this.reject(cmd, "not project owner");
                continue;
            }
            switch (cmd.getType()) {
                case CREATE: 
                case UPDATE: 
                case UPDATE_NONFASTFORWARD: {
                    try {
                        ProjectConfig cfg = new ProjectConfig(this.project.getNameKey());
                        cfg.load(this.repo, cmd.getNewId());
                        if (!cfg.getValidationErrors().isEmpty()) {
                            this.addError("Invalid project configuration:");
                            for (ValidationError err : cfg.getValidationErrors()) {
                                this.addError("  " + err.getMessage());
                            }
                            this.reject(cmd, "invalid project configuration");
                            log.error("User " + this.currentUser.getUserName() + " tried to push invalid project configuration " + cmd.getNewId().name() + " for " + this.project.getName());
                            continue block12;
                        }
                        Project.NameKey newParent = cfg.getProject().getParent(this.allProjectsName);
                        Project.NameKey oldParent = this.project.getParent(this.allProjectsName);
                        if (oldParent == null) {
                            if (newParent != null) {
                                this.reject(cmd, "invalid project configuration: root project cannot have parent");
                                continue block12;
                            }
                        } else {
                            if (!oldParent.equals(newParent) && !this.currentUser.getCapabilities().canAdministrateServer()) {
                                this.reject(cmd, "invalid project configuration: only Gerrit admin can set parent");
                                continue block12;
                            }
                            if (this.projectCache.get(newParent) == null) {
                                this.reject(cmd, "invalid project configuration: parent does not exist");
                                continue block12;
                            }
                        }
                        for (DynamicMap.Entry<ProjectConfigEntry> entry : this.pluginConfigEntries) {
                            PluginConfig pluginCfg = cfg.getPluginConfig(entry.getPluginName());
                            ProjectConfigEntry configEntry = entry.getProvider().get();
                            String value = pluginCfg.getString(entry.getExportName());
                            String oldValue = this.projectControl.getProjectState().getConfig().getPluginConfig(entry.getPluginName()).getString(entry.getExportName());
                            if (configEntry.getType() == ProjectConfigEntry.Type.ARRAY) {
                                List<String> l = Arrays.asList(this.projectControl.getProjectState().getConfig().getPluginConfig(entry.getPluginName()).getStringList(entry.getExportName()));
                                oldValue = Joiner.on("\n").join(l);
                            }
                            if ((value == null ? oldValue != null : !value.equals(oldValue)) && !configEntry.isEditable(this.projectControl.getProjectState())) {
                                this.reject(cmd, String.format("invalid project configuration: Not allowed to set parameter '%s' of plugin '%s' on project '%s'.", entry.getExportName(), entry.getPluginName(), this.project.getName()));
                                continue;
                            }
                            if (!ProjectConfigEntry.Type.LIST.equals((Object)configEntry.getType()) || value == null || configEntry.getPermittedValues().contains(value)) continue;
                            this.reject(cmd, String.format("invalid project configuration: The value '%s' is not permitted for parameter '%s' of plugin '%s'.", value, entry.getExportName(), entry.getPluginName()));
                        }
                        continue block12;
                    }
                    catch (Exception e) {
                        this.reject(cmd, "invalid project configuration");
                        log.error("User " + this.currentUser.getUserName() + " tried to push invalid project configuration " + cmd.getNewId().name() + " for " + this.project.getName(), e);
                        continue block12;
                    }
                }
                case DELETE: {
                    break;
                }
                default: {
                    this.reject(cmd);
                    continue block12;
                }
            }
        }
    }

    private void parseCreate(ReceiveCommand cmd) {
        RevObject obj;
        try {
            obj = this.rp.getRevWalk().parseAny(cmd.getNewId());
        }
        catch (IOException err) {
            log.error("Invalid object " + cmd.getNewId().name() + " for " + cmd.getRefName() + " creation", err);
            this.reject(cmd, "invalid object");
            return;
        }
        if (ReceiveCommits.isHead(cmd) && !this.isCommit(cmd)) {
            return;
        }
        RefControl ctl = this.projectControl.controlForRef(cmd.getRefName());
        if (ctl.canCreate(this.rp.getRevWalk(), obj, this.allRefs.values().contains(obj))) {
            this.validateNewCommits(ctl, cmd);
            this.batch.addCommand(cmd);
        } else {
            this.reject(cmd);
        }
    }

    private void parseUpdate(ReceiveCommand cmd) {
        RefControl ctl = this.projectControl.controlForRef(cmd.getRefName());
        if (ctl.canUpdate()) {
            if (ReceiveCommits.isHead(cmd) && !this.isCommit(cmd)) {
                return;
            }
            this.validateNewCommits(ctl, cmd);
            this.batch.addCommand(cmd);
        } else {
            if ("refs/meta/config".equals(ctl.getRefName())) {
                this.errors.put(Error.CONFIG_UPDATE, "refs/meta/config");
            } else {
                this.errors.put(Error.UPDATE, ctl.getRefName());
            }
            this.reject(cmd);
        }
    }

    private boolean isCommit(ReceiveCommand cmd) {
        RevObject obj;
        try {
            obj = this.rp.getRevWalk().parseAny(cmd.getNewId());
        }
        catch (IOException err) {
            log.error("Invalid object " + cmd.getNewId().name() + " for " + cmd.getRefName(), err);
            this.reject(cmd, "invalid object");
            return false;
        }
        if (obj instanceof RevCommit) {
            return true;
        }
        this.reject(cmd, "not a commit");
        return false;
    }

    private void parseDelete(ReceiveCommand cmd) {
        RefControl ctl = this.projectControl.controlForRef(cmd.getRefName());
        if (ctl.getRefName().startsWith("refs/changes/")) {
            this.errors.put(Error.DELETE_CHANGES, ctl.getRefName());
            this.reject(cmd, "cannot delete changes");
        } else if (ctl.canDelete()) {
            this.batch.addCommand(cmd);
        } else if ("refs/meta/config".equals(ctl.getRefName())) {
            this.reject(cmd, "cannot delete project configuration");
        } else {
            this.errors.put(Error.DELETE, ctl.getRefName());
            this.reject(cmd, "cannot delete references");
        }
    }

    private void parseRewind(ReceiveCommand cmd) {
        RevCommit newObject;
        try {
            newObject = this.rp.getRevWalk().parseCommit(cmd.getNewId());
        }
        catch (IncorrectObjectTypeException notCommit) {
            newObject = null;
        }
        catch (IOException err) {
            log.error("Invalid object " + cmd.getNewId().name() + " for " + cmd.getRefName() + " forced update", err);
            this.reject(cmd, "invalid object");
            return;
        }
        RefControl ctl = this.projectControl.controlForRef(cmd.getRefName());
        if (newObject != null) {
            this.validateNewCommits(ctl, cmd);
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
                return;
            }
        }
        if (ctl.canForceUpdate()) {
            this.batch.setAllowNonFastForwards(true).addCommand(cmd);
        } else {
            cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD, " need 'Force Push' privilege.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMagicBranch(ReceiveCommand cmd) {
        String ref;
        if (this.magicBranch != null) {
            this.reject(cmd, "duplicate request");
            return;
        }
        this.magicBranch = new MagicBranchInput(cmd);
        this.magicBranch.reviewer.addAll(this.reviewersFromCommandLine);
        this.magicBranch.cc.addAll(this.ccFromCommandLine);
        CmdLineParser clp = this.optionParserFactory.create(this.magicBranch);
        try {
            ref = this.magicBranch.parse(clp, this.repo, this.rp.getAdvertisedRefs().keySet());
        }
        catch (CmdLineException e) {
            if (!clp.wasHelpRequestedByOption()) {
                this.reject(cmd, e.getMessage());
                return;
            }
            ref = null;
        }
        if (clp.wasHelpRequestedByOption()) {
            StringWriter w = new StringWriter();
            w.write("\nHelp for refs/for/branch:\n\n");
            clp.printUsage(w, null);
            this.addMessage(w.toString());
            this.reject(cmd, "see help");
            return;
        }
        if (!this.rp.getAdvertisedRefs().containsKey(ref) && !ref.equals(ReceiveCommits.readHEAD(this.repo))) {
            if (ref.startsWith("refs/heads/")) {
                String n = ref.substring("refs/heads/".length());
                this.reject(cmd, "branch " + n + " not found");
            } else {
                this.reject(cmd, ref + " not found");
            }
            return;
        }
        this.magicBranch.dest = new Branch.NameKey(this.project.getNameKey(), ref);
        this.magicBranch.ctl = this.projectControl.controlForRef(ref);
        if (!this.magicBranch.ctl.canWrite()) {
            this.reject(cmd, "project is read only");
            return;
        }
        if (this.magicBranch.isDraft() && (!this.receiveConfig.allowDrafts || this.projectControl.controlForRef("refs/drafts/" + ref).isBlocked("push"))) {
            this.errors.put(Error.CODE_REVIEW, ref);
            this.reject(cmd, "cannot upload drafts");
            return;
        }
        if (!this.magicBranch.ctl.canUpload()) {
            this.errors.put(Error.CODE_REVIEW, ref);
            this.reject(cmd, "cannot upload review");
            return;
        }
        if (this.magicBranch.isDraft() && this.magicBranch.isSubmit()) {
            this.reject(cmd, "cannot submit draft");
            return;
        }
        if (this.magicBranch.isSubmit() && !this.projectControl.controlForRef("refs/for/" + ref).canSubmit()) {
            this.reject(cmd, "submit not allowed");
        }
        RevWalk walk = this.rp.getRevWalk();
        if (this.magicBranch.base != null) {
            this.magicBranch.baseCommit = Lists.newArrayListWithCapacity(this.magicBranch.base.size());
            for (ObjectId id : this.magicBranch.base) {
                try {
                    this.magicBranch.baseCommit.add(walk.parseCommit(id));
                }
                catch (IncorrectObjectTypeException notCommit) {
                    this.reject(cmd, "base must be a commit");
                    return;
                }
                catch (MissingObjectException e) {
                    this.reject(cmd, "base not found");
                    return;
                }
                catch (IOException e) {
                    log.warn(String.format("Project %s cannot read %s", this.project.getName(), id.name()), e);
                    this.reject(cmd, "internal server error");
                    return;
                }
            }
        }
        try {
            RevCommit tip = walk.parseCommit(this.magicBranch.cmd.getNewId());
            Ref targetRef = this.rp.getAdvertisedRefs().get(this.magicBranch.ctl.getRefName());
            if (targetRef == null || targetRef.getObjectId() == null) {
                return;
            }
            RevCommit h = walk.parseCommit(targetRef.getObjectId());
            RevFilter oldRevFilter = walk.getRevFilter();
            try {
                walk.reset();
                walk.setRevFilter(RevFilter.MERGE_BASE);
                walk.markStart(tip);
                walk.markStart(h);
                if (walk.next() == null) {
                    this.reject(this.magicBranch.cmd, "no common ancestry");
                }
            }
            finally {
                walk.reset();
                walk.setRevFilter(oldRevFilter);
            }
        }
        catch (IOException e) {
            this.magicBranch.cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
            log.error("Invalid pack upload; one or more objects weren't sent", e);
        }
    }

    private static String readHEAD(Repository repo) {
        try {
            return repo.getFullBranch();
        }
        catch (IOException e) {
            log.error("Cannot read HEAD symref", e);
            return null;
        }
    }

    private void parseReplaceCommand(ReceiveCommand cmd, Change.Id changeId) {
        Change changeEnt;
        RevCommit newCommit;
        if (cmd.getType() != ReceiveCommand.Type.CREATE) {
            this.reject(cmd, "invalid usage");
            return;
        }
        try {
            newCommit = this.rp.getRevWalk().parseCommit(cmd.getNewId());
        }
        catch (IOException e) {
            log.error("Cannot parse " + cmd.getNewId().name() + " as commit", e);
            this.reject(cmd, "invalid commit");
            return;
        }
        try {
            changeEnt = this.db.changes().get(changeId);
        }
        catch (OrmException e) {
            log.error("Cannot lookup existing change " + changeId, e);
            this.reject(cmd, "database error");
            return;
        }
        if (changeEnt == null) {
            this.reject(cmd, "change " + changeId + " not found");
            return;
        }
        if (!this.project.getNameKey().equals(changeEnt.getProject())) {
            this.reject(cmd, "change " + changeId + " does not belong to project " + this.project.getName());
            return;
        }
        this.requestReplace(cmd, true, changeEnt, newCommit);
    }

    private boolean requestReplace(ReceiveCommand cmd, boolean checkMergedInto, Change change, RevCommit newCommit) {
        if (change.getStatus().isClosed()) {
            this.reject(cmd, "change " + change.getId() + " closed");
            return false;
        }
        ReplaceRequest req = new ReplaceRequest(change.getId(), newCommit, cmd, checkMergedInto);
        if (this.replaceByChange.containsKey(req.ontoChange)) {
            this.reject(cmd, "duplicate request");
            return false;
        }
        if (this.replaceByCommit.containsKey(req.newCommit)) {
            this.reject(cmd, "duplicate request");
            return false;
        }
        this.replaceByChange.put(req.ontoChange, req);
        this.replaceByCommit.put(req.newCommit, req);
        return true;
    }

    private List<CreateRequest> selectNewChanges() {
        ArrayList<CreateRequest> newChanges = Lists.newArrayList();
        RevWalk walk = this.rp.getRevWalk();
        walk.reset();
        walk.sort(RevSort.TOPO);
        walk.sort(RevSort.REVERSE, true);
        try {
            RevCommit c;
            HashSet<ObjectId> existing = Sets.newHashSet();
            walk.markStart(walk.parseCommit(this.magicBranch.cmd.getNewId()));
            if (this.magicBranch.baseCommit != null) {
                for (RevCommit c2 : this.magicBranch.baseCommit) {
                    walk.markUninteresting(c2);
                }
                assert (this.magicBranch.ctl != null);
                Ref targetRef = this.allRefs.get(this.magicBranch.ctl.getRefName());
                if (targetRef != null) {
                    walk.markUninteresting(walk.parseCommit(targetRef.getObjectId()));
                }
            } else {
                this.markHeadsAsUninteresting(walk, existing, this.magicBranch.ctl != null ? this.magicBranch.ctl.getRefName() : null);
            }
            ArrayList<ChangeLookup> pending = Lists.newArrayList();
            HashSet<Change.Key> newChangeIds = new HashSet<Change.Key>();
            while ((c = walk.next()) != null) {
                if (existing.contains(c) || this.replaceByCommit.containsKey(c)) continue;
                if (!this.validCommit(this.magicBranch.ctl, this.magicBranch.cmd, c)) {
                    return Collections.emptyList();
                }
                Change.Key changeKey = new Change.Key("I" + c.name());
                List<String> idList = c.getFooterLines(CHANGE_ID);
                if (idList.isEmpty()) {
                    newChanges.add(new CreateRequest(this.magicBranch.ctl, c, changeKey));
                    continue;
                }
                String idStr = idList.get(idList.size() - 1).trim();
                if (idStr.matches("^I00*$")) {
                    this.reject(this.magicBranch.cmd, "invalid Change-Id");
                    return Collections.emptyList();
                }
                changeKey = new Change.Key(idStr);
                pending.add(new ChangeLookup(c, changeKey));
            }
            for (ChangeLookup p : pending) {
                if (newChangeIds.contains(p.changeKey)) {
                    this.reject(this.magicBranch.cmd, "squash commits first");
                    return Collections.emptyList();
                }
                List<Change> changes = p.changes.toList();
                if (changes.size() > 1) {
                    this.reject(this.magicBranch.cmd, p.changeKey.get() + " has duplicates");
                    return Collections.emptyList();
                }
                if (changes.size() == 1) {
                    if (this.requestReplace(this.magicBranch.cmd, false, changes.get(0), p.commit)) continue;
                    return Collections.emptyList();
                }
                if (changes.size() == 0) {
                    if (!ReceiveCommits.isValidChangeId(p.changeKey.get())) {
                        this.reject(this.magicBranch.cmd, "invalid Change-Id");
                        return Collections.emptyList();
                    }
                    newChangeIds.add(p.changeKey);
                }
                newChanges.add(new CreateRequest(this.magicBranch.ctl, p.commit, p.changeKey));
            }
        }
        catch (IOException e) {
            this.magicBranch.cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
            log.error("Invalid pack upload; one or more objects weren't sent", e);
            return Collections.emptyList();
        }
        catch (OrmException e) {
            log.error("Cannot query database to locate prior changes", e);
            this.reject(this.magicBranch.cmd, "database error");
            return Collections.emptyList();
        }
        if (newChanges.isEmpty() && this.replaceByChange.isEmpty()) {
            this.reject(this.magicBranch.cmd, "no new changes");
            return Collections.emptyList();
        }
        for (CreateRequest create : newChanges) {
            this.batch.addCommand(create.cmd);
        }
        return newChanges;
    }

    private void markHeadsAsUninteresting(RevWalk walk, Set<ObjectId> existing, @Nullable String forRef) {
        for (Ref ref : this.allRefs.values()) {
            if (ref.getObjectId() == null) continue;
            if (ref.getName().startsWith("refs/changes/")) {
                existing.add(ref.getObjectId());
                continue;
            }
            if (!ref.getName().startsWith("refs/heads/") && (forRef == null || !forRef.equals(ref.getName()))) continue;
            try {
                walk.markUninteresting(walk.parseCommit(ref.getObjectId()));
            }
            catch (IOException e) {
                log.warn(String.format("Invalid ref %s in %s", ref.getName(), this.project.getName()), e);
            }
        }
    }

    private static boolean isValidChangeId(String idStr) {
        return idStr.matches("^I[0-9a-fA-F]{40}$") && !idStr.matches("^I00*$");
    }

    private void submit(ChangeControl changeCtl, PatchSet ps) throws OrmException, IOException {
        Change c;
        Submit submit = this.submitProvider.get();
        RevisionResource rsrc = new RevisionResource(this.changes.parse(changeCtl), ps);
        try {
            c = submit.submit(rsrc, this.currentUser, true);
        }
        catch (ResourceConflictException e) {
            throw new IOException(e);
        }
        if (c == null) {
            this.addError("Submitting change " + changeCtl.getChange().getChangeId() + " failed.");
        } else {
            this.addMessage("");
            this.mergeQueue.merge(c.getDest());
            c = this.db.changes().get(c.getId());
            switch (c.getStatus()) {
                case SUBMITTED: {
                    this.addMessage("Change " + c.getChangeId() + " submitted.");
                    break;
                }
                case MERGED: {
                    this.addMessage("Change " + c.getChangeId() + " merged.");
                    break;
                }
                case NEW: {
                    ChangeMessage msg = submit.getConflictMessage(rsrc);
                    if (msg != null) {
                        this.addMessage("Change " + c.getChangeId() + ": " + msg.getMessage());
                        break;
                    }
                }
                default: {
                    this.addMessage("change " + c.getChangeId() + " is " + c.getStatus().name().toLowerCase());
                }
            }
        }
    }

    private void preparePatchSetsForReplace() {
        try {
            this.readChangesForReplace();
            Iterator<ReplaceRequest> itr = this.replaceByChange.values().iterator();
            while (itr.hasNext()) {
                ReplaceRequest replaceRequest = itr.next();
                if (replaceRequest.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                replaceRequest.validate(false);
                if (!replaceRequest.skip || replaceRequest.cmd != null) continue;
                itr.remove();
                this.replaceByCommit.remove(replaceRequest.newCommit);
            }
        }
        catch (OrmException err) {
            log.error("Cannot read database before replacement", err);
            for (ReplaceRequest req : this.replaceByChange.values()) {
                if (req.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                req.inputCommand.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "internal server error");
            }
        }
        catch (IOException err) {
            log.error("Cannot read repository before replacement", err);
            for (ReplaceRequest req : this.replaceByChange.values()) {
                if (req.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                req.inputCommand.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "internal server error");
            }
        }
        for (ReplaceRequest replaceRequest : this.replaceByChange.values()) {
            if (replaceRequest.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED || replaceRequest.cmd == null) continue;
            this.batch.addCommand(replaceRequest.cmd);
        }
        if (this.magicBranch != null && this.magicBranch.cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
            for (ReplaceRequest replaceRequest : this.replaceByChange.values()) {
                if (replaceRequest.inputCommand != this.magicBranch.cmd || replaceRequest.cmd == null) continue;
                replaceRequest.cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "aborted");
            }
            for (CreateRequest createRequest : this.newChanges) {
                createRequest.cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "aborted");
            }
        }
    }

    private void readChangesForReplace() throws OrmException {
        ArrayList futures = Lists.newArrayListWithCapacity(this.replaceByChange.size());
        for (ReplaceRequest replaceRequest : this.replaceByChange.values()) {
            futures.add(this.db.changes().getAsync(replaceRequest.ontoChange));
        }
        for (CheckedFuture checkedFuture : futures) {
            Change c = (Change)checkedFuture.checkedGet();
            if (c == null) continue;
            this.replaceByChange.get((Object)c.getId()).change = c;
        }
    }

    private List<Ref> refs(Change.Id changeId) {
        if (this.refsByChange == null) {
            int estRefsPerChange = 4;
            this.refsByChange = ArrayListMultimap.create(this.allRefs.size() / estRefsPerChange, estRefsPerChange);
            for (Ref ref : this.allRefs.values()) {
                if (ref.getObjectId() == null || !PatchSet.isRef(ref.getName())) continue;
                this.refsByChange.put(Change.Id.fromRef(ref.getName()), ref);
            }
        }
        return this.refsByChange.get(changeId);
    }

    static boolean parentsEqual(RevCommit a, RevCommit b) {
        if (a.getParentCount() != b.getParentCount()) {
            return false;
        }
        for (int i = 0; i < a.getParentCount(); ++i) {
            if (a.getParent(i) == b.getParent(i)) continue;
            return false;
        }
        return true;
    }

    static boolean authorEqual(RevCommit a, RevCommit b) {
        PersonIdent aAuthor = a.getAuthorIdent();
        PersonIdent bAuthor = b.getAuthorIdent();
        if (aAuthor == null && bAuthor == null) {
            return true;
        }
        if (aAuthor == null || bAuthor == null) {
            return false;
        }
        return ReceiveCommits.eq(aAuthor.getName(), bAuthor.getName()) && ReceiveCommits.eq(aAuthor.getEmailAddress(), bAuthor.getEmailAddress());
    }

    static boolean eq(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private Ref findMergedInto(String first, RevCommit commit) {
        try {
            Map<String, Ref> all = this.repo.getRefDatabase().getRefs("");
            Ref firstRef = all.get(first);
            if (firstRef != null && this.isMergedInto(commit, firstRef)) {
                return firstRef;
            }
            for (Ref ref : all.values()) {
                if (!ReceiveCommits.isHead(ref) || !this.isMergedInto(commit, ref)) continue;
                return ref;
            }
            return null;
        }
        catch (IOException e) {
            log.warn("Can't check for already submitted change", e);
            return null;
        }
    }

    private boolean isMergedInto(RevCommit commit, Ref ref) throws IOException {
        RevWalk rw = this.rp.getRevWalk();
        return rw.isMergedInto(commit, rw.parseCommit(ref.getObjectId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateNewCommits(RefControl ctl, ReceiveCommand cmd) {
        if (ctl.canForgeAuthor() && ctl.canForgeCommitter() && ctl.canForgeGerritServerIdentity() && ctl.canUploadMerges() && !this.projectControl.getProjectState().isUseSignedOffBy() && Iterables.isEmpty(this.rejectCommits) && !"refs/meta/config".equals(ctl.getRefName()) && !MagicBranch.isMagicBranch(cmd.getRefName()) && !NEW_PATCHSET.matcher(cmd.getRefName()).matches()) {
            return;
        }
        boolean defaultName = Strings.isNullOrEmpty(this.currentUser.getAccount().getFullName());
        RevWalk walk = this.rp.getRevWalk();
        walk.reset();
        walk.sort(RevSort.NONE);
        try {
            RevCommit c;
            HashSet<ObjectId> existing = Sets.newHashSet();
            walk.markStart(walk.parseCommit(cmd.getNewId()));
            this.markHeadsAsUninteresting(walk, existing, cmd.getRefName());
            while ((c = walk.next()) != null) {
                if (existing.contains(c)) continue;
                if (this.validCommit(ctl, cmd, c)) {
                    if (!defaultName || !this.currentUser.getEmailAddresses().contains(c.getCommitterIdent().getEmailAddress())) continue;
                    try {
                        Account a = this.db.accounts().get(this.currentUser.getAccountId());
                        if (a == null || !Strings.isNullOrEmpty(a.getFullName())) continue;
                        a.setFullName(c.getCommitterIdent().getName());
                        this.db.accounts().update(Collections.singleton(a));
                        this.currentUser.getAccount().setFullName(a.getFullName());
                        this.accountCache.evict(a.getId());
                        continue;
                    }
                    catch (OrmException e) {
                        log.warn("Cannot default full_name", e);
                        continue;
                    }
                    finally {
                        defaultName = false;
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException err) {
            cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
            log.error("Invalid pack upload; one or more objects weren't sent", err);
        }
    }

    private boolean validCommit(RefControl ctl, ReceiveCommand cmd, RevCommit c) throws MissingObjectException, IOException {
        if (this.validCommits.contains(c)) {
            return true;
        }
        CommitReceivedEvent receiveEvent = new CommitReceivedEvent(cmd, this.project, ctl.getRefName(), c, this.currentUser);
        CommitValidators commitValidators = this.commitValidatorsFactory.create(ctl, this.sshInfo, this.repo);
        try {
            this.messages.addAll(commitValidators.validateForReceiveCommits(receiveEvent));
        }
        catch (CommitValidationException e) {
            this.messages.addAll(e.getMessages());
            this.reject(cmd, e.getMessage());
            return false;
        }
        this.validCommits.add(c);
        return true;
    }

    private void autoCloseChanges(ReceiveCommand cmd) {
        RevWalk rw = this.rp.getRevWalk();
        try {
            RevCommit c;
            rw.reset();
            rw.markStart(rw.parseCommit(cmd.getNewId()));
            if (!ObjectId.zeroId().equals(cmd.getOldId())) {
                rw.markUninteresting(rw.parseCommit(cmd.getOldId()));
            }
            SetMultimap<ObjectId, Ref> byCommit = this.changeRefsById();
            Map<Change.Key, Change.Id> byKey = this.openChangesByKey(new Branch.NameKey(this.project.getNameKey(), cmd.getRefName()));
            ArrayList<ReplaceRequest> toClose = new ArrayList<ReplaceRequest>();
            block5: while ((c = rw.next()) != null) {
                Set<Ref> refs = byCommit.get(c.copy());
                for (Ref ref : refs) {
                    if (ref == null) continue;
                    rw.parseBody(c);
                    Change.Key closedChange = this.closeChange(cmd, PatchSet.Id.fromRef(ref.getName()), c);
                    this.closeProgress.update(1);
                    if (closedChange == null) continue;
                    byKey.remove(closedChange);
                }
                rw.parseBody(c);
                for (String changeId : c.getFooterLines(CHANGE_ID)) {
                    Change.Id onto = byKey.get(new Change.Key(changeId.trim()));
                    if (onto == null) continue;
                    ReplaceRequest req = new ReplaceRequest(onto, c, cmd, false);
                    req.change = this.db.changes().get(onto);
                    toClose.add(req);
                    continue block5;
                }
            }
            for (ReplaceRequest req : toClose) {
                PatchSet.Id psi = req.validate(true) ? req.insertPatchSet().checkedGet() : null;
                if (psi == null) continue;
                this.closeChange(req.inputCommand, psi, req.newCommit);
                this.closeProgress.update(1);
            }
            rw.reset();
            RevCommit codeReviewCommit = rw.parseCommit(cmd.getNewId());
            SubmoduleOp subOp = this.subOpFactory.create(new Branch.NameKey(this.project.getNameKey(), cmd.getRefName()), codeReviewCommit, rw, this.repo, this.project, new ArrayList<Change>(), new HashMap<Change.Id, CodeReviewCommit>(), this.currentUser.getAccount());
            subOp.update();
        }
        catch (InsertException e) {
            log.error("Can't insert patchset", e);
        }
        catch (IOException e) {
            log.error("Can't scan for changes to close", e);
        }
        catch (OrmException e) {
            log.error("Can't scan for changes to close", e);
        }
        catch (SubmoduleException e) {
            log.error("Can't complete git links check", e);
        }
    }

    private Change.Key closeChange(ReceiveCommand cmd, PatchSet.Id psi, RevCommit commit) throws OrmException, IOException {
        String refName = cmd.getRefName();
        Change.Id cid = psi.getParentKey();
        Change change = this.db.changes().get(cid);
        PatchSet ps = this.db.patchSets().get(psi);
        if (change == null || ps == null) {
            log.warn(this.project.getName() + " " + psi + " is missing");
            return null;
        }
        if (change.getStatus() == Change.Status.MERGED || change.getStatus() == Change.Status.ABANDONED || !change.getDest().get().equals(refName)) {
            return null;
        }
        ReplaceRequest result = new ReplaceRequest(cid, commit, cmd, false);
        result.change = change;
        result.changeCtl = this.projectControl.controlFor(change);
        result.newPatchSet = ps;
        result.info = this.patchSetInfoFactory.get(commit, psi);
        result.mergedIntoRef = refName;
        this.markChangeMergedByPush(this.db, result);
        this.hooks.doChangeMergedHook(change, this.currentUser.getAccount(), result.newPatchSet, this.db);
        this.sendMergedEmail(result);
        return change.getKey();
    }

    private SetMultimap<ObjectId, Ref> changeRefsById() throws IOException {
        if (this.refsById == null) {
            this.refsById = HashMultimap.create();
            for (Ref r : this.repo.getRefDatabase().getRefs("refs/changes/").values()) {
                if (!PatchSet.isRef(r.getName())) continue;
                this.refsById.put(r.getObjectId(), r);
            }
        }
        return this.refsById;
    }

    private Map<Change.Key, Change.Id> openChangesByKey(Branch.NameKey branch) throws OrmException {
        HashMap<Change.Key, Change.Id> r = new HashMap<Change.Key, Change.Id>();
        for (Change c : this.db.changes().byBranchOpenAll(branch)) {
            r.put(c.getKey(), c.getId());
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markChangeMergedByPush(ReviewDb db, final ReplaceRequest result) throws OrmException, IOException {
        Change change;
        Change.Id id = result.change.getId();
        db.changes().beginTransaction(id);
        try {
            change = db.changes().atomicUpdate(id, new AtomicUpdate<Change>(){

                @Override
                public Change update(Change change) {
                    if (change.getStatus().isOpen()) {
                        change.setCurrentPatchSet(result.info);
                        change.setStatus(Change.Status.MERGED);
                        ChangeUtil.updated(change);
                    }
                    return change;
                }
            });
            String mergedIntoRef = result.mergedIntoRef;
            StringBuilder msgBuf = new StringBuilder();
            msgBuf.append("Change has been successfully pushed");
            if (!mergedIntoRef.equals(change.getDest().get())) {
                msgBuf.append(" into ");
                if (mergedIntoRef.startsWith("refs/heads/")) {
                    msgBuf.append("branch ");
                    msgBuf.append(Repository.shortenRefName(mergedIntoRef));
                } else {
                    msgBuf.append(mergedIntoRef);
                }
            }
            msgBuf.append(".");
            ChangeMessage msg = new ChangeMessage(new ChangeMessage.Key(id, ChangeUtil.messageUUID(db)), this.currentUser.getAccountId(), change.getLastUpdatedOn(), result.info.getKey());
            msg.setMessage(msgBuf.toString());
            db.changeMessages().insert(Collections.singleton(msg));
            db.commit();
        }
        finally {
            db.rollback();
        }
        this.indexer.index(db, change);
    }

    private void sendMergedEmail(final ReplaceRequest result) {
        this.workQueue.getDefaultQueue().submit(this.requestScopePropagator.wrap(new Runnable(){

            @Override
            public void run() {
                try {
                    MergedSender cm = ReceiveCommits.this.mergedSenderFactory.create(result.changeCtl);
                    cm.setFrom(ReceiveCommits.this.currentUser.getAccountId());
                    cm.setPatchSet(result.newPatchSet, result.info);
                    cm.send();
                }
                catch (Exception e) {
                    PatchSet.Id psi = result.newPatchSet.getId();
                    log.error("Cannot send email for submitted patch set " + psi, e);
                }
            }

            public String toString() {
                return "send-email merged";
            }
        }));
    }

    private static RevId toRevId(RevCommit src) {
        return new RevId(src.getId().name());
    }

    private void reject(ReceiveCommand cmd) {
        this.reject(cmd, "prohibited by Gerrit");
    }

    private void reject(ReceiveCommand cmd, String why) {
        cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, why);
        this.commandProgress.update(1);
    }

    private static boolean isHead(Ref ref) {
        return ref.getName().startsWith("refs/heads/");
    }

    private static boolean isHead(ReceiveCommand cmd) {
        return cmd.getRefName().startsWith("refs/heads/");
    }

    private static boolean isConfig(ReceiveCommand cmd) {
        return cmd.getRefName().equals("refs/meta/config");
    }

    private class ReplaceRequest {
        final Change.Id ontoChange;
        final RevCommit newCommit;
        final ReceiveCommand inputCommand;
        final boolean checkMergedInto;
        Change change;
        ChangeControl changeCtl;
        BiMap<RevCommit, PatchSet.Id> revisions;
        PatchSet newPatchSet;
        ReceiveCommand cmd;
        PatchSetInfo info;
        ChangeMessage msg;
        String mergedIntoRef;
        boolean skip;
        private PatchSet.Id priorPatchSet;

        ReplaceRequest(Change.Id toChange, RevCommit newCommit, ReceiveCommand cmd, boolean checkMergedInto) {
            this.ontoChange = toChange;
            this.newCommit = newCommit;
            this.inputCommand = cmd;
            this.checkMergedInto = checkMergedInto;
            this.revisions = HashBiMap.create();
            for (Ref ref : ReceiveCommits.this.refs(toChange)) {
                try {
                    this.revisions.forcePut(ReceiveCommits.this.rp.getRevWalk().parseCommit(ref.getObjectId()), PatchSet.Id.fromRef(ref.getName()));
                }
                catch (IOException err) {
                    log.warn(String.format("Project %s contains invalid change ref %s", ReceiveCommits.this.project.getName(), ref.getName()), err);
                }
            }
        }

        boolean validate(boolean autoClose) throws IOException {
            if (!autoClose && this.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
                return false;
            }
            if (this.change == null) {
                ReceiveCommits.this.reject(this.inputCommand, "change " + this.ontoChange + " not found");
                return false;
            }
            this.priorPatchSet = this.change.currentPatchSetId();
            if (!this.revisions.containsValue(this.priorPatchSet)) {
                ReceiveCommits.this.reject(this.inputCommand, "change " + this.ontoChange + " missing revisions");
                return false;
            }
            RevCommit priorCommit = (RevCommit)this.revisions.inverse().get(this.priorPatchSet);
            if (this.newCommit == priorCommit) {
                this.skip = true;
                ReceiveCommits.this.reject(this.inputCommand, "commit already exists (as current patchset)");
                return false;
            }
            this.changeCtl = ReceiveCommits.this.projectControl.controlFor(this.change);
            if (!this.changeCtl.canAddPatchSet()) {
                ReceiveCommits.this.reject(this.inputCommand, "cannot replace " + this.ontoChange);
                return false;
            }
            if (this.change.getStatus().isClosed()) {
                ReceiveCommits.this.reject(this.inputCommand, "change " + this.ontoChange + " closed");
                return false;
            }
            if (this.revisions.containsKey(this.newCommit)) {
                ReceiveCommits.this.reject(this.inputCommand, "commit already exists (in the change)");
                return false;
            }
            for (Ref r : ReceiveCommits.this.rp.getRepository().getRefDatabase().getRefs("refs/changes").values()) {
                if (!r.getObjectId().equals(this.newCommit)) continue;
                ReceiveCommits.this.reject(this.inputCommand, "commit already exists (in the project)");
                return false;
            }
            for (RevCommit prior : this.revisions.keySet()) {
                if (!ReceiveCommits.this.rp.getRevWalk().isMergedInto(prior, this.newCommit)) continue;
                ReceiveCommits.this.reject(this.inputCommand, "squash commits first");
                return false;
            }
            ReceiveCommits.this.rp.getRevWalk().parseBody(this.newCommit);
            if (!ReceiveCommits.this.validCommit(this.changeCtl.getRefControl(), this.inputCommand, this.newCommit)) {
                return false;
            }
            ReceiveCommits.this.rp.getRevWalk().parseBody(priorCommit);
            if (this.newCommit.getTree() == priorCommit.getTree()) {
                boolean messageEq = ReceiveCommits.eq(this.newCommit.getFullMessage(), priorCommit.getFullMessage());
                boolean parentsEq = ReceiveCommits.parentsEqual(this.newCommit, priorCommit);
                boolean authorEq = ReceiveCommits.authorEqual(this.newCommit, priorCommit);
                ObjectReader reader = ReceiveCommits.this.rp.getRevWalk().getObjectReader();
                if (messageEq && parentsEq && authorEq && !autoClose) {
                    ReceiveCommits.this.addMessage(String.format("(W) No changes between prior commit %s and new commit %s", reader.abbreviate(priorCommit).name(), reader.abbreviate(this.newCommit).name()));
                    ReceiveCommits.this.reject(this.inputCommand, "no changes made");
                    return false;
                }
                StringBuilder msg = new StringBuilder();
                msg.append("(W) ");
                msg.append(reader.abbreviate(this.newCommit).name());
                msg.append(":");
                msg.append(" no files changed");
                if (!authorEq) {
                    msg.append(", author changed");
                }
                if (!messageEq) {
                    msg.append(", message updated");
                }
                if (!parentsEq) {
                    msg.append(", was rebased");
                }
                ReceiveCommits.this.addMessage(msg.toString());
            }
            PatchSet.Id id = ChangeUtil.nextPatchSetId(ReceiveCommits.this.allRefs, this.change.currentPatchSetId());
            this.newPatchSet = new PatchSet(id);
            this.newPatchSet.setCreatedOn(TimeUtil.nowTs());
            this.newPatchSet.setUploader(ReceiveCommits.this.currentUser.getAccountId());
            this.newPatchSet.setRevision(ReceiveCommits.toRevId(this.newCommit));
            if (ReceiveCommits.this.magicBranch != null && ReceiveCommits.this.magicBranch.isDraft()) {
                this.newPatchSet.setDraft(true);
            }
            this.info = ReceiveCommits.this.patchSetInfoFactory.get(this.newCommit, this.newPatchSet.getId());
            this.cmd = new ReceiveCommand(ObjectId.zeroId(), this.newCommit, this.newPatchSet.getRefName());
            return true;
        }

        CheckedFuture<PatchSet.Id, InsertException> insertPatchSet() throws IOException {
            ReceiveCommits.this.rp.getRevWalk().parseBody(this.newCommit);
            final Thread caller = Thread.currentThread();
            ListenableFuture<PatchSet.Id> future = ReceiveCommits.this.changeUpdateExector.submit(ReceiveCommits.this.requestScopePropagator.wrap(new Callable<PatchSet.Id>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public PatchSet.Id call() throws OrmException, IOException {
                    try {
                        PatchSet.Id id;
                        if (caller == Thread.currentThread()) {
                            PatchSet.Id id2 = ReplaceRequest.this.insertPatchSet(ReceiveCommits.this.db);
                            return id2;
                        }
                        ReviewDb db = (ReviewDb)ReceiveCommits.this.schemaFactory.open();
                        try {
                            id = ReplaceRequest.this.insertPatchSet(db);
                        }
                        catch (Throwable throwable) {
                            db.close();
                            throw throwable;
                        }
                        db.close();
                        return id;
                    }
                    finally {
                        MultiProgressMonitor.Task task = ReceiveCommits.this.replaceProgress;
                        synchronized (task) {
                            ReceiveCommits.this.replaceProgress.update(1);
                        }
                    }
                }
            }));
            return Futures.makeChecked(future, INSERT_EXCEPTION);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PatchSet.Id insertPatchSet(ReviewDb db) throws OrmException, IOException {
            final Account.Id me = ReceiveCommits.this.currentUser.getAccountId();
            List<FooterLine> footerLines = this.newCommit.getFooterLines();
            final MailUtil.MailRecipients recipients = new MailUtil.MailRecipients();
            if (ReceiveCommits.this.magicBranch != null) {
                recipients.add(ReceiveCommits.this.magicBranch.getMailRecipients());
            }
            recipients.add(MailUtil.getRecipientsFromFooters(ReceiveCommits.this.accountResolver, this.newPatchSet, footerLines));
            recipients.remove(me);
            ChangeUpdate update = ReceiveCommits.this.updateFactory.create(this.changeCtl, this.newPatchSet.getCreatedOn());
            db.changes().beginTransaction(this.change.getId());
            try {
                this.change = db.changes().get(this.change.getId());
                if (this.change == null || this.change.getStatus().isClosed()) {
                    ReceiveCommits.this.reject(this.inputCommand, "change is closed");
                    PatchSet.Id id = null;
                    return id;
                }
                ChangeUtil.insertAncestors(db, this.newPatchSet.getId(), this.newCommit);
                db.patchSets().insert(Collections.singleton(this.newPatchSet));
                if (this.checkMergedInto) {
                    Ref mergedInto = ReceiveCommits.this.findMergedInto(this.change.getDest().get(), this.newCommit);
                    this.mergedIntoRef = mergedInto != null ? mergedInto.getName() : null;
                }
                ChangeData cd = ReceiveCommits.this.changeDataFactory.create(db, this.changeCtl);
                MailUtil.MailRecipients oldRecipients = MailUtil.getRecipientsFromReviewers(cd.reviewers());
                ReceiveCommits.this.approvalCopier.copy(db, this.changeCtl, this.newPatchSet);
                ReceiveCommits.this.approvalsUtil.addReviewers(db, update, ReceiveCommits.this.labelTypes, this.change, this.newPatchSet, this.info, recipients.getReviewers(), oldRecipients.getAll());
                recipients.add(oldRecipients);
                this.msg = new ChangeMessage(new ChangeMessage.Key(this.change.getId(), ChangeUtil.messageUUID(db)), me, this.newPatchSet.getCreatedOn(), this.newPatchSet.getId());
                this.msg.setMessage("Uploaded patch set " + this.newPatchSet.getPatchSetId() + ".");
                db.changeMessages().insert(Collections.singleton(this.msg));
                if (this.mergedIntoRef == null) {
                    this.change = db.changes().atomicUpdate(this.change.getId(), new AtomicUpdate<Change>(){

                        @Override
                        public Change update(Change change) {
                            if (change.getStatus().isClosed()) {
                                return null;
                            }
                            if (!change.currentPatchSetId().equals(ReplaceRequest.this.priorPatchSet)) {
                                return change;
                            }
                            if (ReceiveCommits.this.magicBranch != null && ((ReceiveCommits)ReceiveCommits.this).magicBranch.topic != null) {
                                change.setTopic(((ReceiveCommits)ReceiveCommits.this).magicBranch.topic);
                            }
                            if (change.getStatus() != Change.Status.DRAFT || !ReplaceRequest.this.newPatchSet.isDraft()) {
                                change.setStatus(Change.Status.NEW);
                            }
                            change.setLastSha1MergeTested(null);
                            change.setCurrentPatchSet(ReplaceRequest.this.info);
                            List<String> idList = ReplaceRequest.this.newCommit.getFooterLines(CHANGE_ID);
                            if (idList.isEmpty()) {
                                change.setKey(new Change.Key("I" + ReplaceRequest.this.newCommit.name()));
                            } else {
                                change.setKey(new Change.Key(idList.get(idList.size() - 1).trim()));
                            }
                            ChangeUtil.updated(change);
                            return change;
                        }
                    });
                    if (this.change == null) {
                        db.patchSets().delete(Collections.singleton(this.newPatchSet));
                        db.changeMessages().delete(Collections.singleton(this.msg));
                        ReceiveCommits.this.reject(this.inputCommand, "change is closed");
                        PatchSet.Id id = null;
                        return id;
                    }
                }
                db.commit();
            }
            finally {
                db.rollback();
            }
            update.commit();
            if (this.mergedIntoRef != null) {
                ReceiveCommits.this.markChangeMergedByPush(db, this);
            }
            if (this.cmd.getResult() == ReceiveCommand.Result.NOT_ATTEMPTED) {
                this.cmd.execute(ReceiveCommits.this.rp);
            }
            CheckedFuture<?, IOException> f = ReceiveCommits.this.mergeabilityChecker.newCheck().addChange(this.change).reindex().runAsync();
            ReceiveCommits.this.workQueue.getDefaultQueue().submit(ReceiveCommits.this.requestScopePropagator.wrap(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReplacePatchSetSender cm = ReceiveCommits.this.replacePatchSetFactory.create(ReplaceRequest.this.change);
                        cm.setFrom(me);
                        cm.setPatchSet(ReplaceRequest.this.newPatchSet, ReplaceRequest.this.info);
                        cm.setChangeMessage(ReplaceRequest.this.msg);
                        cm.addReviewers(recipients.getReviewers());
                        cm.addExtraCC(recipients.getCcOnly());
                        cm.send();
                    }
                    catch (Exception e) {
                        log.error("Cannot send email for new patch set " + ReplaceRequest.this.newPatchSet.getId(), e);
                    }
                    if (ReplaceRequest.this.mergedIntoRef != null) {
                        ReceiveCommits.this.sendMergedEmail(ReplaceRequest.this);
                    }
                }

                public String toString() {
                    return "send-email newpatchset";
                }
            }));
            f.checkedGet();
            ReceiveCommits.this.gitRefUpdated.fire(ReceiveCommits.this.project.getNameKey(), this.newPatchSet.getRefName(), ObjectId.zeroId(), this.newCommit);
            ReceiveCommits.this.hooks.doPatchsetCreatedHook(this.change, this.newPatchSet, db);
            if (this.mergedIntoRef != null) {
                ReceiveCommits.this.hooks.doChangeMergedHook(this.change, ReceiveCommits.this.currentUser.getAccount(), this.newPatchSet, db);
            }
            if (ReceiveCommits.this.magicBranch != null && ReceiveCommits.this.magicBranch.isSubmit()) {
                ReceiveCommits.this.submit(this.changeCtl, this.newPatchSet);
            }
            return this.newPatchSet.getId();
        }
    }

    private class CreateRequest {
        final RevCommit commit;
        final Change change;
        final ReceiveCommand cmd;
        final ChangeInserter ins;
        boolean created;

        CreateRequest(RefControl ctl, RevCommit c, Change.Key changeKey) throws OrmException {
            this.commit = c;
            this.change = new Change(changeKey, new Change.Id(ReceiveCommits.this.db.nextChangeId()), ReceiveCommits.this.currentUser.getAccountId(), ((ReceiveCommits)ReceiveCommits.this).magicBranch.dest, TimeUtil.nowTs());
            this.change.setTopic(((ReceiveCommits)ReceiveCommits.this).magicBranch.topic);
            this.ins = ReceiveCommits.this.changeInserterFactory.create(ctl, this.change, c).setDraft(ReceiveCommits.this.magicBranch.isDraft());
            this.cmd = new ReceiveCommand(ObjectId.zeroId(), c, this.ins.getPatchSet().getRefName());
        }

        CheckedFuture<Void, InsertException> insertChange() throws IOException {
            ReceiveCommits.this.rp.getRevWalk().parseBody(this.commit);
            final Thread caller = Thread.currentThread();
            ListenableFuture<Void> future = ReceiveCommits.this.changeUpdateExector.submit(ReceiveCommits.this.requestScopePropagator.wrap(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws OrmException, IOException {
                    if (caller == Thread.currentThread()) {
                        CreateRequest.this.insertChange(ReceiveCommits.this.db);
                    } else {
                        try (ReviewDb db = (ReviewDb)ReceiveCommits.this.schemaFactory.open();){
                            CreateRequest.this.insertChange(db);
                        }
                    }
                    MultiProgressMonitor.Task task = ReceiveCommits.this.newProgress;
                    synchronized (task) {
                        ReceiveCommits.this.newProgress.update(1);
                    }
                    return null;
                }
            }));
            return Futures.makeChecked(future, INSERT_EXCEPTION);
        }

        private void insertChange(ReviewDb db) throws OrmException, IOException {
            final PatchSet ps = this.ins.getPatchSet();
            final Account.Id me = ReceiveCommits.this.currentUser.getAccountId();
            List<FooterLine> footerLines = this.commit.getFooterLines();
            final MailUtil.MailRecipients recipients = new MailUtil.MailRecipients();
            if (ReceiveCommits.this.magicBranch != null) {
                recipients.add(ReceiveCommits.this.magicBranch.getMailRecipients());
            }
            recipients.add(MailUtil.getRecipientsFromFooters(ReceiveCommits.this.accountResolver, ps, footerLines));
            recipients.remove(me);
            ChangeMessage msg = new ChangeMessage(new ChangeMessage.Key(this.change.getId(), ChangeUtil.messageUUID(db)), me, ps.getCreatedOn(), ps.getId());
            msg.setMessage("Uploaded patch set " + ps.getPatchSetId() + ".");
            this.ins.setReviewers(recipients.getReviewers()).setMessage(msg).setSendMail(false).insert();
            this.created = true;
            ReceiveCommits.this.workQueue.getDefaultQueue().submit(ReceiveCommits.this.requestScopePropagator.wrap(new Runnable(){

                @Override
                public void run() {
                    try {
                        CreateChangeSender cm = ReceiveCommits.this.createChangeSenderFactory.create(CreateRequest.this.change);
                        cm.setFrom(me);
                        cm.setPatchSet(ps, CreateRequest.this.ins.getPatchSetInfo());
                        cm.addReviewers(recipients.getReviewers());
                        cm.addExtraCC(recipients.getCcOnly());
                        cm.send();
                    }
                    catch (Exception e) {
                        log.error("Cannot send email for new change " + CreateRequest.this.change.getId(), e);
                    }
                }

                public String toString() {
                    return "send-email newchange";
                }
            }));
            if (ReceiveCommits.this.magicBranch != null && ReceiveCommits.this.magicBranch.isSubmit()) {
                ReceiveCommits.this.submit(ReceiveCommits.this.projectControl.controlFor(this.change), ps);
            }
        }
    }

    private class ChangeLookup {
        final RevCommit commit;
        final Change.Key changeKey;
        final ResultSet<Change> changes;

        ChangeLookup(RevCommit c, Change.Key key) throws OrmException {
            this.commit = c;
            this.changeKey = key;
            this.changes = ReceiveCommits.this.db.changes().byBranchKey(((ReceiveCommits)ReceiveCommits.this).magicBranch.dest, key);
        }
    }

    private static class MagicBranchInput {
        private static final Splitter COMMAS = Splitter.on(',').omitEmptyStrings();
        final ReceiveCommand cmd;
        Branch.NameKey dest;
        RefControl ctl;
        Set<Account.Id> reviewer = Sets.newLinkedHashSet();
        Set<Account.Id> cc = Sets.newLinkedHashSet();
        List<RevCommit> baseCommit;
        @Option(name="--base", metaVar="BASE", usage="merge base of changes")
        List<ObjectId> base;
        @Option(name="--topic", metaVar="NAME", usage="attach topic to changes")
        String topic;
        @Option(name="--draft", usage="mark new/updated changes as draft")
        boolean draft;
        @Option(name="--submit", usage="immediately submit the change")
        boolean submit;

        @Option(name="-r", metaVar="EMAIL", usage="add reviewer to changes")
        void reviewer(Account.Id id) {
            this.reviewer.add(id);
        }

        @Option(name="--cc", metaVar="EMAIL", usage="notify user by CC")
        void cc(Account.Id id) {
            this.cc.add(id);
        }

        @Option(name="--publish", usage="publish new/updated changes")
        void publish(boolean publish) {
            this.draft = !publish;
        }

        MagicBranchInput(ReceiveCommand cmd) {
            this.cmd = cmd;
            this.draft = cmd.getRefName().startsWith("refs/drafts/");
        }

        boolean isDraft() {
            return this.draft;
        }

        boolean isSubmit() {
            return this.submit;
        }

        MailUtil.MailRecipients getMailRecipients() {
            return new MailUtil.MailRecipients(this.reviewer, this.cc);
        }

        String parse(CmdLineParser clp, Repository repo, Set<String> refs) throws CmdLineException {
            String name;
            int optionStart;
            String ref = MagicBranch.getDestBranchName(this.cmd.getRefName());
            if (!ref.startsWith("refs/")) {
                ref = "refs/heads/" + ref;
            }
            if (0 < (optionStart = ref.indexOf(37))) {
                LinkedListMultimap<String, String> options = LinkedListMultimap.create();
                for (String s : COMMAS.split(ref.substring(optionStart + 1))) {
                    int e = s.indexOf(61);
                    if (0 < e) {
                        options.put(s.substring(0, e), s.substring(e + 1));
                        continue;
                    }
                    options.put(s, "");
                }
                clp.parseOptionMap(options);
                ref = ref.substring(0, optionStart);
            }
            String head = ReceiveCommits.readHEAD(repo);
            int split = ref.length();
            while (!refs.contains(name = ref.substring(0, split)) && !name.equals(head)) {
                if ((split = name.lastIndexOf(47, split - 1)) > "refs/".length()) continue;
                return ref;
            }
            if (split < ref.length()) {
                this.topic = Strings.emptyToNull(ref.substring(split + 1));
            }
            return ref.substring(0, split);
        }
    }

    private class ReceivePackMessageSender
    implements MessageSender {
        private ReceivePackMessageSender() {
        }

        @Override
        public void sendMessage(String what) {
            ReceiveCommits.this.rp.sendMessage(what);
        }

        @Override
        public void sendError(String what) {
            ReceiveCommits.this.rp.sendError(what);
        }

        @Override
        public void sendBytes(byte[] what) {
            this.sendBytes(what, 0, what.length);
        }

        @Override
        public void sendBytes(byte[] what, int off, int len) {
            try {
                ReceiveCommits.this.rp.getMessageOutputStream().write(what, off, len);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void flush() {
            try {
                ReceiveCommits.this.rp.getMessageOutputStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface MessageSender {
        public void sendMessage(String var1);

        public void sendError(String var1);

        public void sendBytes(byte[] var1);

        public void sendBytes(byte[] var1, int var2, int var3);

        public void flush();
    }

    static interface Factory {
        public ReceiveCommits create(ProjectControl var1, Repository var2);
    }

    private static enum Error {
        CONFIG_UPDATE("You are not allowed to perform this operation.\nConfiguration changes can only be pushed by project owners\nwho also have 'Push' rights on refs/meta/config"),
        UPDATE("You are not allowed to perform this operation.\nTo push into this reference you need 'Push' rights."),
        DELETE("You need 'Push' rights with the 'Force Push'\nflag set to delete references."),
        DELETE_CHANGES("Cannot delete from 'refs/changes/'"),
        CODE_REVIEW("You need 'Push' rights to upload code review requests.\nVerify that you are pushing to the right branch.");

        private final String value;

        private Error(String value) {
            this.value = value;
        }

        public String get() {
            return this.value;
        }
    }
}

