/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Objects;
import com.google.gerrit.server.git.MetaDataUpdate;
import java.io.IOException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.RawParseUtils;

public abstract class VersionedMetaData {
    private RevCommit revision;
    protected ObjectReader reader;
    protected ObjectInserter inserter;
    protected DirCache newTree;

    protected abstract String getRefName();

    protected abstract void onLoad() throws IOException, ConfigInvalidException;

    protected abstract boolean onSave(CommitBuilder var1) throws IOException, ConfigInvalidException;

    public ObjectId getRevision() {
        return this.revision != null ? this.revision.copy() : null;
    }

    public void load(Repository db) throws IOException, ConfigInvalidException {
        Ref ref = db.getRef(this.getRefName());
        this.load(db, ref != null ? ref.getObjectId() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Repository db, ObjectId id) throws IOException, ConfigInvalidException {
        this.reader = db.newObjectReader();
        try {
            this.revision = id != null ? new RevWalk(this.reader).parseCommit(id) : null;
            this.onLoad();
        }
        finally {
            this.reader.close();
            this.reader = null;
        }
    }

    public void load(MetaDataUpdate update) throws IOException, ConfigInvalidException {
        this.load(update.getRepository());
    }

    public void load(MetaDataUpdate update, ObjectId id) throws IOException, ConfigInvalidException {
        this.load(update.getRepository(), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevCommit commit(MetaDataUpdate update) throws IOException {
        try (BatchMetaDataUpdate batch = this.openUpdate(update);){
            batch.write(update.getCommitBuilder());
            RevCommit revCommit = batch.commit();
            return revCommit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevCommit commitToNewRef(MetaDataUpdate update, String refName) throws IOException {
        try (BatchMetaDataUpdate batch = this.openUpdate(update);){
            batch.write(update.getCommitBuilder());
            RevCommit revCommit = batch.createRef(refName);
            return revCommit;
        }
    }

    public BatchMetaDataUpdate openUpdate(final MetaDataUpdate update) throws IOException {
        final Repository db = update.getRepository();
        this.reader = db.newObjectReader();
        this.inserter = db.newObjectInserter();
        final RevWalk rw = new RevWalk(this.reader);
        final RevTree tree = this.revision != null ? rw.parseTree(this.revision) : null;
        this.newTree = this.readTree(tree);
        return new BatchMetaDataUpdate(){
            AnyObjectId src;
            AnyObjectId srcTree;
            {
                this.src = VersionedMetaData.this.revision;
                this.srcTree = tree;
            }

            @Override
            public void write(CommitBuilder commit) throws IOException {
                this.write(VersionedMetaData.this, commit);
            }

            private boolean doSave(VersionedMetaData config, CommitBuilder commit) throws IOException {
                DirCache nt = config.newTree;
                ObjectReader r = config.reader;
                ObjectInserter i = config.inserter;
                try {
                    config.newTree = VersionedMetaData.this.newTree;
                    config.reader = VersionedMetaData.this.reader;
                    config.inserter = VersionedMetaData.this.inserter;
                    boolean bl = config.onSave(commit);
                    return bl;
                }
                catch (ConfigInvalidException e) {
                    throw new IOException("Cannot update " + VersionedMetaData.this.getRefName() + " in " + db.getDirectory() + ": " + e.getMessage(), e);
                }
                finally {
                    config.newTree = nt;
                    config.reader = r;
                    config.inserter = i;
                }
            }

            @Override
            public void write(VersionedMetaData config, CommitBuilder commit) throws IOException {
                if (!this.doSave(config, commit)) {
                    return;
                }
                ObjectId res = VersionedMetaData.this.newTree.writeTree(VersionedMetaData.this.inserter);
                if (res.equals(this.srcTree) && !update.allowEmpty()) {
                    return;
                }
                commit.setTreeId(res);
                if (this.src != null) {
                    commit.addParentId(this.src);
                }
                this.src = VersionedMetaData.this.inserter.insert(commit);
                this.srcTree = res;
            }

            @Override
            public RevCommit createRef(String refName) throws IOException {
                if (Objects.equal(this.src, VersionedMetaData.this.revision)) {
                    return VersionedMetaData.this.revision;
                }
                RefUpdate ru = db.updateRef(refName);
                ru.setExpectedOldObjectId(ObjectId.zeroId());
                ru.setNewObjectId(this.src);
                ru.disableRefLog();
                VersionedMetaData.this.inserter.flush();
                RefUpdate.Result result = ru.update();
                switch (result) {
                    case NEW: {
                        VersionedMetaData.this.revision = rw.parseCommit(ru.getNewObjectId());
                        update.fireGitRefUpdatedEvent(ru);
                        return VersionedMetaData.this.revision;
                    }
                }
                throw new IOException("Cannot update " + ru.getName() + " in " + db.getDirectory() + ": " + (Object)((Object)ru.getResult()));
            }

            @Override
            public RevCommit commit() throws IOException {
                return this.commitAt(VersionedMetaData.this.revision);
            }

            @Override
            public RevCommit commitAt(ObjectId expected) throws IOException {
                if (Objects.equal(this.src, expected)) {
                    return VersionedMetaData.this.revision;
                }
                RefUpdate ru = db.updateRef(VersionedMetaData.this.getRefName());
                if (expected != null) {
                    ru.setExpectedOldObjectId(expected);
                } else {
                    ru.setExpectedOldObjectId(ObjectId.zeroId());
                }
                ru.setNewObjectId(this.src);
                ru.disableRefLog();
                VersionedMetaData.this.inserter.flush();
                switch (ru.update(rw)) {
                    case NEW: 
                    case FAST_FORWARD: {
                        VersionedMetaData.this.revision = rw.parseCommit(ru.getNewObjectId());
                        update.fireGitRefUpdatedEvent(ru);
                        return VersionedMetaData.this.revision;
                    }
                }
                throw new IOException("Cannot update " + ru.getName() + " in " + db.getDirectory() + ": " + (Object)((Object)ru.getResult()));
            }

            @Override
            public void close() {
                VersionedMetaData.this.newTree = null;
                if (VersionedMetaData.this.inserter != null) {
                    VersionedMetaData.this.inserter.close();
                    VersionedMetaData.this.inserter = null;
                }
                if (VersionedMetaData.this.reader != null) {
                    VersionedMetaData.this.reader.close();
                    VersionedMetaData.this.reader = null;
                }
            }
        };
    }

    protected DirCache readTree(RevTree tree) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        DirCache dc = DirCache.newInCore();
        if (tree != null) {
            DirCacheBuilder b = dc.builder();
            b.addTree(new byte[0], 0, this.reader, tree);
            b.finish();
        }
        return dc;
    }

    protected Config readConfig(String fileName) throws IOException, ConfigInvalidException {
        Config rc = new Config();
        String text = this.readUTF8(fileName);
        if (!text.isEmpty()) {
            try {
                rc.fromText(text);
            }
            catch (ConfigInvalidException err) {
                throw new ConfigInvalidException("Invalid config file " + fileName + " in commit " + this.revision.name(), err);
            }
        }
        return rc;
    }

    protected String readUTF8(String fileName) throws IOException {
        byte[] raw = this.readFile(fileName);
        return raw.length != 0 ? RawParseUtils.decode(raw) : "";
    }

    protected byte[] readFile(String fileName) throws IOException {
        if (this.revision == null) {
            return new byte[0];
        }
        TreeWalk tw = TreeWalk.forPath(this.reader, fileName, this.revision.getTree());
        if (tw != null) {
            ObjectLoader obj = this.reader.open(tw.getObjectId(0), 3);
            return obj.getCachedBytes(Integer.MAX_VALUE);
        }
        return new byte[0];
    }

    protected ObjectId getObjectId(String fileName) throws IOException {
        if (this.revision == null) {
            return null;
        }
        TreeWalk tw = TreeWalk.forPath(this.reader, fileName, this.revision.getTree());
        if (tw != null) {
            return tw.getObjectId(0);
        }
        return null;
    }

    protected static void set(Config rc, String section, String subsection, String name, String value) {
        if (value != null) {
            rc.setString(section, subsection, name, value);
        } else {
            rc.unset(section, subsection, name);
        }
    }

    protected static void set(Config rc, String section, String subsection, String name, boolean value) {
        if (value) {
            rc.setBoolean(section, subsection, name, value);
        } else {
            rc.unset(section, subsection, name);
        }
    }

    protected static <E extends Enum<?>> void set(Config rc, String section, String subsection, String name, E value, E defaultValue) {
        if (value != defaultValue) {
            rc.setEnum(section, subsection, name, value);
        } else {
            rc.unset(section, subsection, name);
        }
    }

    protected void saveConfig(String fileName, Config cfg) throws IOException {
        this.saveUTF8(fileName, cfg.toText());
    }

    protected void saveUTF8(String fileName, String text) throws IOException {
        this.saveFile(fileName, text != null ? Constants.encode(text) : null);
    }

    protected void saveFile(String fileName, byte[] raw) throws IOException {
        DirCacheEditor editor = this.newTree.editor();
        if (raw != null && 0 < raw.length) {
            final ObjectId blobId = this.inserter.insert(3, raw);
            editor.add(new DirCacheEditor.PathEdit(fileName){

                @Override
                public void apply(DirCacheEntry ent) {
                    ent.setFileMode(FileMode.REGULAR_FILE);
                    ent.setObjectId(blobId);
                }
            });
        } else {
            editor.add(new DirCacheEditor.DeletePath(fileName));
        }
        editor.finish();
    }

    public static interface BatchMetaDataUpdate {
        public void write(CommitBuilder var1) throws IOException;

        public void write(VersionedMetaData var1, CommitBuilder var2) throws IOException;

        public RevCommit createRef(String var1) throws IOException;

        public RevCommit commit() throws IOException;

        public RevCommit commitAt(ObjectId var1) throws IOException;

        public void close();
    }
}

