/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListIncludedGroups
implements RestReadView<GroupResource> {
    private static final Logger log = LoggerFactory.getLogger(ListIncludedGroups.class);
    private final GroupControl.Factory controlFactory;
    private final Provider<ReviewDb> dbProvider;
    private final GroupJson json;

    @Inject
    ListIncludedGroups(GroupControl.Factory controlFactory, Provider<ReviewDb> dbProvider, GroupJson json) {
        this.controlFactory = controlFactory;
        this.dbProvider = dbProvider;
        this.json = json;
    }

    public List<GroupJson.GroupInfo> apply(GroupResource rsrc) throws MethodNotAllowedException, OrmException {
        if (rsrc.toAccountGroup() == null) {
            throw new MethodNotAllowedException();
        }
        boolean ownerOfParent = rsrc.getControl().isOwner();
        ArrayList<GroupJson.GroupInfo> included = Lists.newArrayList();
        for (AccountGroupById u : this.dbProvider.get().accountGroupById().byGroup(rsrc.toAccountGroup().getId())) {
            try {
                GroupControl i = this.controlFactory.controlFor(u.getIncludeUUID());
                if (!ownerOfParent && !i.isVisible()) continue;
                included.add(this.json.format(i.getGroup()));
            }
            catch (NoSuchGroupException notFound) {
                log.warn(String.format("Group %s no longer available, included into %s", u.getIncludeUUID(), rsrc.getGroup().getName()));
            }
        }
        Collections.sort(included, new Comparator<GroupJson.GroupInfo>(){

            @Override
            public int compare(GroupJson.GroupInfo a, GroupJson.GroupInfo b) {
                int cmp = Strings.nullToEmpty(a.name).compareTo(Strings.nullToEmpty(b.name));
                if (cmp != 0) {
                    return cmp;
                }
                return Strings.nullToEmpty(a.id).compareTo(Strings.nullToEmpty(b.id));
            }
        });
        return included;
    }
}

