/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.server.index.ChangeIndex;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

@Singleton
public class IndexCollection
implements LifecycleListener {
    private final CopyOnWriteArrayList<ChangeIndex> writeIndexes = Lists.newCopyOnWriteArrayList();
    private final AtomicReference<ChangeIndex> searchIndex = new AtomicReference();

    @Inject
    @VisibleForTesting
    public IndexCollection() {
    }

    public ChangeIndex getSearchIndex() {
        return this.searchIndex.get();
    }

    public void setSearchIndex(ChangeIndex index) {
        ChangeIndex old = this.searchIndex.getAndSet(index);
        if (old != null && old != index && !this.writeIndexes.contains(old)) {
            old.close();
        }
    }

    public Collection<ChangeIndex> getWriteIndexes() {
        return Collections.unmodifiableCollection(this.writeIndexes);
    }

    public synchronized ChangeIndex addWriteIndex(ChangeIndex index) {
        int version = index.getSchema().getVersion();
        for (int i = 0; i < this.writeIndexes.size(); ++i) {
            if (this.writeIndexes.get(i).getSchema().getVersion() != version) continue;
            return this.writeIndexes.set(i, index);
        }
        this.writeIndexes.add(index);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeWriteIndex(int version) {
        int removeIndex = -1;
        for (int i = 0; i < this.writeIndexes.size(); ++i) {
            if (this.writeIndexes.get(i).getSchema().getVersion() != version) continue;
            removeIndex = i;
            break;
        }
        if (removeIndex >= 0) {
            try {
                this.writeIndexes.get(removeIndex).close();
            }
            finally {
                this.writeIndexes.remove(removeIndex);
            }
        }
    }

    public ChangeIndex getWriteIndex(int version) {
        for (ChangeIndex i : this.writeIndexes) {
            if (i.getSchema().getVersion() != version) continue;
            return i;
        }
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        ChangeIndex read = this.searchIndex.get();
        if (read != null) {
            read.close();
        }
        for (ChangeIndex write : this.writeIndexes) {
            if (write == read) continue;
            write.close();
        }
    }
}

