/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.mail.CreateChangeSender;
import com.google.gerrit.server.mail.MailUtil;
import com.google.gerrit.server.mail.ReplacePatchSetSender;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchSetNotificationSender {
    private static final Logger log = LoggerFactory.getLogger(PatchSetNotificationSender.class);
    private final ReviewDb db;
    private final GitRepositoryManager repoManager;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final ApprovalsUtil approvalsUtil;
    private final AccountResolver accountResolver;
    private final CreateChangeSender.Factory createChangeSenderFactory;
    private final ReplacePatchSetSender.Factory replacePatchSetFactory;

    @Inject
    public PatchSetNotificationSender(ReviewDb db, ChangeHooks hooks, GitRepositoryManager repoManager, PatchSetInfoFactory patchSetInfoFactory, ApprovalsUtil approvalsUtil, AccountResolver accountResolver, CreateChangeSender.Factory createChangeSenderFactory, ReplacePatchSetSender.Factory replacePatchSetFactory, ChangeIndexer indexer) {
        this.db = db;
        this.repoManager = repoManager;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.approvalsUtil = approvalsUtil;
        this.accountResolver = accountResolver;
        this.createChangeSenderFactory = createChangeSenderFactory;
        this.replacePatchSetFactory = replacePatchSetFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ChangeNotes notes, ChangeUpdate update, boolean newChange, IdentifiedUser currentUser, Change updatedChange, PatchSet updatedPatchSet, LabelTypes labelTypes) throws OrmException, IOException, PatchSetInfoNotAvailableException {
        try (Repository git = this.repoManager.openRepository(updatedChange.getProject());){
            RevCommit commit;
            try (RevWalk revWalk = new RevWalk(git);){
                commit = revWalk.parseCommit(ObjectId.fromString(updatedPatchSet.getRevision().get()));
            }
            PatchSetInfo info = this.patchSetInfoFactory.get(commit, updatedPatchSet.getId());
            List<FooterLine> footerLines = commit.getFooterLines();
            Account.Id me = currentUser.getAccountId();
            MailUtil.MailRecipients recipients = MailUtil.getRecipientsFromFooters(this.accountResolver, updatedPatchSet, footerLines);
            recipients.remove(me);
            if (newChange) {
                this.approvalsUtil.addReviewers(this.db, update, labelTypes, updatedChange, updatedPatchSet, info, recipients.getReviewers(), Collections.emptySet());
                try {
                    CreateChangeSender cm = this.createChangeSenderFactory.create(updatedChange);
                    cm.setFrom(me);
                    cm.setPatchSet(updatedPatchSet, info);
                    cm.addReviewers(recipients.getReviewers());
                    cm.addExtraCC(recipients.getCcOnly());
                    cm.send();
                }
                catch (Exception e) {
                    log.error("Cannot send email for new change " + updatedChange.getId(), e);
                }
            } else {
                this.approvalsUtil.addReviewers(this.db, update, labelTypes, updatedChange, updatedPatchSet, info, recipients.getReviewers(), this.approvalsUtil.getReviewers(this.db, notes).values());
                ChangeMessage msg = new ChangeMessage(new ChangeMessage.Key(updatedChange.getId(), ChangeUtil.messageUUID(this.db)), me, updatedPatchSet.getCreatedOn(), updatedPatchSet.getId());
                msg.setMessage("Uploaded patch set " + updatedPatchSet.getPatchSetId() + ".");
                try {
                    ReplacePatchSetSender cm = this.replacePatchSetFactory.create(updatedChange);
                    cm.setFrom(me);
                    cm.setPatchSet(updatedPatchSet, info);
                    cm.setChangeMessage(msg);
                    cm.addReviewers(recipients.getReviewers());
                    cm.addExtraCC(recipients.getCcOnly());
                    cm.send();
                }
                catch (Exception e) {
                    log.error("Cannot send email for new patch set " + updatedPatchSet.getId(), e);
                }
            }
        }
    }
}

