/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

@Singleton
public class NotesMigration {
    private final boolean write;
    private final boolean readPatchSetApprovals;

    @VisibleForTesting
    static NotesMigration allEnabled() {
        Config cfg = new Config();
        cfg.setBoolean("notedb", null, "write", true);
        return new NotesMigration(cfg);
    }

    @Inject
    NotesMigration(@GerritServerConfig Config cfg) {
        this.write = cfg.getBoolean("notedb", null, "write", false);
        this.readPatchSetApprovals = cfg.getBoolean("notedb", "patchSetApprovals", "read", false);
        Preconditions.checkArgument(!this.readPatchSetApprovals, "notedb.readPatchSetApprovals not yet supported");
    }

    public boolean write() {
        return this.write;
    }

    public boolean readPatchSetApprovals() {
        return this.readPatchSetApprovals;
    }
}

