/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.client.UserIdentity;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountByEmailCache;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class PatchSetInfoFactory {
    private final GitRepositoryManager repoManager;
    private final AccountByEmailCache byEmailCache;

    @Inject
    public PatchSetInfoFactory(GitRepositoryManager grm, AccountByEmailCache byEmailCache) {
        this.repoManager = grm;
        this.byEmailCache = byEmailCache;
    }

    public PatchSetInfo get(RevCommit src, PatchSet.Id psi) {
        PatchSetInfo info = new PatchSetInfo(psi);
        info.setSubject(src.getShortMessage());
        info.setMessage(src.getFullMessage());
        info.setAuthor(this.toUserIdentity(src.getAuthorIdent()));
        info.setCommitter(this.toUserIdentity(src.getCommitterIdent()));
        info.setRevId(src.getName());
        return info;
    }

    public PatchSetInfo get(ReviewDb db, PatchSet.Id patchSetId) throws PatchSetInfoNotAvailableException {
        try {
            PatchSet patchSet = db.patchSets().get(patchSetId);
            Change change = db.changes().get(patchSet.getId().getParentKey());
            return this.get(change, patchSet);
        }
        catch (OrmException e) {
            throw new PatchSetInfoNotAvailableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchSetInfo get(Change change, PatchSet patchSet) throws PatchSetInfoNotAvailableException {
        Repository repo;
        try {
            repo = this.repoManager.openRepository(change.getProject());
        }
        catch (IOException e) {
            throw new PatchSetInfoNotAvailableException(e);
        }
        try {
            RevWalk rw = new RevWalk(repo);
            try {
                RevCommit src = rw.parseCommit(ObjectId.fromString(patchSet.getRevision().get()));
                PatchSetInfo info = this.get(src, patchSet.getId());
                info.setParents(this.toParentInfos(src.getParents(), rw));
                PatchSetInfo patchSetInfo = info;
                rw.close();
                return patchSetInfo;
            }
            catch (Throwable throwable) {
                try {
                    rw.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PatchSetInfoNotAvailableException(e);
                }
            }
        }
        finally {
            repo.close();
        }
    }

    private UserIdentity toUserIdentity(PersonIdent who) {
        UserIdentity u = new UserIdentity();
        u.setName(who.getName());
        u.setEmail(who.getEmailAddress());
        u.setDate(new Timestamp(who.getWhen().getTime()));
        u.setTimeZone(who.getTimeZoneOffset());
        Set<Account.Id> a = this.byEmailCache.get(u.getEmail());
        if (a.size() == 1) {
            u.setAccount(a.iterator().next());
        }
        return u;
    }

    private List<PatchSetInfo.ParentInfo> toParentInfos(RevCommit[] parents, RevWalk walk) throws IOException, MissingObjectException {
        ArrayList<PatchSetInfo.ParentInfo> pInfos = new ArrayList<PatchSetInfo.ParentInfo>(parents.length);
        for (RevCommit parent : parents) {
            walk.parseBody(parent);
            RevId rev = new RevId(parent.getId().name());
            String msg = parent.getShortMessage();
            pInfos.add(new PatchSetInfo.ParentInfo(rev, msg));
        }
        return pInfos;
    }
}

