/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.extensions.webui.UiActions;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.project.CommentLinkInfo;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.ThemeInfo;
import com.google.inject.util.Providers;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConfigInfo {
    public final String kind = "gerritcodereview#project_config";
    public String description;
    public InheritedBooleanInfo useContributorAgreements;
    public InheritedBooleanInfo useContentMerge;
    public InheritedBooleanInfo useSignedOffBy;
    public InheritedBooleanInfo requireChangeId;
    public MaxObjectSizeLimitInfo maxObjectSizeLimit;
    public Project.SubmitType submitType;
    public Project.State state;
    public Map<String, Map<String, ConfigParameterInfo>> pluginConfig;
    public Map<String, ActionInfo> actions;
    public Map<String, CommentLinkInfo> commentlinks;
    public ThemeInfo theme;

    public ConfigInfo(ProjectControl control, TransferConfig config, DynamicMap<ProjectConfigEntry> pluginConfigEntries, PluginConfigFactory cfgFactory, AllProjectsNameProvider allProjects, DynamicMap<RestView<ProjectResource>> views) {
        ProjectState projectState = control.getProjectState();
        Project p = control.getProject();
        this.description = Strings.emptyToNull(p.getDescription());
        InheritedBooleanInfo useContributorAgreements = new InheritedBooleanInfo();
        InheritedBooleanInfo useSignedOffBy = new InheritedBooleanInfo();
        InheritedBooleanInfo useContentMerge = new InheritedBooleanInfo();
        InheritedBooleanInfo requireChangeId = new InheritedBooleanInfo();
        useContributorAgreements.value = projectState.isUseContributorAgreements();
        useSignedOffBy.value = projectState.isUseSignedOffBy();
        useContentMerge.value = projectState.isUseContentMerge();
        requireChangeId.value = projectState.isRequireChangeID();
        useContributorAgreements.configuredValue = p.getUseContributorAgreements();
        useSignedOffBy.configuredValue = p.getUseSignedOffBy();
        useContentMerge.configuredValue = p.getUseContentMerge();
        requireChangeId.configuredValue = p.getRequireChangeID();
        ProjectState parentState = Iterables.getFirst(projectState.parents(), null);
        if (parentState != null) {
            useContributorAgreements.inheritedValue = parentState.isUseContributorAgreements();
            useSignedOffBy.inheritedValue = parentState.isUseSignedOffBy();
            useContentMerge.inheritedValue = parentState.isUseContentMerge();
            requireChangeId.inheritedValue = parentState.isRequireChangeID();
        }
        this.useContributorAgreements = useContributorAgreements;
        this.useSignedOffBy = useSignedOffBy;
        this.useContentMerge = useContentMerge;
        this.requireChangeId = requireChangeId;
        MaxObjectSizeLimitInfo maxObjectSizeLimit = new MaxObjectSizeLimitInfo();
        maxObjectSizeLimit.value = config.getEffectiveMaxObjectSizeLimit(projectState) == config.getMaxObjectSizeLimit() ? config.getFormattedMaxObjectSizeLimit() : p.getMaxObjectSizeLimit();
        maxObjectSizeLimit.configuredValue = p.getMaxObjectSizeLimit();
        maxObjectSizeLimit.inheritedValue = config.getFormattedMaxObjectSizeLimit();
        this.maxObjectSizeLimit = maxObjectSizeLimit;
        this.submitType = p.getSubmitType();
        this.state = p.getState() != Project.State.ACTIVE ? p.getState() : null;
        this.commentlinks = Maps.newLinkedHashMap();
        for (CommentLinkInfo cl : projectState.getCommentLinks()) {
            this.commentlinks.put(cl.name, cl);
        }
        this.pluginConfig = this.getPluginConfig(control.getProjectState(), pluginConfigEntries, cfgFactory, allProjects);
        this.actions = Maps.newTreeMap();
        for (UiAction.Description d : UiActions.from(views, new ProjectResource(control), Providers.of(control.getCurrentUser()))) {
            this.actions.put(d.getId(), new ActionInfo(d));
        }
        this.theme = projectState.getTheme();
    }

    private Map<String, Map<String, ConfigParameterInfo>> getPluginConfig(ProjectState project, DynamicMap<ProjectConfigEntry> pluginConfigEntries, PluginConfigFactory cfgFactory, AllProjectsNameProvider allProjects) {
        TreeMap<String, Map<String, ConfigParameterInfo>> pluginConfig = new TreeMap<String, Map<String, ConfigParameterInfo>>();
        for (DynamicMap.Entry<ProjectConfigEntry> entry : pluginConfigEntries) {
            ProjectConfigEntry configEntry = entry.getProvider().get();
            PluginConfig cfg = cfgFactory.getFromProjectConfig(project, entry.getPluginName());
            String configuredValue = cfg.getString(entry.getExportName());
            ConfigParameterInfo p = new ConfigParameterInfo();
            p.displayName = configEntry.getDisplayName();
            p.description = configEntry.getDescription();
            p.warning = configEntry.getWarning(project);
            p.type = configEntry.getType();
            p.permittedValues = configEntry.getPermittedValues();
            Boolean bl = p.editable = configEntry.isEditable(project) ? Boolean.valueOf(true) : null;
            if (configEntry.isInheritable() && !allProjects.get().equals(project.getProject().getNameKey())) {
                PluginConfig cfgWithInheritance = cfgFactory.getFromProjectConfigWithInheritance(project, entry.getPluginName());
                p.inheritable = true;
                p.value = cfgWithInheritance.getString(entry.getExportName(), configEntry.getDefaultValue());
                p.configuredValue = configuredValue;
                p.inheritedValue = this.getInheritedValue(project, cfgFactory, entry);
            } else if (configEntry.getType() == ProjectConfigEntry.Type.ARRAY) {
                p.values = Arrays.asList(cfg.getStringList(entry.getExportName()));
            } else {
                p.value = configuredValue != null ? configuredValue : configEntry.getDefaultValue();
            }
            Map<String, ConfigParameterInfo> pc = pluginConfig.get(entry.getPluginName());
            if (pc == null) {
                pc = new TreeMap<String, ConfigParameterInfo>();
                pluginConfig.put(entry.getPluginName(), pc);
            }
            pc.put(entry.getExportName(), p);
        }
        return !pluginConfig.isEmpty() ? pluginConfig : null;
    }

    private String getInheritedValue(ProjectState project, PluginConfigFactory cfgFactory, DynamicMap.Entry<ProjectConfigEntry> e) {
        ProjectConfigEntry configEntry = e.getProvider().get();
        ProjectState parent = Iterables.getFirst(project.parents(), null);
        String inheritedValue = configEntry.getDefaultValue();
        if (parent != null) {
            PluginConfig parentCfgWithInheritance = cfgFactory.getFromProjectConfigWithInheritance(parent, e.getPluginName());
            inheritedValue = parentCfgWithInheritance.getString(e.getExportName(), configEntry.getDefaultValue());
        }
        return inheritedValue;
    }

    public static class ConfigParameterInfo {
        public String displayName;
        public String description;
        public String warning;
        public ProjectConfigEntry.Type type;
        public String value;
        public Boolean editable;
        public Boolean inheritable;
        public String configuredValue;
        public String inheritedValue;
        public List<String> permittedValues;
        public List<String> values;
    }

    public static class MaxObjectSizeLimitInfo {
        public String value;
        public String configuredValue;
        public String inheritedValue;
    }

    public static class InheritedBooleanInfo {
        public Boolean value;
        public Project.InheritableBoolean configuredValue;
        public Boolean inheritedValue;
    }
}

