/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Objects;
import com.google.gerrit.common.ProjectUtil;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.errors.ProjectCreationFailedException;
import com.google.gerrit.extensions.events.NewProjectCreatedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.ProjectOwnerGroups;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.RepositoryCaseMismatchException;
import com.google.gerrit.server.project.CreateProjectArgs;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformCreateProject {
    private static final Logger log = LoggerFactory.getLogger(PerformCreateProject.class);
    private final Config cfg;
    private final Set<AccountGroup.UUID> projectOwnerGroups;
    private final IdentifiedUser currentUser;
    private final GitRepositoryManager repoManager;
    private final GitReferenceUpdated referenceUpdated;
    private final DynamicSet<NewProjectCreatedListener> createdListener;
    private final PersonIdent serverIdent;
    private final CreateProjectArgs createProjectArgs;
    private final ProjectCache projectCache;
    private final GroupBackend groupBackend;
    private final MetaDataUpdate.User metaDataUpdateFactory;

    @Inject
    PerformCreateProject(@GerritServerConfig Config cfg, @ProjectOwnerGroups Set<AccountGroup.UUID> pOwnerGroups, IdentifiedUser identifiedUser, GitRepositoryManager gitRepoManager, GitReferenceUpdated referenceUpdated, DynamicSet<NewProjectCreatedListener> createdListener, @GerritPersonIdent PersonIdent personIdent, GroupBackend groupBackend, MetaDataUpdate.User metaDataUpdateFactory, @Assisted CreateProjectArgs createPArgs, ProjectCache pCache) {
        this.cfg = cfg;
        this.projectOwnerGroups = pOwnerGroups;
        this.currentUser = identifiedUser;
        this.repoManager = gitRepoManager;
        this.referenceUpdated = referenceUpdated;
        this.createdListener = createdListener;
        this.serverIdent = personIdent;
        this.createProjectArgs = createPArgs;
        this.projectCache = pCache;
        this.groupBackend = groupBackend;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project createProject() throws ProjectCreationFailedException {
        this.validateParameters();
        final Project.NameKey nameKey = this.createProjectArgs.getProject();
        final String head = this.createProjectArgs.permissionsOnly ? "refs/meta/config" : this.createProjectArgs.branch.get(0);
        Repository repo = this.repoManager.createRepository(nameKey);
        try {
            NewProjectCreatedListener.Event event = new NewProjectCreatedListener.Event(){

                @Override
                public String getProjectName() {
                    return nameKey.get();
                }

                @Override
                public String getHeadName() {
                    return head;
                }
            };
            for (NewProjectCreatedListener l : this.createdListener) {
                try {
                    l.onNewProjectCreated(event);
                }
                catch (RuntimeException e) {
                    log.warn("Failure in NewProjectCreatedListener", e);
                }
            }
            RefUpdate u = repo.updateRef("HEAD");
            u.disableRefLog();
            u.link(head);
            this.createProjectConfig();
            if (!this.createProjectArgs.permissionsOnly && this.createProjectArgs.createEmptyCommit) {
                this.createEmptyCommits(repo, nameKey, this.createProjectArgs.branch);
            }
            Project project = this.projectCache.get(nameKey).getProject();
            repo.close();
            return project;
        }
        catch (Throwable throwable) {
            try {
                repo.close();
                throw throwable;
            }
            catch (RepositoryCaseMismatchException e) {
                throw new ProjectCreationFailedException("Cannot create " + nameKey.get() + " because the name is already occupied by another project." + " The other project has the same name, only spelled in a" + " different case.", e);
            }
            catch (RepositoryNotFoundException badName) {
                throw new ProjectCreationFailedException("Cannot create " + nameKey, badName);
            }
            catch (IllegalStateException err) {
                try {
                    repo = this.repoManager.openRepository(nameKey);
                    try {
                        if (repo.getObjectDatabase().exists()) {
                            throw new ProjectCreationFailedException("project \"" + nameKey + "\" exists");
                        }
                        throw err;
                    }
                    catch (Throwable throwable2) {
                        repo.close();
                        throw throwable2;
                    }
                }
                catch (IOException ioErr) {
                    String msg = "Cannot create " + nameKey;
                    log.error(msg, err);
                    throw new ProjectCreationFailedException(msg, ioErr);
                }
            }
            catch (Exception e) {
                String msg = "Cannot create " + nameKey;
                log.error(msg, e);
                throw new ProjectCreationFailedException(msg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProjectConfig() throws IOException, ConfigInvalidException {
        try (MetaDataUpdate md = this.metaDataUpdateFactory.create(this.createProjectArgs.getProject());){
            ProjectConfig config = ProjectConfig.read(md);
            config.load(md);
            Project newProject = config.getProject();
            newProject.setDescription(this.createProjectArgs.projectDescription);
            newProject.setSubmitType(Objects.firstNonNull(this.createProjectArgs.submitType, this.cfg.getEnum("repository", "*", "defaultSubmitType", Project.SubmitType.MERGE_IF_NECESSARY)));
            newProject.setUseContributorAgreements(this.createProjectArgs.contributorAgreements);
            newProject.setUseSignedOffBy(this.createProjectArgs.signedOffBy);
            newProject.setUseContentMerge(this.createProjectArgs.contentMerge);
            newProject.setRequireChangeID(this.createProjectArgs.changeIdRequired);
            newProject.setMaxObjectSizeLimit(this.createProjectArgs.maxObjectSizeLimit);
            if (this.createProjectArgs.newParent != null) {
                newProject.setParentName(this.createProjectArgs.newParent.getProject().getNameKey());
            }
            if (!this.createProjectArgs.ownerIds.isEmpty()) {
                AccessSection all = config.getAccessSection("refs/*", true);
                for (AccountGroup.UUID ownerId : this.createProjectArgs.ownerIds) {
                    GroupDescription.Basic g = this.groupBackend.get(ownerId);
                    if (g == null) continue;
                    GroupReference group = config.resolve(GroupReference.forGroup(g));
                    all.getPermission("owner", true).add(new PermissionRule(group));
                }
            }
            md.setMessage("Created project\n");
            config.commit(md);
        }
        this.projectCache.onCreateProject(this.createProjectArgs.getProject());
        this.repoManager.setProjectDescription(this.createProjectArgs.getProject(), this.createProjectArgs.projectDescription);
    }

    private void validateParameters() throws ProjectCreationFailedException {
        if (this.createProjectArgs.getProjectName() == null || this.createProjectArgs.getProjectName().isEmpty()) {
            throw new ProjectCreationFailedException("Project name is required");
        }
        String nameWithoutSuffix = ProjectUtil.stripGitSuffix(this.createProjectArgs.getProjectName());
        this.createProjectArgs.setProjectName(nameWithoutSuffix);
        if (!this.currentUser.getCapabilities().canCreateProject()) {
            throw new ProjectCreationFailedException(String.format("%s does not have \"Create Project\" capability.", this.currentUser.getUserName()));
        }
        if (this.createProjectArgs.ownerIds == null || this.createProjectArgs.ownerIds.isEmpty()) {
            this.createProjectArgs.ownerIds = new ArrayList<AccountGroup.UUID>(this.projectOwnerGroups);
        }
        ArrayList<String> transformedBranches = new ArrayList<String>();
        if (this.createProjectArgs.branch == null || this.createProjectArgs.branch.isEmpty()) {
            this.createProjectArgs.branch = Collections.singletonList("master");
        }
        for (String branch : this.createProjectArgs.branch) {
            while (branch.startsWith("/")) {
                branch = branch.substring(1);
            }
            if (!branch.startsWith("refs/heads/")) {
                branch = "refs/heads/" + branch;
            }
            if (!Repository.isValidRefName(branch)) {
                throw new ProjectCreationFailedException(String.format("Branch \"%s\" is not a valid name.", branch));
            }
            if (transformedBranches.contains(branch)) continue;
            transformedBranches.add(branch);
        }
        this.createProjectArgs.branch = transformedBranches;
    }

    private void createEmptyCommits(Repository repo, Project.NameKey project, List<String> refs) throws IOException {
        try (ObjectInserter oi = repo.newObjectInserter();){
            CommitBuilder cb = new CommitBuilder();
            cb.setTreeId(oi.insert(2, new byte[0]));
            cb.setAuthor(this.metaDataUpdateFactory.getUserPersonIdent());
            cb.setCommitter(this.serverIdent);
            cb.setMessage("Initial empty repository\n");
            ObjectId id = oi.insert(cb);
            oi.flush();
            block8: for (String ref : refs) {
                RefUpdate ru = repo.updateRef(ref);
                ru.setNewObjectId(id);
                RefUpdate.Result result = ru.update();
                switch (result) {
                    case NEW: {
                        this.referenceUpdated.fire(project, ru);
                        continue block8;
                    }
                }
                throw new IOException(String.format("Failed to create ref \"%s\": %s", ref, result.name()));
            }
        }
    }

    public static interface Factory {
        public PerformCreateProject create(CreateProjectArgs var1);
    }
}

