/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.events.HeadUpdatedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.auth.AuthException;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetHead
implements RestModifyView<ProjectResource, Input> {
    private static final Logger log = LoggerFactory.getLogger(SetHead.class);
    private final GitRepositoryManager repoManager;
    private final Provider<IdentifiedUser> identifiedUser;
    private final DynamicSet<HeadUpdatedListener> headUpdatedListener;

    @Inject
    SetHead(GitRepositoryManager repoManager, Provider<IdentifiedUser> identifiedUser, DynamicSet<HeadUpdatedListener> headUpdatedListener) {
        this.repoManager = repoManager;
        this.identifiedUser = identifiedUser;
        this.headUpdatedListener = headUpdatedListener;
    }

    public String apply(final ProjectResource rsrc, Input input) throws AuthException, ResourceNotFoundException, BadRequestException, UnprocessableEntityException, IOException {
        if (!rsrc.getControl().isOwner()) {
            throw new AuthException("restricted to project owner");
        }
        if (input == null || Strings.isNullOrEmpty(input.ref)) {
            throw new BadRequestException("ref required");
        }
        String ref = input.ref;
        if (!ref.startsWith("refs/")) {
            ref = "refs/heads/" + ref;
        }
        try (Repository repo = null;){
            String newHead;
            repo = this.repoManager.openRepository(rsrc.getNameKey());
            if (repo.getRef(ref) == null) {
                throw new UnprocessableEntityException(String.format("Ref Not Found: %s", ref));
            }
            final String oldHead = repo.getRef("HEAD").getTarget().getName();
            if (!oldHead.equals(newHead = ref)) {
                RefUpdate u = repo.updateRef("HEAD", true);
                u.setRefLogIdent(this.identifiedUser.get().newRefLogIdent());
                RefUpdate.Result res = u.link(newHead);
                switch (res) {
                    case NO_CHANGE: 
                    case RENAMED: 
                    case FORCED: 
                    case NEW: {
                        break;
                    }
                    default: {
                        throw new IOException("Setting HEAD failed with " + (Object)((Object)res));
                    }
                }
                HeadUpdatedListener.Event event = new HeadUpdatedListener.Event(){

                    @Override
                    public String getProjectName() {
                        return rsrc.getNameKey().get();
                    }

                    @Override
                    public String getOldHeadName() {
                        return oldHead;
                    }

                    @Override
                    public String getNewHeadName() {
                        return newHead;
                    }
                };
                for (HeadUpdatedListener l : this.headUpdatedListener) {
                    try {
                        l.onHeadUpdated(event);
                    }
                    catch (RuntimeException e) {
                        log.warn("Failure in HeadUpdatedListener", e);
                    }
                }
            }
            String string = ref;
            return string;
        }
    }

    static class Input {
        @DefaultInput
        String ref;

        Input() {
        }
    }
}

