/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.ReviewerState;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ChangeData {
    private final ReviewDb db;
    private final GitRepositoryManager repoManager;
    private final ChangeControl.GenericFactory changeControlFactory;
    private final IdentifiedUser.GenericFactory userFactory;
    private final ChangeNotes.Factory notesFactory;
    private final ApprovalsUtil approvalsUtil;
    private final PatchListCache patchListCache;
    private final NotesMigration notesMigration;
    private final Change.Id legacyId;
    private ChangeDataSource returnedBySource;
    private Change change;
    private ChangeNotes notes;
    private String commitMessage;
    private List<FooterLine> commitFooters;
    private PatchSet currentPatchSet;
    private Collection<PatchSet> patches;
    private ListMultimap<PatchSet.Id, PatchSetApproval> allApprovals;
    private List<PatchSetApproval> currentApprovals;
    private List<String> currentFiles;
    private Collection<PatchLineComment> comments;
    private CurrentUser visibleTo;
    private ChangeControl changeControl;
    private List<ChangeMessage> messages;
    private List<SubmitRecord> submitRecords;
    private ChangedLines changedLines;

    public static void ensureChangeLoaded(Iterable<ChangeData> changes) throws OrmException {
        block5: {
            HashMap<Change.Id, ChangeData> missing = Maps.newHashMap();
            for (ChangeData cd : changes) {
                if (cd.change != null) continue;
                missing.put(cd.getId(), cd);
            }
            if (missing.isEmpty()) break block5;
            ChangeData first = (ChangeData)missing.values().iterator().next();
            if (!first.notesMigration.readPatchSetApprovals()) {
                ReviewDb db = ((ChangeData)missing.values().iterator().next()).db;
                Iterator i$ = db.changes().get(missing.keySet()).iterator();
                while (i$.hasNext()) {
                    Change change;
                    ((ChangeData)missing.get((Object)change.getId())).change = change = (Change)i$.next();
                }
            } else {
                for (ChangeData cd : missing.values()) {
                    cd.change();
                }
            }
        }
    }

    public static void ensureAllPatchSetsLoaded(Iterable<ChangeData> changes) throws OrmException {
        for (ChangeData cd : changes) {
            cd.patches();
        }
    }

    public static void ensureCurrentPatchSetLoaded(Iterable<ChangeData> changes) throws OrmException {
        HashMap<PatchSet.Id, ChangeData> missing = Maps.newHashMap();
        for (ChangeData cd : changes) {
            if (cd.currentPatchSet != null || cd.patches != null) continue;
            missing.put(cd.change().currentPatchSetId(), cd);
        }
        if (!missing.isEmpty()) {
            ReviewDb db = ((ChangeData)missing.values().iterator().next()).db;
            for (PatchSet ps : db.patchSets().get(missing.keySet())) {
                ChangeData cd = (ChangeData)missing.get(ps.getId());
                cd.currentPatchSet = ps;
            }
        }
    }

    public static void ensureCurrentApprovalsLoaded(Iterable<ChangeData> changes) throws OrmException {
        ArrayList<ResultSet<PatchSetApproval>> pending = Lists.newArrayList();
        for (ChangeData cd : changes) {
            if (!cd.notesMigration.readPatchSetApprovals()) {
                if (cd.currentApprovals != null) continue;
                pending.add(cd.db.patchSetApprovals().byPatchSet(cd.change().currentPatchSetId()));
                continue;
            }
            cd.currentApprovals();
        }
        if (!pending.isEmpty()) {
            int idx = 0;
            for (ChangeData cd : changes) {
                if (cd.currentApprovals != null) continue;
                cd.currentApprovals = ApprovalsUtil.sortApprovals((Iterable)pending.get(idx++));
            }
        }
    }

    static ChangeData createForTest(Change.Id id) {
        return new ChangeData(null, null, null, null, null, null, null, null, id);
    }

    @AssistedInject
    private ChangeData(GitRepositoryManager repoManager, ChangeControl.GenericFactory changeControlFactory, IdentifiedUser.GenericFactory userFactory, ChangeNotes.Factory notesFactory, ApprovalsUtil approvalsUtil, PatchListCache patchListCache, NotesMigration notesMigration, @Assisted ReviewDb db, @Assisted Change.Id id) {
        this.db = db;
        this.repoManager = repoManager;
        this.changeControlFactory = changeControlFactory;
        this.userFactory = userFactory;
        this.notesFactory = notesFactory;
        this.approvalsUtil = approvalsUtil;
        this.patchListCache = patchListCache;
        this.notesMigration = notesMigration;
        this.legacyId = id;
    }

    @AssistedInject
    private ChangeData(GitRepositoryManager repoManager, ChangeControl.GenericFactory changeControlFactory, IdentifiedUser.GenericFactory userFactory, ChangeNotes.Factory notesFactory, ApprovalsUtil approvalsUtil, PatchListCache patchListCache, NotesMigration notesMigration, @Assisted ReviewDb db, @Assisted Change c) {
        this.db = db;
        this.repoManager = repoManager;
        this.changeControlFactory = changeControlFactory;
        this.userFactory = userFactory;
        this.notesFactory = notesFactory;
        this.approvalsUtil = approvalsUtil;
        this.patchListCache = patchListCache;
        this.notesMigration = notesMigration;
        this.legacyId = c.getId();
        this.change = c;
    }

    @AssistedInject
    private ChangeData(GitRepositoryManager repoManager, ChangeControl.GenericFactory changeControlFactory, IdentifiedUser.GenericFactory userFactory, ChangeNotes.Factory notesFactory, ApprovalsUtil approvalsUtil, PatchListCache patchListCache, NotesMigration notesMigration, @Assisted ReviewDb db, @Assisted ChangeControl c) {
        this.db = db;
        this.repoManager = repoManager;
        this.changeControlFactory = changeControlFactory;
        this.userFactory = userFactory;
        this.notesFactory = notesFactory;
        this.approvalsUtil = approvalsUtil;
        this.patchListCache = patchListCache;
        this.notesMigration = notesMigration;
        this.legacyId = c.getChange().getId();
        this.change = c.getChange();
        this.changeControl = c;
        this.notes = c.getNotes();
    }

    public boolean isFromSource(ChangeDataSource s) {
        return s == this.returnedBySource;
    }

    public void cacheFromSource(ChangeDataSource s) {
        this.returnedBySource = s;
    }

    public void setCurrentFilePaths(List<String> filePaths) {
        this.currentFiles = ImmutableList.copyOf(filePaths);
    }

    public List<String> currentFilePaths() throws OrmException {
        if (this.currentFiles == null) {
            PatchList p;
            Change c = this.change();
            if (c == null) {
                return null;
            }
            PatchSet ps = this.currentPatchSet();
            if (ps == null) {
                return null;
            }
            try {
                p = this.patchListCache.get(c, ps);
            }
            catch (PatchListNotAvailableException e) {
                this.currentFiles = Collections.emptyList();
                return this.currentFiles;
            }
            ArrayList<String> r = new ArrayList<String>(p.getPatches().size());
            for (PatchListEntry e : p.getPatches()) {
                if ("/COMMIT_MSG".equals(e.getNewName())) continue;
                switch (e.getChangeType()) {
                    case ADDED: 
                    case MODIFIED: 
                    case DELETED: 
                    case COPIED: 
                    case REWRITE: {
                        r.add(e.getNewName());
                        break;
                    }
                    case RENAMED: {
                        r.add(e.getOldName());
                        r.add(e.getNewName());
                    }
                }
            }
            Collections.sort(r);
            this.currentFiles = Collections.unmodifiableList(r);
        }
        return this.currentFiles;
    }

    public ChangedLines changedLines() throws OrmException {
        if (this.changedLines == null) {
            PatchList p;
            Change c = this.change();
            if (c == null) {
                return null;
            }
            PatchSet ps = this.currentPatchSet();
            if (ps == null) {
                return null;
            }
            try {
                p = this.patchListCache.get(c, ps);
            }
            catch (PatchListNotAvailableException e) {
                return null;
            }
            this.changedLines = new ChangedLines(p.getInsertions(), p.getDeletions());
        }
        return this.changedLines;
    }

    public Change.Id getId() {
        return this.legacyId;
    }

    boolean fastIsVisibleTo(CurrentUser user) {
        return this.visibleTo == user;
    }

    public boolean hasChangeControl() {
        return this.changeControl != null;
    }

    public ChangeControl changeControl() throws NoSuchChangeException, OrmException {
        if (this.changeControl == null) {
            Change c = this.change();
            this.changeControl = this.changeControlFactory.controlFor(c, (CurrentUser)this.userFactory.create(c.getOwner()));
        }
        return this.changeControl;
    }

    void cacheVisibleTo(ChangeControl ctl) {
        this.visibleTo = ctl.getCurrentUser();
        this.changeControl = ctl;
    }

    public Change change() throws OrmException {
        if (this.change == null) {
            this.change = this.db.changes().get(this.legacyId);
        }
        return this.change;
    }

    public ChangeNotes notes() throws OrmException {
        if (this.notes == null) {
            this.notes = this.notesFactory.create(this.change());
        }
        return this.notes;
    }

    public PatchSet currentPatchSet() throws OrmException {
        if (this.currentPatchSet == null) {
            Change c = this.change();
            if (c == null) {
                return null;
            }
            for (PatchSet p : this.patches()) {
                if (!p.getId().equals(c.currentPatchSetId())) continue;
                this.currentPatchSet = p;
                return p;
            }
        }
        return this.currentPatchSet;
    }

    public List<PatchSetApproval> currentApprovals() throws OrmException {
        if (this.currentApprovals == null) {
            Change c = this.change();
            if (c == null) {
                this.currentApprovals = Collections.emptyList();
            } else {
                if (this.allApprovals != null) {
                    return this.allApprovals.get(c.currentPatchSetId());
                }
                this.currentApprovals = this.approvalsUtil.byPatchSet(this.db, this.notes(), c.currentPatchSetId());
            }
        }
        return this.currentApprovals;
    }

    public void setCurrentApprovals(List<PatchSetApproval> approvals) {
        this.currentApprovals = approvals;
    }

    public String commitMessage() throws NoSuchChangeException, IOException, OrmException {
        if (this.commitMessage == null) {
            this.loadCommitData();
        }
        return this.commitMessage;
    }

    public List<FooterLine> commitFooters() throws NoSuchChangeException, IOException, OrmException {
        if (this.commitFooters == null) {
            this.loadCommitData();
        }
        return this.commitFooters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCommitData() throws NoSuchChangeException, OrmException, RepositoryNotFoundException, IOException, MissingObjectException, IncorrectObjectTypeException {
        PatchSet.Id psId = this.change().currentPatchSetId();
        PatchSet ps = this.db.patchSets().get(psId);
        if (ps == null) {
            throw new NoSuchChangeException(this.legacyId);
        }
        String sha1 = ps.getRevision().get();
        try (Repository repo = this.repoManager.openRepository(this.change().getProject());
             RevWalk walk = new RevWalk(repo);){
            RevCommit c = walk.parseCommit(ObjectId.fromString(sha1));
            this.commitMessage = c.getFullMessage();
            this.commitFooters = c.getFooterLines();
        }
    }

    public Collection<PatchSet> patches() throws OrmException {
        if (this.patches == null) {
            this.patches = this.db.patchSets().byChange(this.legacyId).toList();
        }
        return this.patches;
    }

    public PatchSet patch(PatchSet.Id psId) throws OrmException {
        if (this.currentPatchSet != null && this.currentPatchSet.getId().equals(psId)) {
            return this.currentPatchSet;
        }
        for (PatchSet ps : this.patches()) {
            if (!ps.getId().equals(psId)) continue;
            return ps;
        }
        return null;
    }

    public ListMultimap<PatchSet.Id, PatchSetApproval> approvals() throws OrmException {
        if (this.allApprovals == null) {
            this.allApprovals = this.approvalsUtil.byChange(this.db, this.notes());
        }
        return this.allApprovals;
    }

    public SetMultimap<ReviewerState, Account.Id> reviewers() throws OrmException {
        return this.approvalsUtil.getReviewers(this.notes(), this.approvals().values());
    }

    public Collection<PatchLineComment> comments() throws OrmException {
        if (this.comments == null) {
            this.comments = this.db.patchComments().byChange(this.legacyId).toList();
        }
        return this.comments;
    }

    public List<ChangeMessage> messages() throws OrmException {
        if (this.messages == null) {
            this.messages = this.db.changeMessages().byChange(this.legacyId).toList();
        }
        return this.messages;
    }

    public void setSubmitRecords(List<SubmitRecord> records) {
        this.submitRecords = records;
    }

    public List<SubmitRecord> getSubmitRecords() {
        return this.submitRecords;
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(this.getId()).toString();
    }

    public static class ChangedLines {
        public final int insertions;
        public final int deletions;

        ChangedLines(int insertions, int deletions) {
            this.insertions = insertions;
            this.deletions = deletions;
        }
    }

    public static interface Factory {
        public ChangeData create(ReviewDb var1, Change.Id var2);

        public ChangeData create(ReviewDb var1, Change var2);

        public ChangeData create(ReviewDb var1, ChangeControl var2);
    }
}

