/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.RegexPredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.Collections;
import java.util.List;

class RegexPathPredicate
extends RegexPredicate<ChangeData> {
    private final RunAutomaton pattern;
    private final String prefixBegin;
    private final String prefixEnd;
    private final int prefixLen;
    private final boolean prefixOnly;

    RegexPathPredicate(String fieldName, String re) {
        super(ChangeField.PATH, re);
        if (re.startsWith("^")) {
            re = re.substring(1);
        }
        if (re.endsWith("$") && !re.endsWith("\\$")) {
            re = re.substring(0, re.length() - 1);
        }
        Automaton automaton = new RegExp(re).toAutomaton();
        this.prefixBegin = automaton.getCommonPrefix();
        this.prefixLen = this.prefixBegin.length();
        if (0 < this.prefixLen) {
            char max = (char)(this.prefixBegin.charAt(this.prefixLen - 1) + '\u0001');
            this.prefixEnd = this.prefixBegin.substring(0, this.prefixLen - 1) + max;
            this.prefixOnly = re.equals(this.prefixBegin + ".*");
        } else {
            this.prefixEnd = "";
            this.prefixOnly = false;
        }
        this.pattern = this.prefixOnly ? null : new RunAutomaton(automaton);
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        List<String> files = object.currentFilePaths();
        if (files != null) {
            int end;
            int begin;
            if (0 < this.prefixLen) {
                begin = RegexPathPredicate.find(files, this.prefixBegin);
                end = RegexPathPredicate.find(files, this.prefixEnd);
            } else {
                begin = 0;
                end = files.size();
            }
            if (this.prefixOnly) {
                return begin < end;
            }
            while (begin < end) {
                if (!this.pattern.run(files.get(begin++))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static int find(List<String> files, String p) {
        int r = Collections.binarySearch(files, p);
        return r < 0 ? -(r + 1) : r;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

