/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.query.OperatorPredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;
import java.io.IOException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RevWalkPredicate
extends OperatorPredicate<ChangeData> {
    private static final Logger log = LoggerFactory.getLogger(RevWalkPredicate.class);
    public final Provider<ReviewDb> db;
    public final GitRepositoryManager repoManager;

    public RevWalkPredicate(Provider<ReviewDb> db, GitRepositoryManager repoManager, String operator, String ref) {
        super(operator, ref);
        this.db = db;
        this.repoManager = repoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean match(ChangeData object) throws OrmException {
        PatchSet patchSet = object.currentPatchSet();
        if (patchSet == null) {
            return false;
        }
        RevId revision = patchSet.getRevision();
        if (revision == null) {
            return false;
        }
        ObjectId objectId = ObjectId.fromString(revision.get());
        if (objectId == null) {
            return false;
        }
        Change change = object.change();
        if (change == null) {
            return false;
        }
        Project.NameKey projectName = change.getProject();
        if (projectName == null) {
            return false;
        }
        Arguments args = new Arguments(patchSet, revision, objectId, change, projectName);
        try (Repository repo = this.repoManager.openRepository(projectName);){
            RevWalk rw = new RevWalk(repo);
            try {
                boolean bl = this.match(repo, rw, args);
                rw.close();
                return bl;
            }
            catch (Throwable throwable) {
                rw.close();
                throw throwable;
            }
        }
        catch (RepositoryNotFoundException e) {
            log.error("Repository \"" + projectName.get() + "\" unknown.", e);
        }
        catch (IOException e) {
            log.error(projectName.get() + " cannot be read as a repository", e);
        }
        return false;
    }

    public abstract boolean match(Repository var1, RevWalk var2, Arguments var3);

    public static class Arguments {
        public final PatchSet patchSet;
        public final RevId revision;
        public final AnyObjectId objectId;
        public final Change change;
        public final Project.NameKey projectName;

        public Arguments(PatchSet patchSet, RevId revision, AnyObjectId objectId, Change change, Project.NameKey projectName) {
            this.patchSet = patchSet;
            this.revision = revision;
            this.objectId = objectId;
            this.change = change;
            this.projectName = projectName;
        }
    }
}

