/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.cache.Cache;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.commands.CacheCommand;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="flushCaches")
@CommandMetaData(name="flush-caches", description="Flush some/all server caches from memory", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class FlushCaches
extends CacheCommand {
    private static final String WEB_SESSIONS = "web_sessions";
    @Option(name="--cache", usage="flush named cache", metaVar="NAME")
    private List<String> caches = new ArrayList<String>();
    @Option(name="--all", usage="flush all caches")
    private boolean all;
    @Option(name="--list", usage="list available caches")
    private boolean list;
    @Inject
    IdentifiedUser currentUser;

    FlushCaches() {
    }

    @Override
    protected void run() throws BaseCommand.Failure {
        if (this.caches.contains(WEB_SESSIONS) && !this.currentUser.getCapabilities().canAdministrateServer()) {
            String msg = String.format("fatal: only site administrators can flush %s", WEB_SESSIONS);
            throw new BaseCommand.UnloggedFailure(0x40000003, msg);
        }
        if (this.list) {
            if (this.all || this.caches.size() > 0) {
                throw FlushCaches.error("error: cannot use --list with --all or --cache");
            }
            this.doList();
            return;
        }
        if (this.all && this.caches.size() > 0) {
            throw FlushCaches.error("error: cannot combine --all and --cache");
        }
        if (!this.all && this.caches.size() == 1 && this.caches.contains("all")) {
            this.caches.clear();
            this.all = true;
        } else if (!this.all && this.caches.isEmpty()) {
            this.all = true;
        }
        SortedSet<String> names = this.cacheNames();
        for (String n : this.caches) {
            if (names.contains(n)) continue;
            throw FlushCaches.error("error: cache \"" + n + "\" not recognized");
        }
        this.doBulkFlush();
    }

    private static BaseCommand.UnloggedFailure error(String msg) {
        return new BaseCommand.UnloggedFailure(1, msg);
    }

    private void doList() {
        for (String name : this.cacheNames()) {
            this.stderr.print(name);
            this.stderr.print('\n');
        }
        this.stderr.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBulkFlush() {
        try {
            for (DynamicMap.Entry e : this.cacheMap) {
                String n = this.cacheNameOf(e.getPluginName(), e.getExportName());
                if (!this.flush(n)) continue;
                try {
                    ((Cache)e.getProvider().get()).invalidateAll();
                }
                catch (Throwable err) {
                    this.stderr.println("error: cannot flush cache \"" + n + "\": " + err);
                }
            }
        }
        finally {
            this.stderr.flush();
        }
    }

    private boolean flush(String cacheName) {
        if (this.caches.contains(cacheName)) {
            return true;
        }
        if (this.all) {
            return !WEB_SESSIONS.equals(cacheName);
        }
        return false;
    }
}

