/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.server.plugins.PluginInstallException;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="administrateServer")
@CommandMetaData(name="install", description="Install/Add a plugin", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class PluginInstallCommand
extends SshCommand {
    @Option(name="--name", aliases={"-n"}, usage="install under name")
    private String name;
    @Argument(index=0, metaVar="-|URL", usage="JAR to load")
    private String source;
    @Inject
    private PluginLoader loader;

    PluginInstallCommand() {
    }

    @Option(name="-")
    void useInput(boolean on) {
        this.source = "-";
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        InputStream data;
        if (!this.loader.isRemoteAdminEnabled()) {
            throw this.die("remote installation is disabled");
        }
        if (Strings.isNullOrEmpty(this.source)) {
            throw this.die("Argument \"-|URL\" is required");
        }
        if (Strings.isNullOrEmpty(this.name) && "-".equalsIgnoreCase(this.source)) {
            throw this.die("--name required when source is stdin");
        }
        if (Strings.isNullOrEmpty(this.name)) {
            int s = this.source.lastIndexOf(47);
            this.name = 0 <= s ? this.source.substring(s + 1) : this.source;
        }
        if ("-".equalsIgnoreCase(this.source)) {
            data = this.in;
        } else {
            if (new File(this.source).isFile() && this.source.equals(new File(this.source).getAbsolutePath())) {
                try {
                    data = new FileInputStream(new File(this.source));
                }
                catch (FileNotFoundException e) {
                    throw this.die("cannot read " + this.source);
                }
            }
            try {
                data = new URL(this.source).openStream();
            }
            catch (MalformedURLException e) {
                throw this.die("invalid url " + this.source);
            }
            catch (IOException e) {
                throw this.die("cannot read " + this.source);
            }
        }
        try {
            this.loader.installPluginFromStream(this.name, data);
        }
        catch (IOException e) {
            throw this.die("cannot install plugin");
        }
        catch (PluginInstallException e) {
            e.printStackTrace(this.stderr);
            String msg = String.format("Plugin failed to install. Cause: %s", e.getMessage());
            throw this.die(msg);
        }
        finally {
            try {
                data.close();
            }
            catch (IOException iOException) {}
        }
    }
}

