/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.nativefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.file.nativefs.NativeFileSystemView;
import org.apache.sshd.common.file.nativefs.NativeSshFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeSshFileNio
extends NativeSshFile {
    public NativeSshFileNio(NativeFileSystemView nativeFileSystemView, String fileName, File file, String userName) {
        super(nativeFileSystemView, fileName, file, userName);
    }

    @Override
    public Map<SshFile.Attribute, Object> getAttributes(boolean followLinks) throws IOException {
        LinkOption[] linkOptionArray;
        Path path = this.file.toPath();
        if (followLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        Map<String, Object> a = Files.readAttributes(path, "unix:size,uid,owner,gid,group,isDirectory,isRegularFile,isSymbolicLink,permissions,creationTime,lastModifiedTime,lastAccessTime", linkOptionArray);
        HashMap<SshFile.Attribute, Object> map = new HashMap<SshFile.Attribute, Object>();
        map.put(SshFile.Attribute.Size, a.get("size"));
        map.put(SshFile.Attribute.Uid, a.get("uid"));
        map.put(SshFile.Attribute.Owner, ((UserPrincipal)a.get("owner")).getName());
        map.put(SshFile.Attribute.Gid, a.get("gid"));
        map.put(SshFile.Attribute.Group, ((GroupPrincipal)a.get("group")).getName());
        map.put(SshFile.Attribute.IsDirectory, a.get("isDirectory"));
        map.put(SshFile.Attribute.IsRegularFile, a.get("isRegularFile"));
        map.put(SshFile.Attribute.IsSymbolicLink, a.get("isSymbolicLink"));
        map.put(SshFile.Attribute.CreationTime, ((FileTime)a.get("creationTime")).toMillis());
        map.put(SshFile.Attribute.LastModifiedTime, ((FileTime)a.get("lastModifiedTime")).toMillis());
        map.put(SshFile.Attribute.LastAccessTime, ((FileTime)a.get("lastAccessTime")).toMillis());
        map.put(SshFile.Attribute.Permissions, this.fromPerms((Set)a.get("permissions")));
        return map;
    }

    @Override
    public void setAttributes(Map<SshFile.Attribute, Object> attributes) throws IOException {
        block11: for (SshFile.Attribute attribute : attributes.keySet()) {
            String name = null;
            Object value = attributes.get((Object)attribute);
            switch (attribute) {
                case Size: {
                    long newSize = (Long)value;
                    FileChannel outChan = new FileOutputStream(this.file, true).getChannel();
                    outChan.truncate(newSize);
                    outChan.close();
                    continue block11;
                }
                case Uid: {
                    name = "unix:uid";
                    break;
                }
                case Owner: {
                    name = "unix:owner";
                    value = this.toUser((String)value);
                    break;
                }
                case Gid: {
                    name = "unix:gid";
                    break;
                }
                case Group: {
                    name = "unix:group";
                    value = this.toGroup((String)value);
                    break;
                }
                case Permissions: {
                    name = "unix:permissions";
                    value = this.toPerms((EnumSet)value);
                    break;
                }
                case CreationTime: {
                    name = "unix:creationTime";
                    value = FileTime.fromMillis((Long)value);
                    break;
                }
                case LastModifiedTime: {
                    name = "unix:lastModifiedTime";
                    value = FileTime.fromMillis((Long)value);
                    break;
                }
                case LastAccessTime: {
                    name = "unix:lastAccessTime";
                    value = FileTime.fromMillis((Long)value);
                }
            }
            if (name == null || value == null) continue;
            Files.setAttribute(this.file.toPath(), name, value, LinkOption.NOFOLLOW_LINKS);
        }
    }

    @Override
    public String readSymbolicLink() throws IOException {
        Path path = this.file.toPath();
        Path link = Files.readSymbolicLink(path);
        return link.toString();
    }

    private EnumSet<SshFile.Permission> fromPerms(Set<PosixFilePermission> perms) {
        EnumSet<SshFile.Permission> p = EnumSet.noneOf(SshFile.Permission.class);
        for (PosixFilePermission perm : perms) {
            switch (perm) {
                case OWNER_READ: {
                    p.add(SshFile.Permission.UserRead);
                    break;
                }
                case OWNER_WRITE: {
                    p.add(SshFile.Permission.UserWrite);
                    break;
                }
                case OWNER_EXECUTE: {
                    p.add(SshFile.Permission.UserExecute);
                    break;
                }
                case GROUP_READ: {
                    p.add(SshFile.Permission.GroupRead);
                    break;
                }
                case GROUP_WRITE: {
                    p.add(SshFile.Permission.GroupWrite);
                    break;
                }
                case GROUP_EXECUTE: {
                    p.add(SshFile.Permission.GroupExecute);
                    break;
                }
                case OTHERS_READ: {
                    p.add(SshFile.Permission.OthersRead);
                    break;
                }
                case OTHERS_WRITE: {
                    p.add(SshFile.Permission.OthersWrite);
                    break;
                }
                case OTHERS_EXECUTE: {
                    p.add(SshFile.Permission.OthersExecute);
                }
            }
        }
        return p;
    }

    private GroupPrincipal toGroup(String name) throws IOException {
        UserPrincipalLookupService lookupService = this.file.toPath().getFileSystem().getUserPrincipalLookupService();
        return lookupService.lookupPrincipalByGroupName(name);
    }

    private UserPrincipal toUser(String name) throws IOException {
        UserPrincipalLookupService lookupService = this.file.toPath().getFileSystem().getUserPrincipalLookupService();
        return lookupService.lookupPrincipalByName(name);
    }

    private Set<PosixFilePermission> toPerms(EnumSet<SshFile.Permission> perms) {
        HashSet<PosixFilePermission> set = new HashSet<PosixFilePermission>();
        for (SshFile.Permission p : perms) {
            switch (p) {
                case UserRead: {
                    set.add(PosixFilePermission.OWNER_READ);
                    break;
                }
                case UserWrite: {
                    set.add(PosixFilePermission.OWNER_WRITE);
                    break;
                }
                case UserExecute: {
                    set.add(PosixFilePermission.OWNER_EXECUTE);
                    break;
                }
                case GroupRead: {
                    set.add(PosixFilePermission.GROUP_READ);
                    break;
                }
                case GroupWrite: {
                    set.add(PosixFilePermission.GROUP_WRITE);
                    break;
                }
                case GroupExecute: {
                    set.add(PosixFilePermission.GROUP_EXECUTE);
                    break;
                }
                case OthersRead: {
                    set.add(PosixFilePermission.OTHERS_READ);
                    break;
                }
                case OthersWrite: {
                    set.add(PosixFilePermission.OTHERS_WRITE);
                    break;
                }
                case OthersExecute: {
                    set.add(PosixFilePermission.OTHERS_EXECUTE);
                }
            }
        }
        return set;
    }
}

