/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.PermissionRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GlobalCapability {
    public static final String ACCESS_DATABASE = "accessDatabase";
    public static final String ADMINISTRATE_SERVER = "administrateServer";
    public static final String CREATE_ACCOUNT = "createAccount";
    public static final String CREATE_GROUP = "createGroup";
    public static final String CREATE_PROJECT = "createProject";
    public static final String EMAIL_REVIEWERS = "emailReviewers";
    public static final String FLUSH_CACHES = "flushCaches";
    public static final String GENERATE_HTTP_PASSWORD = "generateHttpPassword";
    public static final String KILL_TASK = "killTask";
    public static final String PRIORITY = "priority";
    public static final String QUERY_LIMIT = "queryLimit";
    public static final String RUN_AS = "runAs";
    public static final String RUN_GC = "runGC";
    public static final String STREAM_EVENTS = "streamEvents";
    public static final String VIEW_ALL_ACCOUNTS = "viewAllAccounts";
    public static final String VIEW_CACHES = "viewCaches";
    public static final String VIEW_CONNECTIONS = "viewConnections";
    public static final String VIEW_PLUGINS = "viewPlugins";
    public static final String VIEW_QUEUE = "viewQueue";
    private static final List<String> NAMES_ALL = new ArrayList<String>();
    private static final List<String> NAMES_LC;

    public static Collection<String> getAllNames() {
        return Collections.unmodifiableList(NAMES_ALL);
    }

    public static boolean isCapability(String varName) {
        return NAMES_LC.contains(varName.toLowerCase());
    }

    public static boolean hasRange(String varName) {
        return QUERY_LIMIT.equalsIgnoreCase(varName);
    }

    public static PermissionRange.WithDefaults getRange(String varName) {
        if (QUERY_LIMIT.equalsIgnoreCase(varName)) {
            return new PermissionRange.WithDefaults(varName, 0, Integer.MAX_VALUE, 0, 500);
        }
        return null;
    }

    private GlobalCapability() {
    }

    static {
        NAMES_ALL.add(ACCESS_DATABASE);
        NAMES_ALL.add(ADMINISTRATE_SERVER);
        NAMES_ALL.add(CREATE_ACCOUNT);
        NAMES_ALL.add(CREATE_GROUP);
        NAMES_ALL.add(CREATE_PROJECT);
        NAMES_ALL.add(EMAIL_REVIEWERS);
        NAMES_ALL.add(FLUSH_CACHES);
        NAMES_ALL.add(KILL_TASK);
        NAMES_ALL.add(PRIORITY);
        NAMES_ALL.add(QUERY_LIMIT);
        NAMES_ALL.add(RUN_AS);
        NAMES_ALL.add(RUN_GC);
        NAMES_ALL.add(STREAM_EVENTS);
        NAMES_ALL.add(VIEW_ALL_ACCOUNTS);
        NAMES_ALL.add(VIEW_CACHES);
        NAMES_ALL.add(VIEW_CONNECTIONS);
        NAMES_ALL.add(VIEW_PLUGINS);
        NAMES_ALL.add(VIEW_QUEUE);
        NAMES_LC = new ArrayList<String>(NAMES_ALL.size());
        for (String name : NAMES_ALL) {
            NAMES_LC.add(name.toLowerCase());
        }
    }
}

