/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.auth.container;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.gwtjsonrpc.server.RPCServletUtils;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.util.Base64;

@Singleton
class HttpAuthFilter
implements Filter {
    private final Provider<WebSession> sessionProvider;
    private final byte[] signInRaw;
    private final byte[] signInGzip;
    private final String loginHeader;
    private final String displaynameHeader;
    private final String emailHeader;

    @Inject
    HttpAuthFilter(Provider<WebSession> webSession, AuthConfig authConfig) throws IOException {
        this.sessionProvider = webSession;
        String pageName = "LoginRedirect.html";
        String doc = HtmlDomUtil.readFile(this.getClass(), "LoginRedirect.html");
        if (doc == null) {
            throw new FileNotFoundException("No LoginRedirect.html in webapp");
        }
        this.signInRaw = doc.getBytes("UTF-8");
        this.signInGzip = HtmlDomUtil.compress(this.signInRaw);
        this.loginHeader = Objects.firstNonNull(Strings.emptyToNull(authConfig.getLoginHttpHeader()), "Authorization");
        this.displaynameHeader = Strings.emptyToNull(authConfig.getHttpDisplaynameHeader());
        this.emailHeader = Strings.emptyToNull(authConfig.getHttpEmailHeader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isSessionValid((HttpServletRequest)request)) {
            chain.doFilter(request, response);
        } else {
            byte[] tosend;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse rsp = (HttpServletResponse)response;
            if (RPCServletUtils.acceptsGzipEncoding(req)) {
                rsp.setHeader("Content-Encoding", "gzip");
                tosend = this.signInGzip;
            } else {
                tosend = this.signInRaw;
            }
            CacheHeaders.setNotCacheable(rsp);
            rsp.setContentType("text/html");
            rsp.setCharacterEncoding("UTF-8");
            rsp.setContentLength(tosend.length);
            try (ServletOutputStream out = rsp.getOutputStream();){
                out.write(tosend);
            }
        }
    }

    private boolean isSessionValid(HttpServletRequest req) {
        WebSession session = this.sessionProvider.get();
        if (session.isSignedIn()) {
            String user = this.getRemoteUser(req);
            return user == null || HttpAuthFilter.correctUser(user, session);
        }
        return false;
    }

    private static boolean correctUser(String user, WebSession session) {
        AccountExternalId.Key id = session.getLastLoginExternalId();
        return id != null && id.equals(new AccountExternalId.Key("gerrit:", user));
    }

    String getRemoteUser(HttpServletRequest req) {
        if ("Authorization".equals(this.loginHeader)) {
            String user = Strings.emptyToNull(req.getRemoteUser());
            if (user != null) {
                return user;
            }
            String auth = Strings.emptyToNull(req.getHeader("Authorization"));
            if (auth == null) {
                return null;
            }
            if (auth.startsWith("Basic ")) {
                auth = auth.substring("Basic ".length());
                int c = (auth = new String(Base64.decode(auth))).indexOf(58);
                return c > 0 ? auth.substring(0, c) : null;
            }
            if (auth.startsWith("Digest ")) {
                int u = auth.indexOf("username=\"");
                if (u <= 0) {
                    return null;
                }
                int e = (auth = auth.substring(u + 10)).indexOf(34);
                return e > 0 ? auth.substring(0, e) : null;
            }
            return null;
        }
        return Strings.emptyToNull(req.getHeader(this.loginHeader));
    }

    String getRemoteDisplayname(HttpServletRequest req) {
        if (this.displaynameHeader != null) {
            return Strings.emptyToNull(req.getHeader(this.displaynameHeader));
        }
        return null;
    }

    String getRemoteEmail(HttpServletRequest req) {
        if (this.emailHeader != null) {
            return Strings.emptyToNull(req.getHeader(this.emailHeader));
        }
        return null;
    }

    String getLoginHeader() {
        return this.loginHeader;
    }

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void destroy() {
    }
}

