/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.server.api.changes.ChangeApiImpl;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;

class ChangesImpl
implements Changes {
    private final ChangesCollection changes;
    private final ChangeApiImpl.Factory api;

    @Inject
    ChangesImpl(ChangesCollection changes, ChangeApiImpl.Factory api) {
        this.changes = changes;
        this.api = api;
    }

    @Override
    public ChangeApi id(int id) throws RestApiException {
        return this.id(String.valueOf(id));
    }

    @Override
    public ChangeApi id(String project, String branch, String id) throws RestApiException {
        return this.id(Joiner.on('~').join(ImmutableList.of(Url.encode(project), Url.encode(branch), Url.encode(id))));
    }

    @Override
    public ChangeApi id(String id) throws RestApiException {
        try {
            return this.api.create(this.changes.parse(TopLevelResource.INSTANCE, IdString.fromUrl(id)));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot parse change", e);
        }
    }
}

