/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth.ldap;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gerrit.common.data.ParameterizedString;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AuthType;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.EmailExpander;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.auth.AuthenticationUnavailableException;
import com.google.gerrit.server.auth.ldap.Helper;
import com.google.gerrit.server.auth.ldap.LdapQuery;
import com.google.gerrit.server.auth.ldap.SearchScope;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LdapRealm
implements Realm {
    static final Logger log = LoggerFactory.getLogger(LdapRealm.class);
    static final String LDAP = "com.sun.jndi.ldap.LdapCtxFactory";
    static final String USERNAME = "username";
    private final Helper helper;
    private final AuthConfig authConfig;
    private final EmailExpander emailExpander;
    private final LoadingCache<String, Optional<Account.Id>> usernameCache;
    private final Set<Account.FieldName> readOnlyAccountFields;
    private final Config config;
    private final LoadingCache<String, Set<AccountGroup.UUID>> membershipCache;

    @Inject
    LdapRealm(Helper helper, AuthConfig authConfig, EmailExpander emailExpander, @Named(value="ldap_groups") LoadingCache<String, Set<AccountGroup.UUID>> membershipCache, @Named(value="ldap_usernames") LoadingCache<String, Optional<Account.Id>> usernameCache, @GerritServerConfig Config config) {
        this.helper = helper;
        this.authConfig = authConfig;
        this.emailExpander = emailExpander;
        this.usernameCache = usernameCache;
        this.membershipCache = membershipCache;
        this.config = config;
        this.readOnlyAccountFields = new HashSet<Account.FieldName>();
        if (LdapRealm.optdef(config, "accountFullName", "DEFAULT") != null) {
            this.readOnlyAccountFields.add(Account.FieldName.FULL_NAME);
        }
        if (LdapRealm.optdef(config, "accountSshUserName", "DEFAULT") != null) {
            this.readOnlyAccountFields.add(Account.FieldName.USER_NAME);
        }
    }

    static SearchScope scope(Config c, String setting) {
        return ConfigUtil.getEnum(c, "ldap", null, setting, SearchScope.SUBTREE);
    }

    static String optional(Config config, String name) {
        return config.getString("ldap", null, name);
    }

    static String required(Config config, String name) {
        String v = LdapRealm.optional(config, name);
        if (v == null || "".equals(v)) {
            throw new IllegalArgumentException("No ldap." + name + " configured");
        }
        return v;
    }

    static List<String> optionalList(Config config, String name) {
        String[] s = config.getStringList("ldap", null, name);
        return Arrays.asList(s);
    }

    static List<String> requiredList(Config config, String name) {
        List<String> vlist = LdapRealm.optionalList(config, name);
        if (vlist.isEmpty()) {
            throw new IllegalArgumentException("No ldap " + name + " configured");
        }
        return vlist;
    }

    static String optdef(Config c, String n, String d) {
        String[] v = c.getStringList("ldap", null, n);
        if (v == null || v.length == 0) {
            return d;
        }
        if (v[0] == null || "".equals(v[0])) {
            return null;
        }
        return v[0];
    }

    static String reqdef(Config c, String n, String d) {
        String v = LdapRealm.optdef(c, n, d);
        if (v == null) {
            throw new IllegalArgumentException("No ldap." + n + " configured");
        }
        return v;
    }

    static ParameterizedString paramString(Config c, String n, String d) {
        String expression = LdapRealm.optdef(c, n, d);
        if (expression == null) {
            return null;
        }
        if (expression.contains("${")) {
            return new ParameterizedString(expression);
        }
        return new ParameterizedString("${" + expression + "}");
    }

    @Override
    public boolean allowsEdit(Account.FieldName field) {
        return !this.readOnlyAccountFields.contains((Object)field);
    }

    static String apply(ParameterizedString p, LdapQuery.Result m) throws NamingException {
        if (p == null) {
            return null;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        for (String name : m.attributes()) {
            values.put(name, m.get(name));
        }
        String r = p.replace(values);
        return r.isEmpty() ? null : r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthRequest authenticate(AuthRequest who) throws AccountException {
        AuthRequest authRequest;
        if (this.config.getBoolean("ldap", "localUsernameToLowerCase", false)) {
            who.setLocalUser(who.getLocalUser().toLowerCase(Locale.US));
        }
        String username = who.getLocalUser();
        DirContext ctx = this.authConfig.getAuthType() == AuthType.LDAP_BIND ? this.helper.authenticate(username, who.getPassword()) : this.helper.open();
        try {
            Helper.LdapSchema schema = this.helper.getSchema(ctx);
            LdapQuery.Result m = this.helper.findAccount(schema, ctx, username);
            if (this.authConfig.getAuthType() == AuthType.LDAP && !who.isSkipAuthentication()) {
                this.helper.authenticate(m.getDN(), who.getPassword());
            }
            who.setDisplayName(LdapRealm.apply(schema.accountFullName, m));
            who.setUserName(LdapRealm.apply(schema.accountSshUserName, m));
            if (schema.accountEmailAddress != null) {
                who.setEmailAddress(LdapRealm.apply(schema.accountEmailAddress, m));
            } else if (this.emailExpander.canExpand(username)) {
                who.setEmailAddress(this.emailExpander.expand(username));
            }
            this.membershipCache.put(username, this.helper.queryForGroups(ctx, username, m));
            authRequest = who;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    log.warn("Cannot close LDAP query handle", e);
                }
                throw throwable;
            }
            catch (NamingException e) {
                log.error("Cannot query LDAP to authenticate user", e);
                throw new AuthenticationUnavailableException("Cannot query LDAP for account", e);
            }
            catch (LoginException e) {
                log.error("Cannot authenticate server via JAAS", e);
                throw new AuthenticationUnavailableException("Cannot query LDAP for account", e);
            }
        }
        try {
            ctx.close();
        }
        catch (NamingException e) {
            log.warn("Cannot close LDAP query handle", e);
        }
        return authRequest;
    }

    @Override
    public AuthRequest link(ReviewDb db, Account.Id to, AuthRequest who) {
        return who;
    }

    @Override
    public AuthRequest unlink(ReviewDb db, Account.Id from, AuthRequest who) {
        return who;
    }

    @Override
    public void onCreateAccount(AuthRequest who, Account account) {
        this.usernameCache.put(who.getLocalUser(), Optional.of(account.getId()));
    }

    @Override
    public Account.Id lookup(String accountName) {
        if (Strings.isNullOrEmpty(accountName)) {
            return null;
        }
        try {
            Optional<Account.Id> id = this.usernameCache.get(accountName);
            return id != null ? id.orNull() : null;
        }
        catch (ExecutionException e) {
            log.warn(String.format("Cannot lookup account %s in LDAP", accountName), e);
            return null;
        }
    }

    static class ExistenceLoader
    extends CacheLoader<String, Boolean> {
        private final Helper helper;

        @Inject
        ExistenceLoader(Helper helper) {
            this.helper = helper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean load(String groupDn) throws Exception {
            DirContext ctx = this.helper.open();
            try {
                Name compositeGroupName = new CompositeName().add(groupDn);
                try {
                    ctx.getAttributes(compositeGroupName);
                    Boolean bl = true;
                    return bl;
                }
                catch (NamingException e) {
                    Boolean bl = false;
                    try {
                        ctx.close();
                    }
                    catch (NamingException e2) {
                        log.warn("Cannot close LDAP query handle", e2);
                    }
                    return bl;
                }
            }
            finally {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    log.warn("Cannot close LDAP query handle", e);
                }
            }
        }
    }

    static class MemberLoader
    extends CacheLoader<String, Set<AccountGroup.UUID>> {
        private final Helper helper;

        @Inject
        MemberLoader(Helper helper) {
            this.helper = helper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<AccountGroup.UUID> load(String username) throws Exception {
            DirContext ctx = this.helper.open();
            try {
                Set<AccountGroup.UUID> set = this.helper.queryForGroups(ctx, username, null);
                return set;
            }
            finally {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    log.warn("Cannot close LDAP query handle", e);
                }
            }
        }
    }

    static class UserLoader
    extends CacheLoader<String, Optional<Account.Id>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        UserLoader(SchemaFactory<ReviewDb> schema) {
            this.schema = schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Account.Id> load(String username) throws Exception {
            try (ReviewDb db = this.schema.open();){
                AccountExternalId extId = db.accountExternalIds().get(new AccountExternalId.Key("gerrit:", username));
                if (extId != null) {
                    Optional<Account.Id> optional = Optional.of(extId.getAccountId());
                    return optional;
                }
                Optional<Account.Id> optional = Optional.absent();
                return optional;
            }
        }
    }
}

