/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.common.FetchInfo;
import com.google.gerrit.extensions.common.GitPerson;
import com.google.gerrit.extensions.common.ListChangesOption;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.config.DownloadCommand;
import com.google.gerrit.extensions.config.DownloadScheme;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.UserIdentity;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.FileInfoJson;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Revisions;
import com.google.gerrit.server.extensions.webui.UiActions;
import com.google.gerrit.server.git.LabelNormalizer;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeJson {
    private static final Logger log = LoggerFactory.getLogger(ChangeJson.class);
    private static final ResultSet<ChangeMessage> NO_MESSAGES = new ResultSet<ChangeMessage>(){

        @Override
        public Iterator<ChangeMessage> iterator() {
            return this.toList().iterator();
        }

        @Override
        public List<ChangeMessage> toList() {
            return Collections.emptyList();
        }

        @Override
        public void close() {
        }
    };
    private final Provider<ReviewDb> db;
    private final LabelNormalizer labelNormalizer;
    private final Provider<CurrentUser> userProvider;
    private final AnonymousUser anonymous;
    private final IdentifiedUser.GenericFactory userFactory;
    private final ProjectControl.GenericFactory projectControlFactory;
    private final ChangeData.Factory changeDataFactory;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final ChangesCollection changes;
    private final FileInfoJson fileInfoJson;
    private final AccountInfo.Loader.Factory accountLoaderFactory;
    private final DynamicMap<DownloadScheme> downloadSchemes;
    private final DynamicMap<DownloadCommand> downloadCommands;
    private final DynamicMap<RestView<ChangeResource>> changeViews;
    private final Revisions revisions;
    private EnumSet<ListChangesOption> options;
    private AccountInfo.Loader accountLoader;
    private ChangeControl lastControl;
    private Set<Change.Id> reviewed;
    private LoadingCache<Project.NameKey, ProjectControl> projectControls;

    @Inject
    ChangeJson(Provider<ReviewDb> db, LabelNormalizer ln, Provider<CurrentUser> user, AnonymousUser au, IdentifiedUser.GenericFactory uf, ProjectControl.GenericFactory pcf, ChangeData.Factory cdf, PatchSetInfoFactory psi, ChangesCollection changes, FileInfoJson fileInfoJson, AccountInfo.Loader.Factory ailf, DynamicMap<DownloadScheme> downloadSchemes, DynamicMap<DownloadCommand> downloadCommands, DynamicMap<RestView<ChangeResource>> changeViews, Revisions revisions) {
        this.db = db;
        this.labelNormalizer = ln;
        this.userProvider = user;
        this.anonymous = au;
        this.userFactory = uf;
        this.projectControlFactory = pcf;
        this.changeDataFactory = cdf;
        this.patchSetInfoFactory = psi;
        this.changes = changes;
        this.fileInfoJson = fileInfoJson;
        this.accountLoaderFactory = ailf;
        this.downloadSchemes = downloadSchemes;
        this.downloadCommands = downloadCommands;
        this.changeViews = changeViews;
        this.revisions = revisions;
        this.options = EnumSet.noneOf(ListChangesOption.class);
        this.projectControls = CacheBuilder.newBuilder().concurrencyLevel(1).build(new CacheLoader<Project.NameKey, ProjectControl>(){

            @Override
            public ProjectControl load(Project.NameKey key) throws NoSuchProjectException, IOException {
                return ChangeJson.this.projectControlFactory.controlFor(key, (CurrentUser)ChangeJson.this.userProvider.get());
            }
        });
    }

    public ChangeJson addOption(ListChangesOption o) {
        this.options.add(o);
        return this;
    }

    public ChangeJson addOptions(Collection<ListChangesOption> o) {
        this.options.addAll(o);
        return this;
    }

    public ChangeInfo format(ChangeResource rsrc) throws OrmException {
        return this.format(this.changeDataFactory.create(this.db.get(), rsrc.getControl()));
    }

    public ChangeInfo format(Change change) throws OrmException {
        return this.format(this.changeDataFactory.create(this.db.get(), change));
    }

    public ChangeInfo format(Change.Id id) throws OrmException {
        return this.format(this.changeDataFactory.create(this.db.get(), id));
    }

    public ChangeInfo format(ChangeData cd) throws OrmException {
        return this.format(cd, Optional.absent());
    }

    private ChangeInfo format(ChangeData cd, Optional<PatchSet.Id> limitToPsId) throws OrmException {
        this.accountLoader = this.accountLoaderFactory.create(this.has(ListChangesOption.DETAILED_ACCOUNTS));
        if (this.has(ListChangesOption.REVIEWED)) {
            this.ensureReviewedLoaded(Collections.singleton(cd));
        }
        ChangeInfo res = this.toChangeInfo(cd, limitToPsId);
        this.accountLoader.fill();
        return res;
    }

    public ChangeInfo format(RevisionResource rsrc) throws OrmException {
        ChangeData cd = this.changeDataFactory.create(this.db.get(), rsrc.getControl());
        return this.format(cd, Optional.of(rsrc.getPatchSet().getId()));
    }

    public List<List<ChangeInfo>> formatList2(List<List<ChangeData>> in) throws OrmException {
        this.accountLoader = this.accountLoaderFactory.create(this.has(ListChangesOption.DETAILED_ACCOUNTS));
        Iterable<ChangeData> all = Iterables.concat(in);
        ChangeData.ensureChangeLoaded(all);
        if (this.has(ListChangesOption.ALL_REVISIONS)) {
            ChangeData.ensureAllPatchSetsLoaded(all);
        } else {
            ChangeData.ensureCurrentPatchSetLoaded(all);
        }
        if (this.has(ListChangesOption.REVIEWED)) {
            this.ensureReviewedLoaded(all);
        }
        ChangeData.ensureCurrentApprovalsLoaded(all);
        ArrayList<List<ChangeInfo>> res = Lists.newArrayListWithCapacity(in.size());
        HashMap<Change.Id, ChangeInfo> out = Maps.newHashMap();
        for (List<ChangeData> changes : in) {
            res.add(this.toChangeInfo(out, changes));
        }
        this.accountLoader.fill();
        return res;
    }

    private boolean has(ListChangesOption option) {
        return this.options.contains((Object)option);
    }

    private List<ChangeInfo> toChangeInfo(Map<Change.Id, ChangeInfo> out, List<ChangeData> changes) throws OrmException {
        ArrayList<ChangeInfo> info = Lists.newArrayListWithCapacity(changes.size());
        for (ChangeData cd : changes) {
            ChangeInfo i = out.get(cd.getId());
            if (i == null) {
                i = this.toChangeInfo(cd, Optional.absent());
                out.put(cd.getId(), i);
            }
            info.add(i);
        }
        return info;
    }

    private ChangeInfo toChangeInfo(ChangeData cd, Optional<PatchSet.Id> limitToPsId) throws OrmException {
        ChangeInfo out = new ChangeInfo();
        Change in = cd.change();
        out.project = in.getProject().get();
        out.branch = in.getDest().getShortName();
        out.topic = in.getTopic();
        out.changeId = in.getKey().get();
        out.mergeable = in.getStatus() != Change.Status.MERGED ? Boolean.valueOf(in.isMergeable()) : null;
        ChangeData.ChangedLines changedLines = cd.changedLines();
        if (changedLines != null) {
            out.insertions = changedLines.insertions;
            out.deletions = changedLines.deletions;
        }
        out.subject = in.getSubject();
        out.status = in.getStatus();
        out.owner = this.accountLoader.get(in.getOwner());
        out.created = in.getCreatedOn();
        out.updated = in.getLastUpdatedOn();
        out._number = in.getId().get();
        out._sortkey = in.getSortKey();
        out.starred = this.userProvider.get().getStarredChanges().contains(in.getId()) ? Boolean.valueOf(true) : null;
        out.reviewed = in.getStatus().isOpen() && this.has(ListChangesOption.REVIEWED) && this.reviewed.contains(cd.getId()) ? Boolean.valueOf(true) : null;
        out.labels = this.labelsFor(cd, this.has(ListChangesOption.LABELS), this.has(ListChangesOption.DETAILED_LABELS));
        if (out.labels != null && this.has(ListChangesOption.DETAILED_LABELS)) {
            if (!limitToPsId.isPresent() || limitToPsId.get().equals(in.currentPatchSetId())) {
                out.permittedLabels = this.permittedLabels(cd);
            }
            out.removableReviewers = this.removableReviewers(cd, out.labels.values());
        }
        if (this.has(ListChangesOption.MESSAGES)) {
            out.messages = this.messages(cd);
        }
        out.finish();
        if (this.has(ListChangesOption.ALL_REVISIONS) || this.has(ListChangesOption.CURRENT_REVISION) || limitToPsId.isPresent()) {
            out.revisions = this.revisions(cd, limitToPsId);
            if (out.revisions != null) {
                for (Map.Entry<String, RevisionInfo> entry : out.revisions.entrySet()) {
                    if (!entry.getValue().isCurrent) continue;
                    out.currentRevision = entry.getKey();
                    break;
                }
            }
        }
        if (this.has(ListChangesOption.CURRENT_ACTIONS) && this.userProvider.get().isIdentifiedUser()) {
            out.actions = Maps.newTreeMap();
            for (UiAction.Description d : UiActions.from(this.changeViews, this.changes.parse(this.control(cd)), this.userProvider)) {
                out.actions.put(d.getId(), new ActionInfo(d));
            }
        }
        this.lastControl = null;
        return out;
    }

    private ChangeControl control(ChangeData cd) throws OrmException {
        ChangeControl ctrl;
        if (this.lastControl != null && cd.getId().equals(this.lastControl.getChange().getId())) {
            return this.lastControl;
        }
        try {
            ctrl = cd.hasChangeControl() ? cd.changeControl().forUser(this.userProvider.get()) : this.projectControls.get(cd.change().getProject()).controlFor(cd.change());
        }
        catch (NoSuchChangeException | ExecutionException e) {
            throw new OrmException(e);
        }
        this.lastControl = ctrl;
        return ctrl;
    }

    private List<SubmitRecord> submitRecords(ChangeData cd) throws OrmException {
        if (cd.getSubmitRecords() != null) {
            return cd.getSubmitRecords();
        }
        ChangeControl ctl = this.control(cd);
        if (ctl == null) {
            return ImmutableList.of();
        }
        PatchSet ps = cd.currentPatchSet();
        if (ps == null) {
            return ImmutableList.of();
        }
        cd.setSubmitRecords(ctl.canSubmit(this.db.get(), ps, cd, true, false, true));
        return cd.getSubmitRecords();
    }

    private Map<String, LabelInfo> labelsFor(ChangeData cd, boolean standard, boolean detailed) throws OrmException {
        if (!standard && !detailed) {
            return null;
        }
        ChangeControl ctl = this.control(cd);
        if (ctl == null) {
            return null;
        }
        LabelTypes labelTypes = ctl.getLabelTypes();
        if (cd.change().getStatus().isOpen()) {
            return this.labelsForOpenChange(cd, labelTypes, standard, detailed);
        }
        return this.labelsForClosedChange(cd, labelTypes, standard, detailed);
    }

    private Map<String, LabelInfo> labelsForOpenChange(ChangeData cd, LabelTypes labelTypes, boolean standard, boolean detailed) throws OrmException {
        Map<String, LabelInfo> labels = this.initLabels(cd, labelTypes, standard);
        if (detailed) {
            this.setAllApprovals(cd, labels);
        }
        for (Map.Entry<String, LabelInfo> e : labels.entrySet()) {
            LabelType type = labelTypes.byLabel(e.getKey());
            if (type == null) continue;
            if (standard) {
                for (PatchSetApproval psa : cd.currentApprovals()) {
                    if (!type.matches(psa)) continue;
                    short val = psa.getValue();
                    Account.Id accountId = psa.getAccountId();
                    this.setLabelScores(type, e.getValue(), val, accountId);
                }
            }
            if (!detailed) continue;
            this.setLabelValues(type, e.getValue());
        }
        return labels;
    }

    private Map<String, LabelInfo> initLabels(ChangeData cd, LabelTypes labelTypes, boolean standard) throws OrmException {
        TreeMap<String, LabelInfo> labels = new TreeMap<String, LabelInfo>(labelTypes.nameComparator());
        for (SubmitRecord rec : this.submitRecords(cd)) {
            if (rec.labels == null) continue;
            for (SubmitRecord.Label r : rec.labels) {
                LabelInfo p = (LabelInfo)labels.get(r.label);
                if (p != null && p._status.compareTo(r.status) >= 0) continue;
                LabelInfo n = new LabelInfo();
                n._status = r.status;
                if (standard) {
                    switch (r.status) {
                        case OK: {
                            n.approved = this.accountLoader.get(r.appliedBy);
                            break;
                        }
                        case REJECT: {
                            n.rejected = this.accountLoader.get(r.appliedBy);
                            n.blocking = true;
                            break;
                        }
                    }
                }
                n.optional = n._status == SubmitRecord.Label.Status.MAY ? Boolean.valueOf(true) : null;
                labels.put(r.label, n);
            }
        }
        return labels;
    }

    private void setLabelScores(LabelType type, LabelInfo label, short score, Account.Id accountId) throws OrmException {
        if (label.approved != null || label.rejected != null) {
            return;
        }
        if (type.getMin() == null || type.getMax() == null) {
            return;
        }
        if (score != 0) {
            if (score == type.getMin().getValue()) {
                label.rejected = this.accountLoader.get(accountId);
            } else if (score == type.getMax().getValue()) {
                label.approved = this.accountLoader.get(accountId);
            } else if (score < 0) {
                label.disliked = this.accountLoader.get(accountId);
                label.value = score;
            } else if (score > 0 && label.disliked == null) {
                label.recommended = this.accountLoader.get(accountId);
                label.value = score;
            }
        }
    }

    private void setAllApprovals(ChangeData cd, Map<String, LabelInfo> labels) throws OrmException {
        ChangeControl baseCtrl = this.control(cd);
        if (baseCtrl == null) {
            return;
        }
        HashSet<Account.Id> allUsers = Sets.newHashSet();
        ListMultimap<PatchSet.Id, PatchSetApproval> allApprovals = cd.approvals();
        for (PatchSetApproval psa : allApprovals.values()) {
            allUsers.add(psa.getAccountId());
        }
        List<PatchSetApproval> currentList = allApprovals.get(baseCtrl.getChange().currentPatchSetId());
        HashBasedTable<Account.Id, String, PatchSetApproval> current = HashBasedTable.create(allUsers.size(), baseCtrl.getLabelTypes().getLabelTypes().size());
        for (PatchSetApproval psa : this.labelNormalizer.normalize(baseCtrl, currentList).getNormalized()) {
            current.put(psa.getAccountId(), psa.getLabel(), psa);
        }
        for (Account.Id accountId : allUsers) {
            IdentifiedUser user = this.userFactory.create(accountId);
            ChangeControl ctl = baseCtrl.forUser(user);
            for (Map.Entry<String, LabelInfo> e : labels.entrySet()) {
                Integer value;
                LabelType lt = ctl.getLabelTypes().byLabel(e.getKey());
                if (lt == null) continue;
                Timestamp date = null;
                PatchSetApproval psa = (PatchSetApproval)current.get(accountId, lt.getName());
                if (psa != null) {
                    value = psa.getValue();
                    date = psa.getGranted();
                } else {
                    value = this.labelNormalizer.canVote(ctl, lt, accountId) ? Integer.valueOf(0) : null;
                }
                e.getValue().addApproval(this.approvalInfo(accountId, value, date));
            }
        }
    }

    private Map<String, LabelInfo> labelsForClosedChange(ChangeData cd, LabelTypes labelTypes, boolean standard, boolean detailed) throws OrmException {
        HashSet<Account.Id> allUsers = Sets.newHashSet();
        for (PatchSetApproval psa : cd.approvals().values()) {
            allUsers.add(psa.getAccountId());
        }
        HashSet<String> labelNames = Sets.newHashSet();
        HashMultimap<Account.Id, PatchSetApproval> current = HashMultimap.create();
        for (PatchSetApproval a : cd.currentApprovals()) {
            LabelType type = labelTypes.byLabel(a.getLabelId());
            if (type == null || a.getValue() == 0) continue;
            labelNames.add(type.getName());
            current.put(a.getAccountId(), a);
        }
        TreeMap<String, LabelInfo> labels = new TreeMap<String, LabelInfo>(labelTypes.nameComparator());
        for (String name : labelNames) {
            LabelType type = labelTypes.byLabel(name);
            LabelInfo li = new LabelInfo();
            if (detailed) {
                this.setLabelValues(type, li);
            }
            labels.put(type.getName(), li);
        }
        for (Account.Id accountId : allUsers) {
            HashMap byLabel = Maps.newHashMapWithExpectedSize(labels.size());
            if (detailed) {
                for (Map.Entry entry : labels.entrySet()) {
                    ApprovalInfo ai = this.approvalInfo(accountId, 0, null);
                    byLabel.put(entry.getKey(), ai);
                    ((LabelInfo)entry.getValue()).addApproval(ai);
                }
            }
            for (PatchSetApproval psa : current.get(accountId)) {
                LabelType type = labelTypes.byLabel(psa.getLabelId());
                if (type == null) continue;
                short val = psa.getValue();
                ApprovalInfo info = (ApprovalInfo)byLabel.get(type.getName());
                if (info != null) {
                    info.value = val;
                    info.date = psa.getGranted();
                }
                LabelInfo li = (LabelInfo)labels.get(type.getName());
                if (!standard) continue;
                this.setLabelScores(type, li, val, accountId);
            }
        }
        return labels;
    }

    private ApprovalInfo approvalInfo(Account.Id id, Integer value, Timestamp date) {
        ApprovalInfo ai = new ApprovalInfo(id);
        ai.value = value;
        ai.date = date;
        this.accountLoader.put(ai);
        return ai;
    }

    private static boolean isOnlyZero(Collection<String> values) {
        return values.isEmpty() || values.size() == 1 && values.contains(" 0");
    }

    private void setLabelValues(LabelType type, LabelInfo label) {
        label.values = Maps.newLinkedHashMap();
        for (LabelValue v : type.getValues()) {
            label.values.put(v.formatValue(), v.getText());
        }
        if (ChangeJson.isOnlyZero(label.values.keySet())) {
            label.values = null;
        }
    }

    private Map<String, Collection<String>> permittedLabels(ChangeData cd) throws OrmException {
        ChangeControl ctl = this.control(cd);
        if (ctl == null) {
            return null;
        }
        LabelTypes labelTypes = ctl.getLabelTypes();
        LinkedHashMultimap<String, String> permitted = LinkedHashMultimap.create();
        for (SubmitRecord rec : this.submitRecords(cd)) {
            if (rec.labels == null) continue;
            for (SubmitRecord.Label r : rec.labels) {
                LabelType type = labelTypes.byLabel(r.label);
                if (type == null) continue;
                PermissionRange range = ctl.getRange(Permission.forLabel(r.label));
                for (LabelValue v : type.getValues()) {
                    if (!range.contains(v.getValue())) continue;
                    permitted.put(r.label, v.formatValue());
                }
            }
        }
        ArrayList<String> toClear = Lists.newArrayListWithCapacity(permitted.keySet().size());
        for (Map.Entry e : permitted.asMap().entrySet()) {
            if (!ChangeJson.isOnlyZero(e.getValue())) continue;
            toClear.add((String)e.getKey());
        }
        for (String label : toClear) {
            permitted.removeAll(label);
        }
        return permitted.asMap();
    }

    private Collection<ChangeMessageInfo> messages(ChangeData cd) throws OrmException {
        List<ChangeMessage> messages = this.db.get().changeMessages().byChange(cd.getId()).toList();
        if (messages.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(messages, new Comparator<ChangeMessage>(){

            @Override
            public int compare(ChangeMessage a, ChangeMessage b) {
                return a.getWrittenOn().compareTo(b.getWrittenOn());
            }
        });
        ArrayList<ChangeMessageInfo> result = Lists.newArrayListWithCapacity(messages.size());
        for (ChangeMessage message : messages) {
            PatchSet.Id patchNum = message.getPatchSetId();
            ChangeMessageInfo cmi = new ChangeMessageInfo();
            cmi.id = message.getKey().get();
            cmi.author = this.accountLoader.get(message.getAuthor());
            cmi.date = message.getWrittenOn();
            cmi.message = message.getMessage();
            cmi._revisionNumber = patchNum != null ? Integer.valueOf(patchNum.get()) : null;
            result.add(cmi);
        }
        return result;
    }

    private Collection<AccountInfo> removableReviewers(ChangeData cd, Collection<LabelInfo> labels) throws OrmException {
        ChangeControl ctl = this.control(cd);
        if (ctl == null) {
            return null;
        }
        HashSet<Account.Id> fixed = Sets.newHashSetWithExpectedSize(labels.size());
        HashSet<Account.Id> removable = Sets.newHashSetWithExpectedSize(labels.size());
        for (LabelInfo label : labels) {
            if (label.all == null) continue;
            for (ApprovalInfo ai : label.all) {
                if (ctl.canRemoveReviewer(ai._id, Objects.firstNonNull(ai.value, 0))) {
                    removable.add(ai._id);
                    continue;
                }
                fixed.add(ai._id);
            }
        }
        removable.removeAll(fixed);
        ArrayList<AccountInfo> result = Lists.newArrayListWithCapacity(removable.size());
        for (Account.Id id : removable) {
            result.add(this.accountLoader.get(id));
        }
        return result;
    }

    private void ensureReviewedLoaded(Iterable<ChangeData> all) throws OrmException {
        this.reviewed = Sets.newHashSet();
        if (this.userProvider.get().isIdentifiedUser()) {
            Account.Id self = ((IdentifiedUser)this.userProvider.get()).getAccountId();
            for (List<ChangeData> batch : Iterables.partition(all, 50)) {
                ArrayList<ResultSet<ChangeMessage>> m = Lists.newArrayListWithCapacity(batch.size());
                for (ChangeData cd : batch) {
                    PatchSet.Id ps = cd.change().currentPatchSetId();
                    if (ps != null && cd.change().getStatus().isOpen()) {
                        m.add(this.db.get().changeMessages().byPatchSet(ps));
                        continue;
                    }
                    m.add(NO_MESSAGES);
                }
                for (int i = 0; i < m.size(); ++i) {
                    if (!this.isChangeReviewed(self, batch.get(i), ((ResultSet)m.get(i)).toList())) continue;
                    this.reviewed.add(batch.get(i).getId());
                }
            }
        }
    }

    private boolean isChangeReviewed(Account.Id self, ChangeData cd, List<ChangeMessage> msgs) throws OrmException {
        Collections.sort(msgs, new Comparator<ChangeMessage>(){

            @Override
            public int compare(ChangeMessage a, ChangeMessage b) {
                return b.getWrittenOn().compareTo(a.getWrittenOn());
            }
        });
        Account.Id changeOwnerId = cd.change().getOwner();
        for (ChangeMessage cm : msgs) {
            if (self.equals(cm.getAuthor())) {
                return true;
            }
            if (!changeOwnerId.equals(cm.getAuthor())) continue;
            return false;
        }
        return false;
    }

    private Map<String, RevisionInfo> revisions(ChangeData cd, Optional<PatchSet.Id> limitToPsId) throws OrmException {
        Collection<PatchSet> src;
        ChangeControl ctl = this.control(cd);
        if (ctl == null) {
            return null;
        }
        if (this.has(ListChangesOption.ALL_REVISIONS)) {
            src = cd.patches();
        } else {
            PatchSet ps;
            if (limitToPsId.isPresent()) {
                ps = cd.patch(limitToPsId.get());
                if (ps == null) {
                    throw new OrmException("missing patch set " + limitToPsId.get());
                }
            } else {
                ps = cd.currentPatchSet();
                if (ps == null) {
                    throw new OrmException("missing current patch set for change " + cd.getId());
                }
            }
            src = Collections.singletonList(ps);
        }
        LinkedHashMap<String, RevisionInfo> res = Maps.newLinkedHashMap();
        for (PatchSet in : src) {
            if (!ctl.isPatchVisible(in, this.db.get())) continue;
            res.put(in.getRevision().get(), this.toRevisionInfo(cd, in));
        }
        return res;
    }

    private RevisionInfo toRevisionInfo(ChangeData cd, PatchSet in) throws OrmException {
        RevisionInfo out = new RevisionInfo();
        out.isCurrent = in.getId().equals(cd.change().currentPatchSetId());
        out._number = in.getId().get();
        out.draft = in.isDraft() ? Boolean.valueOf(true) : null;
        out.fetch = this.makeFetchMap(cd, in);
        if (this.has(ListChangesOption.ALL_COMMITS) || out.isCurrent && this.has(ListChangesOption.CURRENT_COMMIT)) {
            try {
                out.commit = this.toCommit(in);
            }
            catch (PatchSetInfoNotAvailableException e) {
                log.warn("Cannot load PatchSetInfo " + in.getId(), e);
            }
        }
        if (this.has(ListChangesOption.ALL_FILES) || out.isCurrent && this.has(ListChangesOption.CURRENT_FILES)) {
            try {
                out.files = this.fileInfoJson.toFileInfoMap(cd.change(), in);
                out.files.remove("/COMMIT_MSG");
            }
            catch (PatchListNotAvailableException e) {
                log.warn("Cannot load PatchList " + in.getId(), e);
            }
        }
        if ((out.isCurrent || out.draft != null && out.draft.booleanValue()) && this.has(ListChangesOption.CURRENT_ACTIONS) && this.userProvider.get().isIdentifiedUser()) {
            out.actions = Maps.newTreeMap();
            for (UiAction.Description d : UiActions.from(this.revisions, new RevisionResource(this.changes.parse(this.control(cd)), in), this.userProvider)) {
                out.actions.put(d.getId(), new ActionInfo(d));
            }
        }
        if (this.has(ListChangesOption.DRAFT_COMMENTS) && this.userProvider.get().isIdentifiedUser()) {
            IdentifiedUser user = (IdentifiedUser)this.userProvider.get();
            out.hasDraftComments = this.db.get().patchComments().draftByPatchSetAuthor(in.getId(), user.getAccountId()).iterator().hasNext() ? Boolean.valueOf(true) : null;
        }
        return out;
    }

    CommitInfo toCommit(PatchSet in) throws PatchSetInfoNotAvailableException {
        PatchSetInfo info = this.patchSetInfoFactory.get(this.db.get(), in.getId());
        CommitInfo commit = new CommitInfo();
        commit.parents = Lists.newArrayListWithCapacity(info.getParents().size());
        commit.author = ChangeJson.toGitPerson(info.getAuthor());
        commit.committer = ChangeJson.toGitPerson(info.getCommitter());
        commit.subject = info.getSubject();
        commit.message = info.getMessage();
        for (PatchSetInfo.ParentInfo parent : info.getParents()) {
            CommitInfo i = new CommitInfo();
            i.commit = parent.id.get();
            i.subject = parent.shortMessage;
            commit.parents.add(i);
        }
        return commit;
    }

    private Map<String, FetchInfo> makeFetchMap(ChangeData cd, PatchSet in) throws OrmException {
        LinkedHashMap<String, FetchInfo> r = Maps.newLinkedHashMap();
        for (DynamicMap.Entry<DownloadScheme> entry : this.downloadSchemes) {
            String schemeName = entry.getExportName();
            DownloadScheme scheme = entry.getProvider().get();
            if (!scheme.isEnabled() || scheme.isAuthRequired() && !this.userProvider.get().isIdentifiedUser()) continue;
            ChangeControl ctl = this.control(cd);
            if (!scheme.isAuthSupported() && !ctl.forUser(this.anonymous).isPatchVisible(in, this.db.get())) continue;
            String projectName = ctl.getProject().getNameKey().get();
            String url = scheme.getUrl(projectName);
            String refName = in.getRefName();
            FetchInfo fetchInfo = new FetchInfo(url, refName);
            r.put(schemeName, fetchInfo);
            if (!this.has(ListChangesOption.DOWNLOAD_COMMANDS)) continue;
            for (DynamicMap.Entry<DownloadCommand> entry2 : this.downloadCommands) {
                String commandName = entry2.getExportName();
                DownloadCommand command = entry2.getProvider().get();
                String c = command.getCommand(scheme, projectName, refName);
                if (c == null) continue;
                this.addCommand(fetchInfo, commandName, c);
            }
        }
        return r;
    }

    private void addCommand(FetchInfo fetchInfo, String commandName, String c) {
        if (fetchInfo.commands == null) {
            fetchInfo.commands = Maps.newTreeMap();
        }
        fetchInfo.commands.put(commandName, c);
    }

    private static GitPerson toGitPerson(UserIdentity committer) {
        GitPerson p = new GitPerson();
        p.name = committer.getName();
        p.email = committer.getEmail();
        p.date = committer.getDate();
        p.tz = committer.getTimeZone();
        return p;
    }

    public static class ChangeMessageInfo {
        public String id;
        public AccountInfo author;
        public Timestamp date;
        public String message;
        public Integer _revisionNumber;
    }

    public static class ApprovalInfo
    extends AccountInfo {
        public Integer value;
        public Timestamp date;

        ApprovalInfo(Account.Id id) {
            super(id);
        }
    }

    public static class LabelInfo {
        transient SubmitRecord.Label.Status _status;
        public AccountInfo approved;
        public AccountInfo rejected;
        public AccountInfo recommended;
        public AccountInfo disliked;
        public List<ApprovalInfo> all;
        public Map<String, String> values;
        public Short value;
        public Boolean optional;
        public Boolean blocking;

        void addApproval(ApprovalInfo ai) {
            if (this.all == null) {
                this.all = Lists.newArrayList();
            }
            this.all.add(ai);
        }
    }

    public static class ChangeInfo {
        public final String kind = "gerritcodereview#change";
        public String id;
        public String project;
        public String branch;
        public String topic;
        public String changeId;
        public String subject;
        public Change.Status status;
        public Timestamp created;
        public Timestamp updated;
        public Boolean starred;
        public Boolean reviewed;
        public Boolean mergeable;
        public Integer insertions;
        public Integer deletions;
        public String _sortkey;
        public int _number;
        public AccountInfo owner;
        public Map<String, ActionInfo> actions;
        public Map<String, LabelInfo> labels;
        public Map<String, Collection<String>> permittedLabels;
        public Collection<AccountInfo> removableReviewers;
        public Collection<ChangeMessageInfo> messages;
        public String currentRevision;
        public Map<String, RevisionInfo> revisions;
        public Boolean _moreChanges;

        void finish() {
            this.id = Joiner.on('~').join(Url.encode(this.project), Url.encode(this.branch), Url.encode(this.changeId));
        }
    }
}

