/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.changes.Side;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.change.CommentInfo;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class ListDrafts
implements RestReadView<RevisionResource> {
    protected final Provider<ReviewDb> db;
    private final AccountInfo.Loader.Factory accountLoaderFactory;

    @Inject
    ListDrafts(Provider<ReviewDb> db, AccountInfo.Loader.Factory alf) {
        this.db = db;
        this.accountLoaderFactory = alf;
    }

    protected Iterable<PatchLineComment> listComments(RevisionResource rsrc) throws OrmException {
        return this.db.get().patchComments().draftByPatchSetAuthor(rsrc.getPatchSet().getId(), rsrc.getAccountId());
    }

    protected boolean includeAuthorInfo() {
        return false;
    }

    public Map<String, List<CommentInfo>> apply(RevisionResource rsrc) throws OrmException {
        TreeMap<String, List<CommentInfo>> out = Maps.newTreeMap();
        AccountInfo.Loader accountLoader = this.includeAuthorInfo() ? this.accountLoaderFactory.create(true) : null;
        for (PatchLineComment c : this.listComments(rsrc)) {
            CommentInfo o = new CommentInfo(c, accountLoader);
            ArrayList<CommentInfo> list = (ArrayList<CommentInfo>)out.get(o.path);
            if (list == null) {
                list = Lists.newArrayList();
                out.put(o.path, list);
            }
            o.path = null;
            list.add(o);
        }
        for (List list : out.values()) {
            Collections.sort(list, new Comparator<CommentInfo>(){

                @Override
                public int compare(CommentInfo a, CommentInfo b) {
                    int c = Objects.firstNonNull(a.side, Side.REVISION).ordinal() - Objects.firstNonNull(b.side, Side.REVISION).ordinal();
                    if (c == 0) {
                        c = Objects.firstNonNull(a.line, 0) - Objects.firstNonNull(b.line, 0);
                    }
                    if (c == 0) {
                        c = a.id.compareTo(b.id);
                    }
                    return c;
                }
            });
        }
        if (accountLoader != null) {
            accountLoader.fill();
        }
        return out;
    }
}

