/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.RestApiModule;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.change.Abandon;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.CherryPick;
import com.google.gerrit.server.change.CommentResource;
import com.google.gerrit.server.change.Comments;
import com.google.gerrit.server.change.CreateDraft;
import com.google.gerrit.server.change.DeleteDraft;
import com.google.gerrit.server.change.DeleteDraftChange;
import com.google.gerrit.server.change.DeleteDraftPatchSet;
import com.google.gerrit.server.change.DeleteReviewer;
import com.google.gerrit.server.change.DraftResource;
import com.google.gerrit.server.change.Drafts;
import com.google.gerrit.server.change.EditMessage;
import com.google.gerrit.server.change.EmailReviewComments;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.change.Files;
import com.google.gerrit.server.change.GetArchive;
import com.google.gerrit.server.change.GetChange;
import com.google.gerrit.server.change.GetComment;
import com.google.gerrit.server.change.GetCommit;
import com.google.gerrit.server.change.GetContent;
import com.google.gerrit.server.change.GetDetail;
import com.google.gerrit.server.change.GetDiff;
import com.google.gerrit.server.change.GetDraft;
import com.google.gerrit.server.change.GetPatch;
import com.google.gerrit.server.change.GetRelated;
import com.google.gerrit.server.change.GetReview;
import com.google.gerrit.server.change.GetReviewer;
import com.google.gerrit.server.change.GetTopic;
import com.google.gerrit.server.change.IncludedIn;
import com.google.gerrit.server.change.Index;
import com.google.gerrit.server.change.Mergeable;
import com.google.gerrit.server.change.PatchSetInserter;
import com.google.gerrit.server.change.PostReview;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.change.Publish;
import com.google.gerrit.server.change.PutDraft;
import com.google.gerrit.server.change.PutTopic;
import com.google.gerrit.server.change.Rebase;
import com.google.gerrit.server.change.Restore;
import com.google.gerrit.server.change.Revert;
import com.google.gerrit.server.change.Reviewed;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.change.Reviewers;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Revisions;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.change.SuggestReviewers;
import com.google.gerrit.server.change.TestSubmitRule;
import com.google.gerrit.server.change.TestSubmitType;
import com.google.gerrit.server.config.FactoryModule;

public class Module
extends RestApiModule {
    @Override
    protected void configure() {
        this.bind(ChangesCollection.class);
        this.bind(Revisions.class);
        this.bind(Reviewers.class);
        this.bind(Drafts.class);
        this.bind(Comments.class);
        this.bind(Files.class);
        DynamicMap.mapOf(this.binder(), ChangeResource.CHANGE_KIND);
        DynamicMap.mapOf(this.binder(), CommentResource.COMMENT_KIND);
        DynamicMap.mapOf(this.binder(), DraftResource.DRAFT_KIND);
        DynamicMap.mapOf(this.binder(), FileResource.FILE_KIND);
        DynamicMap.mapOf(this.binder(), ReviewerResource.REVIEWER_KIND);
        DynamicMap.mapOf(this.binder(), RevisionResource.REVISION_KIND);
        this.get(ChangeResource.CHANGE_KIND).to(GetChange.class);
        this.get(ChangeResource.CHANGE_KIND, "detail").to(GetDetail.class);
        this.get(ChangeResource.CHANGE_KIND, "topic").to(GetTopic.class);
        this.get(ChangeResource.CHANGE_KIND, "in").to(IncludedIn.class);
        this.put(ChangeResource.CHANGE_KIND, "topic").to(PutTopic.class);
        this.delete(ChangeResource.CHANGE_KIND, "topic").to(PutTopic.class);
        this.delete(ChangeResource.CHANGE_KIND).to(DeleteDraftChange.class);
        this.post(ChangeResource.CHANGE_KIND, "abandon").to(Abandon.class);
        this.post(ChangeResource.CHANGE_KIND, "publish").to(Publish.CurrentRevision.class);
        this.post(ChangeResource.CHANGE_KIND, "restore").to(Restore.class);
        this.post(ChangeResource.CHANGE_KIND, "revert").to(Revert.class);
        this.post(ChangeResource.CHANGE_KIND, "submit").to(Submit.CurrentRevision.class);
        this.post(ChangeResource.CHANGE_KIND, "rebase").to(Rebase.CurrentRevision.class);
        this.post(ChangeResource.CHANGE_KIND, "index").to(Index.class);
        this.post(ChangeResource.CHANGE_KIND, "reviewers").to(PostReviewers.class);
        this.get(ChangeResource.CHANGE_KIND, "suggest_reviewers").to(SuggestReviewers.class);
        this.child(ChangeResource.CHANGE_KIND, "reviewers").to(Reviewers.class);
        this.get(ReviewerResource.REVIEWER_KIND).to(GetReviewer.class);
        this.delete(ReviewerResource.REVIEWER_KIND).to(DeleteReviewer.class);
        this.child(ChangeResource.CHANGE_KIND, "revisions").to(Revisions.class);
        this.post(RevisionResource.REVISION_KIND, "cherrypick").to(CherryPick.class);
        this.get(RevisionResource.REVISION_KIND, "commit").to(GetCommit.class);
        this.delete(RevisionResource.REVISION_KIND).to(DeleteDraftPatchSet.class);
        this.get(RevisionResource.REVISION_KIND, "mergeable").to(Mergeable.class);
        this.post(RevisionResource.REVISION_KIND, "publish").to(Publish.class);
        this.get(RevisionResource.REVISION_KIND, "related").to(GetRelated.class);
        this.get(RevisionResource.REVISION_KIND, "review").to(GetReview.class);
        this.post(RevisionResource.REVISION_KIND, "review").to(PostReview.class);
        this.post(RevisionResource.REVISION_KIND, "submit").to(Submit.class);
        this.post(RevisionResource.REVISION_KIND, "rebase").to(Rebase.class);
        this.post(RevisionResource.REVISION_KIND, "message").to(EditMessage.class);
        this.get(RevisionResource.REVISION_KIND, "patch").to(GetPatch.class);
        this.get(RevisionResource.REVISION_KIND, "submit_type").to(TestSubmitType.Get.class);
        this.post(RevisionResource.REVISION_KIND, "test.submit_rule").to(TestSubmitRule.class);
        this.post(RevisionResource.REVISION_KIND, "test.submit_type").to(TestSubmitType.class);
        this.get(RevisionResource.REVISION_KIND, "archive").to(GetArchive.class);
        this.child(RevisionResource.REVISION_KIND, "drafts").to(Drafts.class);
        this.put(RevisionResource.REVISION_KIND, "drafts").to(CreateDraft.class);
        this.get(DraftResource.DRAFT_KIND).to(GetDraft.class);
        this.put(DraftResource.DRAFT_KIND).to(PutDraft.class);
        this.delete(DraftResource.DRAFT_KIND).to(DeleteDraft.class);
        this.child(RevisionResource.REVISION_KIND, "comments").to(Comments.class);
        this.get(CommentResource.COMMENT_KIND).to(GetComment.class);
        this.child(RevisionResource.REVISION_KIND, "files").to(Files.class);
        this.put(FileResource.FILE_KIND, "reviewed").to(Reviewed.PutReviewed.class);
        this.delete(FileResource.FILE_KIND, "reviewed").to(Reviewed.DeleteReviewed.class);
        this.get(FileResource.FILE_KIND, "content").to(GetContent.class);
        this.get(FileResource.FILE_KIND, "diff").to(GetDiff.class);
        this.install(new FactoryModule(){

            @Override
            protected void configure() {
                this.factory(ReviewerResource.Factory.class);
                this.factory(AccountInfo.Loader.Factory.class);
                this.factory(EmailReviewComments.Factory.class);
                this.factory(ChangeInserter.Factory.class);
                this.factory(PatchSetInserter.Factory.class);
            }
        });
    }
}

