/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalCopier;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.MergeabilityChecker;
import com.google.gerrit.server.events.CommitReceivedEvent;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.validators.CommitValidationException;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.mail.ReplacePatchSetSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.ReviewerState;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.ssh.NoSshInfo;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchSetInserter {
    private static final Logger log = LoggerFactory.getLogger(PatchSetInserter.class);
    private final ChangeHooks hooks;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final ReviewDb db;
    private final ChangeUpdate.Factory updateFactory;
    private final GitReferenceUpdated gitRefUpdated;
    private final CommitValidators.Factory commitValidatorsFactory;
    private final MergeabilityChecker mergeabilityChecker;
    private final ReplacePatchSetSender.Factory replacePatchSetFactory;
    private final ApprovalsUtil approvalsUtil;
    private final ApprovalCopier approvalCopier;
    private final Repository git;
    private final RevWalk revWalk;
    private final RevCommit commit;
    private final ChangeControl ctl;
    private final IdentifiedUser user;
    private PatchSet patchSet;
    private ChangeMessage changeMessage;
    private boolean copyLabels;
    private SshInfo sshInfo;
    private ValidatePolicy validatePolicy = ValidatePolicy.GERRIT;
    private boolean draft;
    private boolean runHooks;
    private boolean sendMail;
    private Account.Id uploader;

    @Inject
    public PatchSetInserter(ChangeHooks hooks, ReviewDb db, ChangeUpdate.Factory updateFactory, ApprovalsUtil approvalsUtil, ApprovalCopier approvalCopier, PatchSetInfoFactory patchSetInfoFactory, GitReferenceUpdated gitRefUpdated, CommitValidators.Factory commitValidatorsFactory, MergeabilityChecker mergeabilityChecker, ReplacePatchSetSender.Factory replacePatchSetFactory, @Assisted Repository git, @Assisted RevWalk revWalk, @Assisted ChangeControl ctl, @Assisted RevCommit commit) {
        Preconditions.checkArgument(ctl.getCurrentUser().isIdentifiedUser(), "only IdentifiedUser may create patch set on change %s", ctl.getChange().getId());
        this.hooks = hooks;
        this.db = db;
        this.updateFactory = updateFactory;
        this.approvalsUtil = approvalsUtil;
        this.approvalCopier = approvalCopier;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.gitRefUpdated = gitRefUpdated;
        this.commitValidatorsFactory = commitValidatorsFactory;
        this.mergeabilityChecker = mergeabilityChecker;
        this.replacePatchSetFactory = replacePatchSetFactory;
        this.git = git;
        this.revWalk = revWalk;
        this.commit = commit;
        this.ctl = ctl;
        this.user = (IdentifiedUser)ctl.getCurrentUser();
        this.runHooks = true;
        this.sendMail = true;
    }

    public PatchSetInserter setPatchSet(PatchSet patchSet) {
        Change c = this.ctl.getChange();
        PatchSet.Id psid = patchSet.getId();
        Preconditions.checkArgument(psid.getParentKey().equals(c.getId()), "patch set %s not for change %s", psid, c.getId());
        Preconditions.checkArgument(psid.get() > c.currentPatchSetId().get(), "new patch set ID %s is not greater than current patch set ID %s", psid.get(), c.currentPatchSetId().get());
        this.patchSet = patchSet;
        return this;
    }

    public PatchSet.Id getPatchSetId() throws IOException {
        this.init();
        return this.patchSet.getId();
    }

    public PatchSetInserter setMessage(String message) throws OrmException {
        this.changeMessage = new ChangeMessage(new ChangeMessage.Key(this.ctl.getChange().getId(), ChangeUtil.messageUUID(this.db)), this.user.getAccountId(), TimeUtil.nowTs(), this.patchSet.getId());
        this.changeMessage.setMessage(message);
        return this;
    }

    public PatchSetInserter setMessage(ChangeMessage changeMessage) throws OrmException {
        this.changeMessage = changeMessage;
        return this;
    }

    public PatchSetInserter setCopyLabels(boolean copyLabels) {
        this.copyLabels = copyLabels;
        return this;
    }

    public PatchSetInserter setSshInfo(SshInfo sshInfo) {
        this.sshInfo = sshInfo;
        return this;
    }

    public PatchSetInserter setValidatePolicy(ValidatePolicy validate) {
        this.validatePolicy = Preconditions.checkNotNull(validate);
        return this;
    }

    public PatchSetInserter setDraft(boolean draft) {
        this.draft = draft;
        return this;
    }

    public PatchSetInserter setRunHooks(boolean runHooks) {
        this.runHooks = runHooks;
        return this;
    }

    public PatchSetInserter setSendMail(boolean sendMail) {
        this.sendMail = sendMail;
        return this;
    }

    public PatchSetInserter setUploader(Account.Id uploader) {
        this.uploader = uploader;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change insert() throws InvalidChangeOperationException, OrmException, IOException {
        Change updatedChange;
        this.init();
        this.validate();
        Change c = this.ctl.getChange();
        RefUpdate ru = this.git.updateRef(this.patchSet.getRefName());
        ru.setExpectedOldObjectId(ObjectId.zeroId());
        ru.setNewObjectId(this.commit);
        ru.disableRefLog();
        if (ru.update(this.revWalk) != RefUpdate.Result.NEW) {
            throw new IOException(String.format("Failed to create ref %s in %s: %s", new Object[]{this.patchSet.getRefName(), c.getDest().getParentKey().get(), ru.getResult()}));
        }
        this.gitRefUpdated.fire(c.getProject(), ru);
        final PatchSet.Id currentPatchSetId = c.currentPatchSetId();
        ChangeUpdate update = this.updateFactory.create(this.ctl, this.patchSet.getCreatedOn());
        this.db.changes().beginTransaction(c.getId());
        try {
            if (!this.db.changes().get(c.getId()).getStatus().isOpen()) {
                throw new InvalidChangeOperationException(String.format("Change %s is closed", c.getId()));
            }
            ChangeUtil.insertAncestors(this.db, this.patchSet.getId(), this.commit);
            this.db.patchSets().insert(Collections.singleton(this.patchSet));
            ImmutableSetMultimap<ReviewerState, Account.Id> oldReviewers = this.sendMail ? this.approvalsUtil.getReviewers(this.db, this.ctl.getNotes()) : null;
            updatedChange = this.db.changes().atomicUpdate(c.getId(), new AtomicUpdate<Change>(){

                @Override
                public Change update(Change change) {
                    if (change.getStatus().isClosed()) {
                        return null;
                    }
                    if (!change.currentPatchSetId().equals(currentPatchSetId)) {
                        return null;
                    }
                    if (change.getStatus() != Change.Status.DRAFT) {
                        change.setStatus(Change.Status.NEW);
                    }
                    change.setLastSha1MergeTested(null);
                    change.setCurrentPatchSet(PatchSetInserter.this.patchSetInfoFactory.get(PatchSetInserter.this.commit, PatchSetInserter.this.patchSet.getId()));
                    ChangeUtil.updated(change);
                    return change;
                }
            });
            if (updatedChange == null) {
                throw new ChangeModifiedException(String.format("Change %s was modified", c.getId()));
            }
            if (this.messageIsForChange()) {
                this.insertMessage(this.db);
            }
            if (this.copyLabels) {
                this.approvalCopier.copy(this.db, this.ctl, this.patchSet);
            }
            this.db.commit();
            update.commit();
            if (!this.messageIsForChange()) {
                this.insertMessage(this.db);
            }
            if (this.sendMail) {
                try {
                    PatchSetInfo info = this.patchSetInfoFactory.get(this.commit, this.patchSet.getId());
                    ReplacePatchSetSender cm = this.replacePatchSetFactory.create(updatedChange);
                    cm.setFrom(this.user.getAccountId());
                    cm.setPatchSet(this.patchSet, info);
                    cm.setChangeMessage(this.changeMessage);
                    cm.addReviewers(oldReviewers.get(ReviewerState.REVIEWER));
                    cm.addExtraCC(oldReviewers.get(ReviewerState.CC));
                    cm.send();
                }
                catch (Exception err) {
                    log.error("Cannot send email for new patch set on change " + updatedChange.getId(), err);
                }
            }
        }
        finally {
            this.db.rollback();
        }
        CheckedFuture<?, IOException> f = this.mergeabilityChecker.newCheck().addChange(updatedChange).reindex().runAsync();
        if (this.runHooks) {
            this.hooks.doPatchsetCreatedHook(updatedChange, this.patchSet, this.db);
        }
        f.checkedGet();
        return updatedChange;
    }

    private void init() throws IOException {
        if (this.sshInfo == null) {
            this.sshInfo = new NoSshInfo();
        }
        if (this.patchSet == null) {
            this.patchSet = new PatchSet(ChangeUtil.nextPatchSetId(this.git, this.ctl.getChange().currentPatchSetId()));
            this.patchSet.setCreatedOn(TimeUtil.nowTs());
            this.patchSet.setUploader(this.ctl.getChange().getOwner());
            this.patchSet.setRevision(new RevId(this.commit.name()));
        }
        this.patchSet.setDraft(this.draft);
        if (this.uploader != null) {
            this.patchSet.setUploader(this.uploader);
        }
    }

    private void validate() throws InvalidChangeOperationException {
        CommitValidators cv = this.commitValidatorsFactory.create(this.ctl.getRefControl(), this.sshInfo, this.git);
        String refName = this.patchSet.getRefName();
        CommitReceivedEvent event = new CommitReceivedEvent(new ReceiveCommand(ObjectId.zeroId(), this.commit.getId(), refName.substring(0, refName.lastIndexOf(47) + 1) + "new"), this.ctl.getProjectControl().getProject(), this.ctl.getRefControl().getRefName(), this.commit, this.user);
        try {
            switch (this.validatePolicy) {
                case RECEIVE_COMMITS: {
                    cv.validateForReceiveCommits(event);
                    break;
                }
                case GERRIT: {
                    cv.validateForGerritCommits(event);
                    break;
                }
            }
        }
        catch (CommitValidationException e) {
            throw new InvalidChangeOperationException(e.getMessage());
        }
    }

    private boolean messageIsForChange() {
        return this.changeMessage != null && this.changeMessage.getKey().getParentKey().equals(this.patchSet.getId().getParentKey());
    }

    private void insertMessage(ReviewDb db) throws OrmException {
        if (this.changeMessage != null) {
            db.changeMessages().insert(Collections.singleton(this.changeMessage));
        }
    }

    public class ChangeModifiedException
    extends InvalidChangeOperationException {
        private static final long serialVersionUID = 1L;

        public ChangeModifiedException(String msg) {
            super(msg);
        }
    }

    public static enum ValidatePolicy {
        GERRIT,
        RECEIVE_COMMITS,
        NONE;

    }

    public static interface Factory {
        public PatchSetInserter create(Repository var1, RevWalk var2, ChangeControl var3, RevCommit var4);
    }
}

