/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.changes.Side;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.CommentRange;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.CommentInfo;
import com.google.gerrit.server.change.DeleteDraft;
import com.google.gerrit.server.change.DraftResource;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.Timestamp;
import java.util.Collections;

class PutDraft
implements RestModifyView<DraftResource, Input> {
    private final Provider<ReviewDb> db;
    private final Provider<DeleteDraft> delete;

    @Inject
    PutDraft(Provider<ReviewDb> db, Provider<DeleteDraft> delete) {
        this.db = db;
        this.delete = delete;
    }

    public Response<CommentInfo> apply(DraftResource rsrc, Input in) throws BadRequestException, OrmException {
        PatchLineComment c = rsrc.getComment();
        if (in == null || in.message == null || in.message.trim().isEmpty()) {
            return this.delete.get().apply(rsrc, null);
        }
        if (in.kind != null && !"gerritcodereview#comment".equals(in.kind)) {
            throw new BadRequestException("expected kind gerritcodereview#comment");
        }
        if (in.id != null && !rsrc.getId().equals(in.id)) {
            throw new BadRequestException("id must match URL");
        }
        if (in.line != null && in.line < 0) {
            throw new BadRequestException("line must be >= 0");
        }
        if (in.line != null && in.range != null && in.line.intValue() != in.range.getEndLine()) {
            throw new BadRequestException("range endLine must be on the same line as the comment");
        }
        if (in.path != null && !in.path.equals(c.getKey().getParentKey().getFileName())) {
            this.db.get().patchComments().delete(Collections.singleton(c));
            c = new PatchLineComment(new PatchLineComment.Key(new Patch.Key(rsrc.getPatchSet().getId(), in.path), c.getKey().get()), c.getLine(), rsrc.getAuthorId(), c.getParentUuid(), TimeUtil.nowTs());
            this.db.get().patchComments().insert(Collections.singleton(this.update(c, in)));
        } else {
            this.db.get().patchComments().update(Collections.singleton(this.update(c, in)));
        }
        return Response.ok(new CommentInfo(c, null));
    }

    private PatchLineComment update(PatchLineComment e, Input in) {
        if (in.side != null) {
            e.setSide(in.side == Side.PARENT ? (short)0 : 1);
        }
        if (in.inReplyTo != null) {
            e.setParentUuid(Url.decode(in.inReplyTo));
        }
        e.setMessage(in.message.trim());
        if (in.range != null || in.line != null) {
            e.setRange(in.range);
            e.setLine(in.range != null ? in.range.getEndLine() : in.line.intValue());
        }
        e.setWrittenOn(TimeUtil.nowTs());
        return e;
    }

    static class Input {
        String kind;
        String id;
        String path;
        Side side;
        Integer line;
        String inReplyTo;
        Timestamp updated;
        CommentRange range;
        @DefaultInput
        String message;

        Input() {
        }
    }
}

