/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Collections;

class PutTopic
implements RestModifyView<ChangeResource, Input>,
UiAction<ChangeResource> {
    private final Provider<ReviewDb> dbProvider;
    private final ChangeIndexer indexer;
    private final ChangeHooks hooks;

    @Inject
    PutTopic(Provider<ReviewDb> dbProvider, ChangeIndexer indexer, ChangeHooks hooks) {
        this.dbProvider = dbProvider;
        this.indexer = indexer;
        this.hooks = hooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<String> apply(ChangeResource req, Input input) throws AuthException, OrmException, IOException {
        if (input == null) {
            input = new Input();
        }
        ChangeControl control = req.getControl();
        Change change = req.getChange();
        if (!control.canEditTopicName()) {
            throw new AuthException("changing topic not permitted");
        }
        ReviewDb db = this.dbProvider.get();
        final String newTopicName = Strings.nullToEmpty(input.topic);
        String oldTopicName = Strings.nullToEmpty(change.getTopic());
        if (!oldTopicName.equals(newTopicName)) {
            String summary = oldTopicName.isEmpty() ? "Topic set to " + newTopicName : (newTopicName.isEmpty() ? "Topic " + oldTopicName + " removed" : String.format("Topic changed from %s to %s", oldTopicName, newTopicName));
            IdentifiedUser currentUser = (IdentifiedUser)control.getCurrentUser();
            ChangeMessage cmsg = new ChangeMessage(new ChangeMessage.Key(change.getId(), ChangeUtil.messageUUID(db)), currentUser.getAccountId(), TimeUtil.nowTs(), change.currentPatchSetId());
            cmsg.setMessage(summary);
            db.changes().beginTransaction(change.getId());
            try {
                change = db.changes().atomicUpdate(change.getId(), new AtomicUpdate<Change>(){

                    @Override
                    public Change update(Change change) {
                        change.setTopic(Strings.emptyToNull(newTopicName));
                        ChangeUtil.updated(change);
                        return change;
                    }
                });
                db.changeMessages().insert(Collections.singleton(cmsg));
                db.commit();
            }
            finally {
                db.rollback();
            }
            CheckedFuture<?, IOException> indexFuture = this.indexer.indexAsync(change.getId());
            this.hooks.doTopicChangedHook(change, currentUser.getAccount(), oldTopicName, db);
            indexFuture.checkedGet();
        }
        return Strings.isNullOrEmpty(newTopicName) ? Response.none() : Response.ok(newTopicName);
    }

    @Override
    public UiAction.Description getDescription(ChangeResource resource) {
        return new UiAction.Description().setLabel("Edit Topic").setVisible(resource.getControl().canEditTopicName());
    }

    static class Input {
        @DefaultInput
        String topic;

        Input() {
        }
    }
}

