/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.ReloadSubmitQueueOp;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;

public class MasterNodeStartup
extends LifecycleModule {
    @Override
    public void configure() {
        this.listener().to(Lifecycle.class);
    }

    @Singleton
    static class Lifecycle
    implements LifecycleListener {
        private static final int INITIAL_DELAY_S = 15;
        private final ReloadSubmitQueueOp.Factory submit;
        private final long delay;
        private volatile ScheduledFuture<?> handle;

        @Inject
        Lifecycle(ReloadSubmitQueueOp.Factory submit, @GerritServerConfig Config config) {
            this.submit = submit;
            this.delay = ConfigUtil.getTimeUnit(config, "changeMerge", null, "checkFrequency", TimeUnit.SECONDS.convert(5L, TimeUnit.MINUTES), TimeUnit.SECONDS);
        }

        @Override
        public void start() {
            this.handle = this.delay > 0L ? this.submit.create().startWithFixedDelay(15L, this.delay, TimeUnit.SECONDS) : this.submit.create().start(15L, TimeUnit.SECONDS);
        }

        @Override
        public void stop() {
            ScheduledFuture<?> f = this.handle;
            if (f != null) {
                this.handle = null;
                f.cancel(true);
            }
        }
    }
}

