/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.git.CommitMergeStatus;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class CodeReviewCommit
extends RevCommit {
    private PatchSet.Id patchsetId;
    private ChangeControl control;
    int originalOrder;
    private CommitMergeStatus statusCode;
    List<CodeReviewCommit> missing;

    static CodeReviewCommit error(CommitMergeStatus s) {
        CodeReviewCommit r = new CodeReviewCommit(ObjectId.zeroId());
        r.statusCode = s;
        return r;
    }

    public CodeReviewCommit(AnyObjectId id) {
        super(id);
    }

    public ChangeNotes notes() {
        return this.getControl().getNotes();
    }

    public CommitMergeStatus getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(CommitMergeStatus statusCode) {
        this.statusCode = statusCode;
    }

    public PatchSet.Id getPatchsetId() {
        return this.patchsetId;
    }

    public void setPatchsetId(PatchSet.Id patchsetId) {
        this.patchsetId = patchsetId;
    }

    public void copyFrom(CodeReviewCommit src) {
        this.control = src.control;
        this.patchsetId = src.patchsetId;
        this.originalOrder = src.originalOrder;
        this.statusCode = src.statusCode;
        this.missing = src.missing;
    }

    public Change change() {
        return this.getControl().getChange();
    }

    public ChangeControl getControl() {
        return this.control;
    }

    public void setControl(ChangeControl control) {
        this.control = control;
    }
}

