/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.SubmoduleSubscription;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.CommitMergeStatus;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.SubmoduleException;
import com.google.gerrit.server.util.SubmoduleSectionParser;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmoduleOp {
    private static final Logger log = LoggerFactory.getLogger(SubmoduleOp.class);
    private static final String GIT_MODULES = ".gitmodules";
    private final Branch.NameKey destBranch;
    private RevCommit mergeTip;
    private RevWalk rw;
    private final Provider<String> urlProvider;
    private ReviewDb schema;
    private Repository db;
    private Project destProject;
    private List<Change> submitted;
    private final Map<Change.Id, CodeReviewCommit> commits;
    private final PersonIdent myIdent;
    private final GitRepositoryManager repoManager;
    private final GitReferenceUpdated gitRefUpdated;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final Set<Branch.NameKey> updatedSubscribers;

    @Inject
    public SubmoduleOp(@Assisted Branch.NameKey destBranch, @Assisted RevCommit mergeTip, @Assisted RevWalk rw, @CanonicalWebUrl @Nullable Provider<String> urlProvider, SchemaFactory<ReviewDb> sf, @Assisted Repository db, @Assisted Project destProject, @Assisted List<Change> submitted, @Assisted Map<Change.Id, CodeReviewCommit> commits, @GerritPersonIdent PersonIdent myIdent, GitRepositoryManager repoManager, GitReferenceUpdated gitRefUpdated) {
        this.destBranch = destBranch;
        this.mergeTip = mergeTip;
        this.rw = rw;
        this.urlProvider = urlProvider;
        this.schemaFactory = sf;
        this.db = db;
        this.destProject = destProject;
        this.submitted = submitted;
        this.commits = commits;
        this.myIdent = myIdent;
        this.repoManager = repoManager;
        this.gitRefUpdated = gitRefUpdated;
        this.updatedSubscribers = new HashSet<Branch.NameKey>();
    }

    public void update() throws SubmoduleException {
        try {
            this.schema = this.schemaFactory.open();
            this.updateSubmoduleSubscriptions();
            this.updateSuperProjects(this.destBranch, this.rw, this.mergeTip.getId().toObjectId(), null);
        }
        catch (OrmException e) {
            throw new SubmoduleException("Cannot open database", e);
        }
        finally {
            if (this.schema != null) {
                this.schema.close();
                this.schema = null;
            }
        }
    }

    private void updateSubmoduleSubscriptions() throws SubmoduleException {
        if (this.urlProvider.get() == null) {
            SubmoduleOp.logAndThrowSubmoduleException("Cannot establish canonical web url used to access gerrit. It should be provided in gerrit.config file.");
        }
        try {
            TreeWalk tw = TreeWalk.forPath(this.db, GIT_MODULES, this.mergeTip.getTree());
            if (tw != null && (FileMode.REGULAR_FILE.equals(tw.getRawMode(0)) || FileMode.EXECUTABLE_FILE.equals(tw.getRawMode(0)))) {
                BlobBasedConfig bbc = new BlobBasedConfig(null, this.db, this.mergeTip, GIT_MODULES);
                String thisServer = new URI(this.urlProvider.get()).getHost();
                Branch.NameKey target = new Branch.NameKey(new Project.NameKey(this.destProject.getName()), this.destBranch.get());
                HashSet<SubmoduleSubscription> oldSubscriptions = new HashSet<SubmoduleSubscription>(this.schema.submoduleSubscriptions().bySuperProject(this.destBranch).toList());
                List<SubmoduleSubscription> newSubscriptions = new SubmoduleSectionParser(bbc, thisServer, target, this.repoManager).parseAllSections();
                HashSet<SubmoduleSubscription> alreadySubscribeds = new HashSet<SubmoduleSubscription>();
                for (SubmoduleSubscription s : newSubscriptions) {
                    if (!oldSubscriptions.contains(s)) continue;
                    alreadySubscribeds.add(s);
                }
                oldSubscriptions.removeAll(newSubscriptions);
                newSubscriptions.removeAll(alreadySubscribeds);
                if (!oldSubscriptions.isEmpty()) {
                    this.schema.submoduleSubscriptions().delete(oldSubscriptions);
                }
                this.schema.submoduleSubscriptions().insert(newSubscriptions);
            }
        }
        catch (OrmException e) {
            SubmoduleOp.logAndThrowSubmoduleException("Database problem at update of subscriptions table from .gitmodules file.", e);
        }
        catch (ConfigInvalidException e) {
            SubmoduleOp.logAndThrowSubmoduleException("Problem at update of subscriptions table: .gitmodules config file is invalid.", e);
        }
        catch (IOException e) {
            SubmoduleOp.logAndThrowSubmoduleException("Problem at update of subscriptions table from .gitmodules.", e);
        }
        catch (URISyntaxException e) {
            SubmoduleOp.logAndThrowSubmoduleException("Incorrect gerrit canonical web url provided in gerrit.config file.", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateSuperProjects(Branch.NameKey updatedBranch, RevWalk myRw, ObjectId mergedCommit, String msg) throws SubmoduleException {
        try {
            List<SubmoduleSubscription> subscribers = this.schema.submoduleSubscriptions().bySubmodule(updatedBranch).toList();
            if (subscribers.isEmpty()) return;
            String msgbuf = msg;
            if (msgbuf == null) {
                msgbuf = "";
                this.updatedSubscribers.add(updatedBranch);
                for (Change chg : this.submitted) {
                    CodeReviewCommit c = this.commits.get(chg.getId());
                    if (c == null || c.getStatusCode() != CommitMergeStatus.CLEAN_MERGE && c.getStatusCode() != CommitMergeStatus.CLEAN_PICK && c.getStatusCode() != CommitMergeStatus.CLEAN_REBASE) continue;
                    msgbuf = msgbuf + "\n";
                    msgbuf = msgbuf + c.getFullMessage();
                }
            }
            for (SubmoduleSubscription s : subscribers) {
                if (!this.updatedSubscribers.add(s.getSuperProject())) {
                    log.error("Possible circular subscription involving " + s.toString());
                    continue;
                }
                HashMap<Branch.NameKey, ObjectId> modules = new HashMap<Branch.NameKey, ObjectId>(1);
                modules.put(updatedBranch, mergedCommit);
                HashMap<Branch.NameKey, String> paths = new HashMap<Branch.NameKey, String>(1);
                paths.put(updatedBranch, s.getPath());
                try {
                    this.updateGitlinks(s.getSuperProject(), myRw, modules, paths, msgbuf);
                }
                catch (SubmoduleException e) {
                    throw e;
                    return;
                }
            }
        }
        catch (OrmException e) {
            SubmoduleOp.logAndThrowSubmoduleException("Cannot read subscription records", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGitlinks(Branch.NameKey subscriber, RevWalk myRw, Map<Branch.NameKey, ObjectId> modules, Map<Branch.NameKey, String> paths, String msg) throws SubmoduleException {
        PersonIdent author = null;
        StringBuilder msgbuf = new StringBuilder();
        msgbuf.append("Updated " + subscriber.getParentKey().get());
        Repository pdb = null;
        RevWalk recRw = null;
        try {
            boolean sameAuthorForAll = true;
            for (Map.Entry<Branch.NameKey, ObjectId> me : modules.entrySet()) {
                RevCommit c = myRw.parseCommit(me.getValue());
                if (c == null) continue;
                msgbuf.append("\nProject: ");
                msgbuf.append(me.getKey().getParentKey().get());
                msgbuf.append("  ").append(me.getValue().getName());
                msgbuf.append("\n");
                if (modules.size() == 1 && msg != null) {
                    msgbuf.append(msg);
                } else {
                    msgbuf.append(c.getShortMessage());
                }
                msgbuf.append("\n");
                if (author == null) {
                    author = c.getAuthorIdent();
                    continue;
                }
                if (author.equals(c.getAuthorIdent())) continue;
                sameAuthorForAll = false;
            }
            if (!sameAuthorForAll || author == null) {
                author = this.myIdent;
            }
            if ((pdb = this.repoManager.openRepository(subscriber.getParentKey())).getRef(subscriber.get()) == null) {
                throw new SubmoduleException("The branch was probably deleted from the subscriber repository");
            }
            ObjectId currentCommitId = pdb.getRef(subscriber.get()).getObjectId();
            DirCache dc = SubmoduleOp.readTree(pdb, pdb.getRef(subscriber.get()));
            DirCacheEditor ed = dc.editor();
            for (final Map.Entry<Branch.NameKey, ObjectId> me : modules.entrySet()) {
                ed.add(new DirCacheEditor.PathEdit(paths.get(me.getKey())){

                    @Override
                    public void apply(DirCacheEntry ent) {
                        ent.setFileMode(FileMode.GITLINK);
                        ent.setObjectId(((ObjectId)me.getValue()).copy());
                    }
                });
            }
            ed.finish();
            ObjectInserter oi = pdb.newObjectInserter();
            ObjectId tree = dc.writeTree(oi);
            CommitBuilder commit = new CommitBuilder();
            commit.setTreeId(tree);
            commit.setParentIds(currentCommitId);
            commit.setAuthor(author);
            commit.setCommitter(this.myIdent);
            commit.setMessage(msgbuf.toString());
            oi.insert(commit);
            ObjectId commitId = oi.idFor(1, commit.build());
            RefUpdate rfu = pdb.updateRef(subscriber.get());
            rfu.setForceUpdate(false);
            rfu.setNewObjectId(commitId);
            rfu.setExpectedOldObjectId(currentCommitId);
            rfu.setRefLogMessage("Submit to " + subscriber.getParentKey().get(), true);
            switch (rfu.update()) {
                case NEW: 
                case FAST_FORWARD: {
                    this.gitRefUpdated.fire(subscriber.getParentKey(), rfu);
                    break;
                }
                default: {
                    throw new IOException(rfu.getResult().name());
                }
            }
            recRw = new RevWalk(pdb);
            this.updateSuperProjects(subscriber, recRw, commitId, msgbuf.toString());
        }
        catch (IOException e) {
            SubmoduleOp.logAndThrowSubmoduleException("Cannot update gitlinks for " + subscriber.get(), e);
        }
        finally {
            if (recRw != null) {
                recRw.release();
            }
            if (pdb != null) {
                pdb.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirCache readTree(Repository pdb, Ref branch) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevWalk rw = new RevWalk(pdb);
        try {
            DirCache dc = DirCache.newInCore();
            DirCacheBuilder b = dc.builder();
            b.addTree(new byte[0], 0, pdb.newObjectReader(), rw.parseTree(branch.getObjectId()));
            b.finish();
            DirCache dirCache = dc;
            return dirCache;
        }
        finally {
            rw.release();
        }
    }

    private static void logAndThrowSubmoduleException(String errorMsg, Exception e) throws SubmoduleException {
        log.error(errorMsg, e);
        throw new SubmoduleException(errorMsg, e);
    }

    private static void logAndThrowSubmoduleException(String errorMsg) throws SubmoduleException {
        log.error(errorMsg);
        throw new SubmoduleException(errorMsg);
    }

    public static interface Factory {
        public SubmoduleOp create(Branch.NameKey var1, RevCommit var2, RevWalk var3, Repository var4, Project var5, List<Change> var6, Map<Change.Id, CodeReviewCommit> var7);
    }
}

