/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.PatchSetInserter;
import com.google.gerrit.server.changedetail.PathConflictException;
import com.google.gerrit.server.changedetail.RebaseChange;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.CommitMergeStatus;
import com.google.gerrit.server.git.MergeException;
import com.google.gerrit.server.git.RebaseSorter;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;

public class RebaseIfNecessary
extends SubmitStrategy {
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final RebaseChange rebaseChange;
    private final Map<Change.Id, CodeReviewCommit> newCommits;
    private final PersonIdent committerIdent;

    RebaseIfNecessary(SubmitStrategy.Arguments args, PatchSetInfoFactory patchSetInfoFactory, RebaseChange rebaseChange, PersonIdent committerIdent) {
        super(args);
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.rebaseChange = rebaseChange;
        this.newCommits = new HashMap<Change.Id, CodeReviewCommit>();
        this.committerIdent = committerIdent;
    }

    @Override
    protected CodeReviewCommit _run(CodeReviewCommit mergeTip, List<CodeReviewCommit> toMerge) throws MergeException {
        CodeReviewCommit newMergeTip = mergeTip;
        this.sort(toMerge);
        while (!toMerge.isEmpty()) {
            CodeReviewCommit n = toMerge.remove(0);
            if (newMergeTip == null) {
                newMergeTip = n;
                n.setStatusCode(CommitMergeStatus.CLEAN_MERGE);
            } else if (n.getParentCount() == 0) {
                n.setStatusCode(CommitMergeStatus.CANNOT_REBASE_ROOT);
            } else if (n.getParentCount() == 1) {
                if (this.args.mergeUtil.canFastForward(this.args.mergeSorter, newMergeTip, this.args.rw, n)) {
                    newMergeTip = n;
                    n.setStatusCode(CommitMergeStatus.CLEAN_MERGE);
                } else {
                    try {
                        IdentifiedUser uploader = this.args.identifiedUserFactory.create(this.args.mergeUtil.getSubmitter(n).getAccountId());
                        PatchSet newPatchSet = this.rebaseChange.rebase(this.args.repo, this.args.rw, this.args.inserter, n.getPatchsetId(), n.change(), uploader, newMergeTip, this.args.mergeUtil, this.committerIdent, false, false, PatchSetInserter.ValidatePolicy.NONE);
                        ArrayList<PatchSetApproval> approvals = Lists.newArrayList();
                        for (PatchSetApproval a : this.args.approvalsUtil.byPatchSet(this.args.db, n.notes(), n.getPatchsetId())) {
                            approvals.add(new PatchSetApproval(newPatchSet.getId(), a));
                        }
                        this.args.db.patchSetApprovals().upsert(approvals);
                        newMergeTip = (CodeReviewCommit)this.args.rw.parseCommit(ObjectId.fromString(newPatchSet.getRevision().get()));
                        n.change().setCurrentPatchSet(this.patchSetInfoFactory.get(newMergeTip, newPatchSet.getId()));
                        newMergeTip.copyFrom(n);
                        newMergeTip.setControl(this.args.changeControlFactory.controlFor(n.change(), (CurrentUser)uploader));
                        newMergeTip.setPatchsetId(newPatchSet.getId());
                        newMergeTip.setStatusCode(CommitMergeStatus.CLEAN_REBASE);
                        this.newCommits.put(newPatchSet.getId().getParentKey(), newMergeTip);
                        this.setRefLogIdent(this.args.mergeUtil.getSubmitter(n));
                    }
                    catch (PathConflictException e) {
                        n.setStatusCode(CommitMergeStatus.PATH_CONFLICT);
                    }
                    catch (InvalidChangeOperationException | NoSuchChangeException | OrmException | IOException e) {
                        throw new MergeException("Cannot rebase " + n.name(), e);
                    }
                }
            } else if (n.getParentCount() > 1) {
                try {
                    newMergeTip = this.args.rw.isMergedInto(newMergeTip, n) ? n : this.args.mergeUtil.mergeOneCommit(this.args.myIdent, this.args.repo, this.args.rw, this.args.inserter, this.args.canMergeFlag, this.args.destBranch, newMergeTip, n);
                    PatchSetApproval submitApproval = this.args.mergeUtil.markCleanMerges(this.args.rw, this.args.canMergeFlag, newMergeTip, this.args.alreadyAccepted);
                    this.setRefLogIdent(submitApproval);
                }
                catch (IOException e) {
                    throw new MergeException("Cannot merge " + n.name(), e);
                }
            }
            this.args.alreadyAccepted.add(newMergeTip);
        }
        return newMergeTip;
    }

    private void sort(List<CodeReviewCommit> toSort) throws MergeException {
        try {
            List<CodeReviewCommit> sorted = new RebaseSorter(this.args.rw, this.args.alreadyAccepted, this.args.canMergeFlag).sort(toSort);
            toSort.clear();
            toSort.addAll(sorted);
        }
        catch (IOException e) {
            throw new MergeException("Commit sorting failed", e);
        }
    }

    @Override
    public Map<Change.Id, CodeReviewCommit> getNewCommits() {
        return this.newCommits;
    }

    @Override
    public boolean dryRun(CodeReviewCommit mergeTip, CodeReviewCommit toMerge) throws MergeException {
        return !this.args.mergeUtil.hasMissingDependencies(this.args.mergeSorter, toMerge) && this.args.mergeUtil.canCherryPick(this.args.mergeSorter, this.args.repo, mergeTip, this.args.rw, toMerge);
    }
}

