/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.ChangeIndex;
import com.google.gerrit.server.index.IndexCollection;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.index.IndexedChangeQuery;
import com.google.gerrit.server.query.AndPredicate;
import com.google.gerrit.server.query.NotPredicate;
import com.google.gerrit.server.query.OrPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.AndSource;
import com.google.gerrit.server.query.change.BasicChangeRewrites;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ChangeQueryRewriter;
import com.google.gerrit.server.query.change.ChangeStatusPredicate;
import com.google.gerrit.server.query.change.OrSource;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class IndexRewriteImpl
implements ChangeQueryRewriter {
    public static final Set<Change.Status> OPEN_STATUSES;
    public static final Set<Change.Status> CLOSED_STATUSES;
    @VisibleForTesting
    static final int MAX_LIMIT = 1000;
    private final IndexCollection indexes;
    private final BasicChangeRewrites basicRewrites;

    public static EnumSet<Change.Status> getPossibleStatus(Predicate<ChangeData> in) {
        EnumSet<Change.Status> s = IndexRewriteImpl.extractStatus(in);
        return s != null ? s : EnumSet.allOf(Change.Status.class);
    }

    private static EnumSet<Change.Status> extractStatus(Predicate<ChangeData> in) {
        if (in instanceof ChangeStatusPredicate) {
            return EnumSet.of(((ChangeStatusPredicate)in).getStatus());
        }
        if (in instanceof NotPredicate) {
            EnumSet<Change.Status> s = IndexRewriteImpl.extractStatus(in.getChild(0));
            return s != null ? EnumSet.complementOf(s) : null;
        }
        if (in instanceof OrPredicate) {
            EnumSet<Change.Status> r = null;
            int childrenWithStatus = 0;
            for (int i = 0; i < in.getChildCount(); ++i) {
                EnumSet<Change.Status> c = IndexRewriteImpl.extractStatus(in.getChild(i));
                if (c == null) continue;
                if (r == null) {
                    r = EnumSet.noneOf(Change.Status.class);
                }
                r.addAll(c);
                ++childrenWithStatus;
            }
            if (r != null && childrenWithStatus < in.getChildCount()) {
                return EnumSet.allOf(Change.Status.class);
            }
            return r;
        }
        if (in instanceof AndPredicate) {
            EnumSet<Change.Status> r = null;
            for (int i = 0; i < in.getChildCount(); ++i) {
                EnumSet<Change.Status> c = IndexRewriteImpl.extractStatus(in.getChild(i));
                if (c == null) continue;
                if (r == null) {
                    r = EnumSet.allOf(Change.Status.class);
                }
                r.retainAll(c);
            }
            return r;
        }
        return null;
    }

    @Inject
    IndexRewriteImpl(IndexCollection indexes, BasicChangeRewrites basicRewrites) {
        this.indexes = indexes;
        this.basicRewrites = basicRewrites;
    }

    @Override
    public Predicate<ChangeData> rewrite(Predicate<ChangeData> in, int start) throws QueryParseException {
        ChangeIndex index = this.indexes.getSearchIndex();
        in = this.basicRewrites.rewrite(in);
        int limit = Objects.firstNonNull(ChangeQueryBuilder.getLimit(in), 1000);
        limit += start;
        limit = Math.max(limit, 1);
        Predicate<ChangeData> out = this.rewriteImpl(in, index, limit = Math.min(limit, 1000));
        if (in == out || out instanceof IndexPredicate) {
            return new IndexedChangeQuery(index, out, limit);
        }
        if (out == null) {
            return in;
        }
        return out;
    }

    private Predicate<ChangeData> rewriteImpl(Predicate<ChangeData> in, ChangeIndex index, int limit) throws QueryParseException {
        if (this.isIndexPredicate(in, index)) {
            return in;
        }
        if (!IndexRewriteImpl.isRewritePossible(in)) {
            return null;
        }
        int n = in.getChildCount();
        BitSet isIndexed = new BitSet(n);
        BitSet notIndexed = new BitSet(n);
        BitSet rewritten = new BitSet(n);
        ArrayList<Predicate<ChangeData>> newChildren = Lists.newArrayListWithCapacity(n);
        for (int i = 0; i < n; ++i) {
            Predicate<ChangeData> c = in.getChild(i);
            Predicate<ChangeData> nc = this.rewriteImpl(c, index, limit);
            if (nc == c) {
                isIndexed.set(i);
                newChildren.add(c);
                continue;
            }
            if (nc == null) {
                notIndexed.set(i);
                newChildren.add(c);
                continue;
            }
            rewritten.set(i);
            newChildren.add(nc);
        }
        if (isIndexed.cardinality() == n) {
            return in;
        }
        if (notIndexed.cardinality() == n) {
            return null;
        }
        if (rewritten.cardinality() == n) {
            return in.copy(newChildren);
        }
        return this.partitionChildren(in, newChildren, isIndexed, index, limit);
    }

    private boolean isIndexPredicate(Predicate<ChangeData> in, ChangeIndex index) {
        if (!(in instanceof IndexPredicate)) {
            return false;
        }
        IndexPredicate p = (IndexPredicate)in;
        return index.getSchema().getFields().containsKey(p.getField().getName());
    }

    private Predicate<ChangeData> partitionChildren(Predicate<ChangeData> in, List<Predicate<ChangeData>> newChildren, BitSet isIndexed, ChangeIndex index, int limit) throws QueryParseException {
        if (isIndexed.cardinality() == 1) {
            int i = isIndexed.nextSetBit(0);
            newChildren.add(0, new IndexedChangeQuery(index, newChildren.remove(i), limit));
            return this.copy(in, newChildren);
        }
        ArrayList<Predicate<ChangeData>> indexed = Lists.newArrayListWithCapacity(isIndexed.cardinality());
        ArrayList<Predicate<ChangeData>> all = Lists.newArrayListWithCapacity(newChildren.size() - isIndexed.cardinality() + 1);
        for (int i = 0; i < newChildren.size(); ++i) {
            Predicate<ChangeData> c = newChildren.get(i);
            if (isIndexed.get(i)) {
                indexed.add(c);
                continue;
            }
            all.add(c);
        }
        all.add(0, new IndexedChangeQuery(index, in.copy(indexed), limit));
        return this.copy(in, all);
    }

    private Predicate<ChangeData> copy(Predicate<ChangeData> in, List<Predicate<ChangeData>> all) {
        if (in instanceof AndPredicate) {
            return new AndSource((Collection<? extends Predicate<ChangeData>>)all);
        }
        if (in instanceof OrPredicate) {
            return new OrSource((Collection<? extends Predicate<ChangeData>>)all);
        }
        return in.copy(all);
    }

    private static boolean isRewritePossible(Predicate<ChangeData> p) {
        return p.getChildCount() > 0 && (p instanceof AndPredicate || p instanceof OrPredicate || p instanceof NotPredicate);
    }

    static {
        EnumSet<Change.Status> open = EnumSet.noneOf(Change.Status.class);
        EnumSet<Change.Status> closed = EnumSet.noneOf(Change.Status.class);
        for (Change.Status s : Change.Status.values()) {
            if (s.isOpen()) {
                open.add(s);
                continue;
            }
            closed.add(s);
        }
        OPEN_STATUSES = Sets.immutableEnumSet(open);
        CLOSED_STATUSES = Sets.immutableEnumSet(closed);
    }
}

