/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.reviewdb.client.AccountProjectWatch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.CommentRange;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.mail.EmailArguments;
import com.google.gerrit.server.mail.ReplyToChangeSender;
import com.google.gerrit.server.patch.PatchFile;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gwtorm.client.KeyUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentSender
extends ReplyToChangeSender {
    private static final Logger log = LoggerFactory.getLogger(CommentSender.class);
    private final ReviewInput.NotifyHandling notify;
    private List<PatchLineComment> inlineComments = Collections.emptyList();

    @Inject
    public CommentSender(EmailArguments ea, @Assisted ReviewInput.NotifyHandling notify, @Assisted Change c) {
        super(ea, c, "comment");
        this.notify = notify;
    }

    public void setPatchLineComments(List<PatchLineComment> plc) {
        this.inlineComments = plc;
        HashSet<String> paths = new HashSet<String>();
        for (PatchLineComment c : plc) {
            Patch.Key p = c.getKey().getParentKey();
            if ("/COMMIT_MSG".equals(p.getFileName())) continue;
            paths.add(p.getFileName());
        }
        this.changeData.setCurrentFilePaths(Ordering.natural().sortedCopy(paths));
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        if (this.notify.compareTo(ReviewInput.NotifyHandling.OWNER_REVIEWERS) >= 0) {
            this.ccAllApprovals();
        }
        if (this.notify.compareTo(ReviewInput.NotifyHandling.ALL) >= 0) {
            this.bccStarredBy();
            this.includeWatchers(AccountProjectWatch.NotifyType.ALL_COMMENTS);
        }
    }

    @Override
    public void formatChange() throws EmailException {
        this.appendText(this.velocifyFile("Comment.vm"));
    }

    @Override
    public void formatFooter() throws EmailException {
        this.appendText(this.velocifyFile("CommentFooter.vm"));
    }

    public boolean hasInlineComments() {
        return !this.inlineComments.isEmpty();
    }

    public String getInlineComments() {
        return this.getInlineComments(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInlineComments(int lines) {
        StringBuilder cmts = new StringBuilder();
        try (Repository repo = this.getRepository();){
            PatchList patchList = null;
            if (repo != null) {
                try {
                    patchList = this.getPatchList();
                }
                catch (PatchListNotAvailableException e) {
                    patchList = null;
                }
            }
            Patch.Key currentFileKey = null;
            PatchFile currentFileData = null;
            for (PatchLineComment c : this.inlineComments) {
                Patch.Key pk = c.getKey().getParentKey();
                if (!pk.equals(currentFileKey)) {
                    String link = this.makeLink(pk);
                    if (link != null) {
                        cmts.append(link).append('\n');
                    }
                    if ("/COMMIT_MSG".equals(pk.get())) {
                        cmts.append("Commit Message:\n\n");
                    } else {
                        cmts.append("File ").append(pk.get()).append(":\n\n");
                    }
                    currentFileKey = pk;
                    if (patchList != null) {
                        try {
                            currentFileData = new PatchFile(repo, patchList, pk.get());
                        }
                        catch (IOException e) {
                            log.warn(String.format("Cannot load %s from %s in %s", pk.getFileName(), patchList.getNewId().name(), this.projectState.getProject().getName()), e);
                            currentFileData = null;
                        }
                    }
                }
                if (currentFileData != null) {
                    this.appendComment(cmts, lines, currentFileData, c);
                }
                cmts.append("\n\n");
            }
        }
        return cmts.toString();
    }

    private void appendComment(StringBuilder out, int contextLines, PatchFile currentFileData, PatchLineComment comment) {
        short side = comment.getSide();
        CommentRange range = comment.getRange();
        if (range != null) {
            String prefix = String.format("Line %d: ", range.getStartLine());
            for (int n = range.getStartLine(); n <= range.getEndLine(); ++n) {
                out.append(n == range.getStartLine() ? prefix : Strings.padStart(": ", prefix.length(), ' '));
                try {
                    String s = currentFileData.getLine(side, n);
                    if (n == range.getStartLine() && n == range.getEndLine()) {
                        s = s.substring(Math.min(range.getStartCharacter(), s.length()), Math.min(range.getEndCharacter(), s.length()));
                    } else if (n == range.getStartLine()) {
                        s = s.substring(Math.min(range.getStartCharacter(), s.length()));
                    } else if (n == range.getEndLine()) {
                        s = s.substring(0, Math.min(range.getEndCharacter(), s.length()));
                    }
                    out.append(s);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                out.append('\n');
            }
            this.appendQuotedParent(out, comment);
            out.append(comment.getMessage().trim()).append('\n');
        } else {
            int line;
            int maxLines;
            int lineNbr = comment.getLine();
            try {
                maxLines = currentFileData.getLineCount(side);
            }
            catch (Throwable e) {
                maxLines = lineNbr;
            }
            int startLine = Math.max(1, lineNbr - contextLines + 1);
            int stopLine = Math.min(maxLines, lineNbr + contextLines);
            for (line = startLine; line <= lineNbr; ++line) {
                this.appendFileLine(out, currentFileData, side, line);
            }
            this.appendQuotedParent(out, comment);
            out.append(comment.getMessage().trim()).append('\n');
            for (line = lineNbr + 1; line < stopLine; ++line) {
                this.appendFileLine(out, currentFileData, side, line);
            }
        }
    }

    private void appendFileLine(StringBuilder cmts, PatchFile fileData, short side, int line) {
        cmts.append("Line " + line);
        try {
            String lineStr = fileData.getLine(side, line);
            cmts.append(": ");
            cmts.append(lineStr);
        }
        catch (Throwable e) {
            // empty catch block
        }
        cmts.append("\n");
    }

    private void appendQuotedParent(StringBuilder out, PatchLineComment child) {
        if (child.getParentUuid() != null) {
            PatchLineComment parent;
            try {
                parent = this.args.db.get().patchComments().get(new PatchLineComment.Key(child.getKey().getParentKey(), child.getParentUuid()));
            }
            catch (OrmException e) {
                parent = null;
            }
            if (parent != null) {
                int lf;
                String msg = parent.getMessage().trim();
                if (msg.length() > 75) {
                    msg = msg.substring(0, 75);
                }
                if ((lf = msg.indexOf(10)) > 0) {
                    msg = msg.substring(0, lf);
                }
                out.append("> ").append(msg).append('\n');
            }
        }
    }

    private String makeLink(Patch.Key patch) {
        String url = this.getGerritUrl();
        if (url == null) {
            return null;
        }
        PatchSet.Id ps = patch.getParentKey();
        Change.Id c = ps.getParentKey();
        return url + "#/c/" + c + '/' + ps.get() + '/' + KeyUtil.encode(patch.get());
    }

    private Repository getRepository() {
        try {
            return this.args.server.openRepository(this.projectState.getProject().getNameKey());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static interface Factory {
        public CommentSender create(ReviewInput.NotifyHandling var1, Change var2);
    }
}

